<?php

if (!function_exists('arther_construct_cat_section')) {
    /**
     * Display category section on homepage
     *
     * @since 1.0.0
     *
     */
    function arther_construct_cat_section()
    {
        global $arther_theme_options;
        if ((is_front_page()) && ($arther_theme_options['arther-enable-category-boxes'] == 1)) {
            /**
             * arther_single_cat_posts hook.
             *
             * @since 1.0.0
             *
             * @hooked arther_constuct_single_cat_posts - 10
             */
            do_action('arther_single_cat_posts');
        }
    }
}
add_action('arther_cat_section', 'arther_construct_cat_section', 10);


if (!function_exists('arther_constuct_single_cat_posts')) {
    /**
     * Display latest posts boxes of 3 different categories
     *
     * @since 1.0.0
     *
     */
    function arther_constuct_single_cat_posts()
    {
        global $arther_theme_options;
        $cat1 = absint($arther_theme_options['arther-single-cat-posts-select-1']);
        if (!empty($cat1)) {
?>
            <section class="promo-section red sec-spacing">
                <div class="container">
                    <div class="row">
                        <?php
                        $arther_cat_post_args = array(
                            'category__in' => $cat1,
                            'post_type' => 'post',
                            'posts_per_page' => 3,
                            'post_status' => 'publish',
                            'ignore_sticky_posts' => true
                        );
                        $arther_featured_query = new WP_Query($arther_cat_post_args);
                        if ($arther_featured_query->have_posts()) :

                            while ($arther_featured_query->have_posts()) : $arther_featured_query->the_post();
                        ?>
                                <div class="col-1-1 col-sm-1-2 col-md-1-3">
                                    <div class="card card-bg-image card-promo">
                                        <figure class="card_media">
                                            <a href="<?php the_permalink(); ?>">
                                                <?php
                                                if (has_post_thumbnail()) {
                                                    the_post_thumbnail('arther-medium');
                                                } else {
                                                ?>
                                                    <img src="<?php echo esc_url(get_template_directory_uri()) . '/candidthemes/assets/custom/img/arther-medium.jpg' ?>" alt="<?php the_title(); ?>">
                                                <?php
                                                }
                                                ?>
                                                <div class="card_body">
                                                    <div class="card-cat">
                                                        <?php
                                                            $tags = get_the_tags();
                                                            if (!empty($tags)) {
                                                                $tag_name = $tags[0]->name;
                                                                echo esc_html($tag_name);
                                                            } else {
                                                                echo esc_html(get_cat_name($cat1));
                                                            }

                                                        ?>
                                                    </div>
                                                </div>
                                            </a>
                                            
                                        </figure>                                      
                                        <h3 class="card_title">
                                            <a href="<?php the_permalink(); ?>">
                                                <?php the_title(); ?>
                                                
                                            </a>
                                        </h3>
                                    </div>
                                </div>
                        <?php
                            endwhile;
                        endif;
                        wp_reset_postdata();
                        ?>
                    </div>
                </div>
            </section>
            <?php
        }
    }
}
add_action('arther_single_cat_posts', 'arther_constuct_single_cat_posts', 10);



if (!function_exists('arther_posts_navigation')) {
    /**
     * Display pagination based on type seclected
     *
     * @since 1.0.0
     *
     */
    function arther_posts_navigation()
    {
        global $arther_theme_options;
        if ($arther_theme_options['arther-pagination-options'] == 'numeric') {
            the_posts_pagination();
        } elseif ($arther_theme_options['arther-pagination-options'] == 'ajax') {
            $page_number = get_query_var('paged');
            if ($page_number == 0) {
                $output_page = 2;
            } else {
                $output_page = $page_number + 1;
            }
            if (paginate_links()) {
                echo "<div class='ajax-pagination text-center'><div class='show-more' data-number='$output_page'><i class='fa fa-refresh'></i>" . __('Load More', 'arther') . "</div><div id='free-temp-post'></div></div>";
            }
        } else {
            the_posts_navigation();
        }
    }
}
add_action('arther_action_navigation', 'arther_posts_navigation', 10);


if (!function_exists('arther_related_post')) :
    /**
     * Display related posts from same category
     *
     * @param int $post_id
     * @return void
     *
     * @since 1.0.0
     *
     */
    function arther_related_post($post_id)
    {

        global $arther_theme_options;
        if ($arther_theme_options['arther-single-page-related-posts'] == 0) {
            return;
        }
        $categories = get_the_category($post_id);
        if ($categories) {
            $category_ids = array();
            $category = get_category($category_ids);
            $categories = get_the_category($post_id);
            foreach ($categories as $category) {
                $category_ids[] = $category->term_id;
            }
            $count = $category->category_count;
            if ($count > 1) { ?>
                <div class="related-post">
                    <?php
                    $arther_related_post_title = esc_html($arther_theme_options['arther-single-page-related-posts-title']);
                    if (!empty($arther_related_post_title)) :
                    ?>
                        <h2 class="post-title"><?php echo esc_html($arther_related_post_title); ?></h2>
                    <?php
                    endif;

                    $arther_cat_post_args = array(
                        'category__in' => $category_ids,
                        'post__not_in' => array($post_id),
                        'post_type' => 'post',
                        'posts_per_page' => 2,
                        'post_status' => 'publish',
                        'ignore_sticky_posts' => true
                    );
                    $arther_featured_query = new WP_Query($arther_cat_post_args);
                    ?>
                    <div class="row">
                        <?php
                        if ($arther_featured_query->have_posts()) :

                            while ($arther_featured_query->have_posts()) : $arther_featured_query->the_post();
                        ?>
                                <div class="col-1-1 col-sm-1-2 col-md-1-2">
                                    <div class="card card-blog-post card-full-width">
                                        <?php
                                        if (has_post_thumbnail()) :
                                        ?>
                                            <figure class="card_media">
                                                <a href="<?php the_permalink() ?>">
                                                    <?php the_post_thumbnail('arther-medium'); ?>
                                                </a>
                                            </figure>
                                        <?php
                                        endif;
                                        ?>
                                        <div class="card_body">
                                            <?php arther_list_category(); ?>
                                            <h4 class="card_title">
                                                <a href="<?php the_permalink() ?>">
                                                    <?php the_title(); ?>
                                                </a>
                                            </h4>
                                            <div class="entry-meta">
                                                <?php
                                                arther_posted_on();
                                                arther_posted_by();
                                                ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php
                            endwhile;
                            ?>
                    </div>

                <?php
                        endif;
                        wp_reset_postdata();
                ?>
                </div> <!-- .related-post -->
            <?php
            }
        }
    }
endif;
add_action('arther_related_posts', 'arther_related_post', 10, 1);


if (!function_exists('arther_constuct_carousel')) {
    /**
     * Add carousel on header
     *
     * @since 1.0.0
     */
    function arther_constuct_carousel()
    {

        if (is_front_page()) {
            global $arther_theme_options;
            if ($arther_theme_options['arther-enable-slider'] != 1)
                return false;
            $featured_cat = absint($arther_theme_options['arther-select-category']);
            $arther_slider_args = array();
            if (is_rtl()) {
                $arther_slider_args['rtl'] = true;
            }
            $arther_slider_args_encoded = wp_json_encode($arther_slider_args);
            $query_args = array(
                'post_type' => 'post',
                'ignore_sticky_posts' => true,
                'posts_per_page' => 6,
                'cat' => $featured_cat
            );

            $query = new WP_Query($query_args);
            if ($query->have_posts()) :
            ?>
                <section class="hero hero-slider-section">
                    <div class="">
                        <!-- slick slider component start -->
                        <div class="hero_slick-slider" data-slick='<?php echo $arther_slider_args_encoded; ?>'>
                            <?php
                            $i = 1;
                            while ($query->have_posts()) :
                                $query->the_post();

                            ?>
                                <div class="card card-bg-image">
                                    <?php
                                    if (has_post_thumbnail()) {
                                    ?>
                                        <div class="post-thumb">
                                            <figure class="card_media">
                                                <a href="<?php the_permalink(); ?>">
                                                    <?php
                                                    $cropped_image = $arther_theme_options['arther-image-size-slider'];
                                                    if ($cropped_image == 'cropped-image') {
                                                        the_post_thumbnail('arther-large');
                                                    } else {
                                                        the_post_thumbnail();
                                                    }
                                                    ?>
                                                </a>
                                            </figure>
                                        </div>
                                    <?php
                                    } else {
                                    ?>
                                        <div class="post-thumb">
                                            <a href="<?php the_permalink(); ?>">

                                                <img src="<?php echo esc_url(get_template_directory_uri()) . '/candidthemes/assets/custom/img/arther-default.jpg' ?>" alt="<?php the_title(); ?>">

                                            </a>
                                        </div>
                                    <?php
                                    }
                                    ?>
                                    <article class="card_body">
                                        <?php
                                        arther_list_category();
                                        ?>

                                        <h3 class="card_title">
                                            <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                        </h3>

                                        <div class="entry-meta">
                                            <?php
                                            arther_posted_by();
                                            arther_posted_on();                                            ?>
                                        </div>
                                    </article>

                                </div>
                            <?php
                                $i++;

                            endwhile;
                            ?>
                        </div>
                    </div>
                </section><!-- .hero -->
            <?php
            endif;
            wp_reset_postdata();
        } //is_front_page
    }
}
add_action('arther_carousel', 'arther_constuct_carousel', 10);


if (!function_exists('arther_breadcrumb_options')) :
    /**
     * Functions to manage breadcrumbs
     */
    function arther_breadcrumb_options()
    {
        global $arther_theme_options;
        if (($arther_theme_options['arther-blog-site-breadcrumb'] == 1) && !is_front_page()) {
            $breadcrumb_from = $arther_theme_options['arther-breadcrumb-display-from-option'];

            if ((function_exists('yoast_breadcrumb')) && ($breadcrumb_from == 'yoast-breadcrumb')) {
            ?>
                <div class="arther-breadcrumb-wrapper">
                    <?php
                    yoast_breadcrumb();
                    ?>
                </div>
            <?php
            } elseif ((function_exists('rank_math_the_breadcrumbs')) && ($breadcrumb_from == 'rankmath-breadcrumb')) {
            ?>
                <div class="arther-breadcrumb-wrapper">
                    <?php
                    rank_math_the_breadcrumbs();
                    ?>
                </div>
            <?php
            } elseif ((function_exists('bcn_display')) && ($breadcrumb_from == 'breadcrumb-navxt')) {
            ?>
                <div class="arther-breadcrumb-wrapper">
                    <?php
                    bcn_display();
                    ?>
                </div>
            <?php
            } else {
            ?>
                <div class="arther-breadcrumb-wrapper">
                    <?php
                    arther_breadcrumbs();
                    ?>
                </div>
<?php
            }
        }
    }
endif;
add_action('arther_breadcrumb', 'arther_breadcrumb_options', 10);


/**
 * BreadCrumb Settings
 */
if (!function_exists('arther_breadcrumbs')) :
    function arther_breadcrumbs()
    {
        $breadcrumb_args = array(
            'container' => 'div',
            'show_browse' => false
        );
        global $arther_theme_options;

        $arther_you_are_here_text = esc_html($arther_theme_options['arther-breadcrumb-text']);


        if (!empty($arther_you_are_here_text)) {
            $arther_you_are_here_text = "<span class='breadcrumb'>" . $arther_you_are_here_text . "</span>";
        }
        echo "<div class='breadcrumbs init-animate clearfix'>" . $arther_you_are_here_text . "<div id='arther-breadcrumbs' class='clearfix'>";
        breadcrumb_trail($breadcrumb_args);
        echo "</div></div>";
    }
endif;
