<?php
/**
 *  Arther Top Header Option
 *
 * @since Arther 1.0.0
 *
 */
/*Top Header Options*/
$wp_customize->add_section( 'arther_header_section', array(
   'priority'       => 5,
   'capability'     => 'edit_theme_options',
   'theme_supports' => '',
   'title'          => __( 'Top Header Options', 'arther' ),
   'panel' 		 => 'arther_panel',
) );
/*callback functions header section*/
if ( !function_exists('arther_header_active_callback') ) :
  function arther_header_active_callback(){
      global $arther_theme_options;
      $arther_theme_options = arther_get_options_value();
      $enable_header = absint($arther_theme_options['arther-enable-top-header']);
      if( true == $enable_header ){
          return true;
      }
      else{
          return false;
      }
  }
endif;
/*Enable Top Header Section*/
$wp_customize->add_setting( 'arther_options[arther-enable-top-header]', array(
   'capability'        => 'edit_theme_options',
   'transport' => 'refresh',
   'default'           => $default['arther-enable-top-header'],
   'sanitize_callback' => 'arther_sanitize_checkbox'
) );
$wp_customize->add_control( 'arther_options[arther-enable-top-header]', array(
   'label'     => __( 'Enable Top Header', 'arther' ),
   'description' => __('Checked to show the top header section like search and social icons', 'arther'),
   'section'   => 'arther_header_section',
   'settings'  => 'arther_options[arther-enable-top-header]',
   'type'      => 'checkbox',
   'priority'  => 5,
) );
/*Enable Social Icons In Header*/
$wp_customize->add_setting( 'arther_options[arther-enable-top-header-social]', array(
   'capability'        => 'edit_theme_options',
   'transport' => 'refresh',
   'default'           => $default['arther-enable-top-header-social'],
   'sanitize_callback' => 'arther_sanitize_checkbox'
) );
$wp_customize->add_control( 'arther_options[arther-enable-top-header-social]', array(
   'label'     => __( 'Enable Social Icons', 'arther' ),
   'description' => __('You can show the social icons here. Manage social icons from Appearance > Menus. Social Menu will display here.', 'arther'),
   'section'   => 'arther_header_section',
   'settings'  => 'arther_options[arther-enable-top-header-social]',
   'type'      => 'checkbox',
   'priority'  => 5,
   'active_callback'=>'arther_header_active_callback'
) );

/*Enable Menu in top Header*/
$wp_customize->add_setting( 'arther_options[arther-enable-top-header-menu]', array(
    'capability'        => 'edit_theme_options',
    'transport' => 'refresh',
    'default'           => $default['arther-enable-top-header-menu'],
    'sanitize_callback' => 'arther_sanitize_checkbox'
) );
$wp_customize->add_control( 'arther_options[arther-enable-top-header-menu]', array(
    'label'     => __( 'Menu in Header', 'arther' ),
    'description' => __('Top Header Menu will display here. Go to Appearance < Menu.', 'arther'),
    'section'   => 'arther_header_section',
    'settings'  => 'arther_options[arther-enable-top-header-menu]',
    'type'      => 'checkbox',
    'priority'  => 5,
    'active_callback'=>'arther_header_active_callback'
) );

/*Enable Date in top Header*/
$wp_customize->add_setting( 'arther_options[arther-enable-top-header-search]', array(
    'capability'        => 'edit_theme_options',
    'transport' => 'refresh',
    'default'           => $default['arther-enable-top-header-search'],
    'sanitize_callback' => 'arther_sanitize_checkbox'
) );
$wp_customize->add_control( 'arther_options[arther-enable-top-header-search]', array(
    'label'     => __( 'Search in Header', 'arther' ),
    'description' => __('Enable Search icon in Header', 'arther'),
    'section'   => 'arther_header_section',
    'settings'  => 'arther_options[arther-enable-top-header-search]',
    'type'      => 'checkbox',
    'priority'  => 5,
    'active_callback'=>'arther_header_active_callback'
) );