<?php
/**
 *  Arther Single Page Option
 *
 * @since Arther 1.0.0
 *
 */
/*Single Page Options*/
$wp_customize->add_section( 'arther_single_page_section', array(
   'priority'       => 40,
   'capability'     => 'edit_theme_options',
   'theme_supports' => '',
   'title'          => __( 'Single Post Options', 'arther' ),
   'panel' 		 => 'arther_panel',
) );


/*Featured Image Option*/
$wp_customize->add_setting( 'arther_options[arther-single-page-featured-image]', array(
    'capability'        => 'edit_theme_options',
    'transport' => 'refresh',
    'default'           => $default['arther-single-page-featured-image'],
    'sanitize_callback' => 'arther_sanitize_checkbox'
) );
$wp_customize->add_control( 'arther_options[arther-single-page-featured-image]', array(
    'label'     => __( 'Enable Featured Image', 'arther' ),
    'description' => __('You can hide or show featured image on single page.', 'arther'),
    'section'   => 'arther_single_page_section',
    'settings'  => 'arther_options[arther-single-page-featured-image]',
    'type'      => 'checkbox',
    'priority'  => 15,
) );

/*Hide Tags in Single Page*/
$wp_customize->add_setting( 'arther_options[arther-single-page-tags]', array(
    'capability'        => 'edit_theme_options',
    'transport' => 'refresh',
    'default'           => $default['arther-single-page-tags'],
    'sanitize_callback' => 'arther_sanitize_checkbox'
) );
$wp_customize->add_control( 'arther_options[arther-single-page-tags]', array(
    'label'     => __( 'Enable Posts Tags', 'arther' ),
    'description' => __('You can enable the post tags in single page.', 'arther'),
    'section'   => 'arther_single_page_section',
    'settings'  => 'arther_options[arther-single-page-tags]',
    'type'      => 'checkbox',
    'priority'  => 15,
) );
/*Enable Underline in single post link place */
$wp_customize->add_setting( 'arther_options[arther-enable-underline-link]', array(
    'capability'        => 'edit_theme_options',
    'transport' => 'refresh',
    'default'           => $default['arther-enable-underline-link'],
    'sanitize_callback' => 'arther_sanitize_checkbox'
) );
$wp_customize->add_control( 'arther_options[arther-enable-underline-link]', array(
    'label'     => __( 'Enable Underline on Link', 'arther' ),
    'description' => __('If you enabled this, you will see the underline in the links. You can change it color from the general section of colors.', 'arther'),
    'section'   => 'arther_single_page_section',
    'settings'  => 'arther_options[arther-enable-underline-link]',
    'type'      => 'checkbox',
    'priority'  => 20,
) );

/*Related Post Options*/
$wp_customize->add_setting( 'arther_options[arther-single-page-related-posts]', array(
    'capability'        => 'edit_theme_options',
    'transport' => 'refresh',
    'default'           => $default['arther-single-page-related-posts'],
    'sanitize_callback' => 'arther_sanitize_checkbox'
) );
$wp_customize->add_control( 'arther_options[arther-single-page-related-posts]', array(
    'label'     => __( 'Enable Related Posts', 'arther' ),
    'description' => __('3 Post from similar category will display at the end of the page.', 'arther'),
    'section'   => 'arther_single_page_section',
    'settings'  => 'arther_options[arther-single-page-related-posts]',
    'type'      => 'checkbox',
    'priority'  => 20,
) );
/*callback functions related posts*/
if ( !function_exists('arther_related_post_callback') ) :
    function arther_related_post_callback(){
        global $arther_theme_options;
        $arther_theme_options = arther_get_options_value();
        $related_posts = absint($arther_theme_options['arther-single-page-related-posts']);
        if( true == $related_posts ){
            return true;
        }
        else{
            return false;
        }
    }
endif;
/*Related Post Title*/
$wp_customize->add_setting( 'arther_options[arther-single-page-related-posts-title]', array(
    'capability'        => 'edit_theme_options',
    'transport' => 'refresh',
    'default'           => $default['arther-single-page-related-posts-title'],
    'sanitize_callback' => 'sanitize_text_field'
) );
$wp_customize->add_control( 'arther_options[arther-single-page-related-posts-title]', array(
    'label'     => __( 'Related Posts Title', 'arther' ),
    'description' => __('Give the appropriate title for related posts', 'arther'),
    'section'   => 'arther_single_page_section',
    'settings'  => 'arther_options[arther-single-page-related-posts-title]',
    'type'      => 'text',
    'priority'  => 20,
    'active_callback'=>'arther_related_post_callback'
) );