<?php
/**
 *  Arther Sidebar Option
 *
 * @since Arther 1.0.0
 *
 */
/*Blog Page Options*/
$wp_customize->add_section( 'arther_sidebar_section', array(
   'priority'       => 45,
   'capability'     => 'edit_theme_options',
   'theme_supports' => '',
   'title'          => __( 'Sidebar Options', 'arther' ),
   'panel' 		 => 'arther_panel',
) );
/*Blog Page Sidebar Layout*/
$wp_customize->add_setting( 'arther_options[arther-sidebar-blog-page]', array(
    'capability'        => 'edit_theme_options',
    'transport' => 'refresh',
    'default'           => $default['arther-sidebar-blog-page'],
    'sanitize_callback' => 'arther_sanitize_select'
) );
$wp_customize->add_control( 'arther_options[arther-sidebar-blog-page]', array(
   'choices' => array(
    'right-sidebar'   => __('Right Sidebar','arther'),
    'left-sidebar'    => __('Left Sidebar','arther'),
    'no-sidebar'      => __('No Sidebar','arther'),
    'middle-column'   => __('Middle Column','arther')
),
   'label'     => __( 'Blog Page Sidebar Layout', 'arther' ),
   'description' => __('This sidebar will work for the blog, archive, category, author pages. More options is in pro theme.', 'arther'),
   'section'   => 'arther_sidebar_section',
   'settings'  => 'arther_options[arther-sidebar-blog-page]',
   'type'      => 'select',
   'priority'  => 10,
) );

/*Inner Page Sidebar Layout*/
$wp_customize->add_setting( 'arther_options[arther-sidebar-single-page]', array(
    'capability'        => 'edit_theme_options',
    'transport' => 'refresh',
    'default'           => $default['arther-sidebar-single-page'],
    'sanitize_callback' => 'arther_sanitize_select'
) );
$wp_customize->add_control( 'arther_options[arther-sidebar-single-page]', array(
   'choices' => array(
    'right-sidebar'   => __('Right Sidebar','arther'),
    'left-sidebar'    => __('Left Sidebar','arther'),
    'no-sidebar'      => __('No Sidebar','arther'),
    'middle-column'   => __('Middle Column','arther')
),
   'label'     => __( 'Inner Pages Sidebar Layout', 'arther' ),
   'description' => __('This sidebar will work for the single page and post. More options is in pro theme.', 'arther'),
   'section'   => 'arther_sidebar_section',
   'settings'  => 'arther_options[arther-sidebar-single-page]',
   'type'      => 'select',
   'priority'  => 10,
) );


/*Sticky Sidebar Setting*/
$wp_customize->add_setting( 'arther_options[arther-enable-sticky-sidebar]', array(
    'capability'        => 'edit_theme_options',
    'transport' => 'refresh',
    'default'           => $default['arther-enable-sticky-sidebar'],
    'sanitize_callback' => 'arther_sanitize_checkbox'
) );
$wp_customize->add_control( 'arther_options[arther-enable-sticky-sidebar]', array(
    'label'     => __( 'Sticky Sidebar Option', 'arther' ),
    'description' => __('Enable and Disable sticky sidebar from this section.', 'arther'),
    'section'   => 'arther_sidebar_section',
    'settings'  => 'arther_options[arther-enable-sticky-sidebar]',
    'type'      => 'checkbox',
    'priority'  => 15,
) );