<?php
/**
 * Arther Footer Option
 *
 * @since Arther 1.0.0
 *
 */
/*Footer Options*/
$wp_customize->add_section( 'arther_footer_section', array(
   'priority'       => 55,
   'capability'     => 'edit_theme_options',
   'theme_supports' => '',
   'title'          => __( 'Footer Options', 'arther' ),
   'panel' 		 => 'arther_panel',
) );
/*Copyright Setting*/
$wp_customize->add_setting( 'arther_options[arther-footer-copyright]', array(
    'capability'        => 'edit_theme_options',
    'transport' => 'refresh',
    'default'           => $default['arther-footer-copyright'],
    'sanitize_callback' => 'sanitize_text_field'
) );
$wp_customize->add_control( 'arther_options[arther-footer-copyright]', array(
    'label'     => __( 'Copyright Text', 'arther' ),
    'description' => __('Enter your own copyright text.', 'arther'),
    'section'   => 'arther_footer_section',
    'settings'  => 'arther_options[arther-footer-copyright]',
    'type'      => 'text',
    'priority'  => 15,
) );
/*Go to Top Setting*/
$wp_customize->add_setting( 'arther_options[arther-go-to-top]', array(
    'capability'        => 'edit_theme_options',
    'transport' => 'refresh',
    'default'           => $default['arther-go-to-top'],
    'sanitize_callback' => 'arther_sanitize_checkbox'
) );
$wp_customize->add_control( 'arther_options[arther-go-to-top]', array(
    'label'     => __( 'Enable Go to Top', 'arther' ),
    'description' => __('Checked to Enable Go to Top', 'arther'),
    'section'   => 'arther_footer_section',
    'settings'  => 'arther_options[arther-go-to-top]',
    'type'      => 'checkbox',
    'priority'  => 15,
) );
/*callback functions header section*/
if ( !function_exists('arther_go_to_top_active_callback') ) :
    function arther_go_to_top_active_callback(){
        global $arther_theme_options;
        $arther_theme_options = arther_get_options_value();
        $go_to_top_class = absint($arther_theme_options['arther-go-to-top']);
        if( true == $go_to_top_class ){
            return true;
        }
        else{
            return false;
        }
    }
  endif;

/*Go to top Icon*/
$wp_customize->add_setting( 'arther_options[arther-go-to-top-icon]', array(
    'capability'        => 'edit_theme_options',
    'transport' => 'refresh',
    'default'           => $default['arther-go-to-top-icon'],
    'sanitize_callback' => 'sanitize_text_field'
) );
$wp_customize->add_control( 'arther_options[arther-go-to-top-icon]', array(
    'label'     => __( 'Font awesome class', 'arther' ),
    'description' => sprintf('%1$s <a href="%2$s" target="_blank">%3$s</a> %4$s',
        __( 'Enter Fontawesome class like fa-long-arrow-up, fa-angle-up, etc. You can find more icons here in', 'arther' ),
        esc_url('https://fontawesome.com/v4.7/icons/'),
        __('Fontawesome lists and icons name' , 'arther'),
        __('so that you can use any icon from here.' ,'arther')
    ),
    'section'   => 'arther_footer_section',
    'settings'  => 'arther_options[arther-go-to-top-icon]',
    'type'      => 'text',
    'priority'  => 15,
    'active_callback'=> 'arther_go_to_top_active_callback',
) );

/*Go to top Icon for new font awesome*/
$wp_customize->add_setting( 'arther_options[arther-go-to-top-icon-new]', array(
    'capability'        => 'edit_theme_options',
    'transport' => 'refresh',
    'default'           => $default['arther-go-to-top-icon-new'],
    'sanitize_callback' => 'sanitize_text_field'
) );
$wp_customize->add_control( 'arther_options[arther-go-to-top-icon-new]', array(
    'label'     => __( 'Font awesome class for font awesome 5', 'arther' ),
    'description' => sprintf('%1$s <a href="%2$s" target="_blank">%3$s</a> %4$s',
        __( 'Enter Fontawesome class like fa-long-arrow-alt-up, fa-angle-up, etc. You can find more icons here in', 'arther' ),
        esc_url('https://fontawesome.com/v5.15/icons?d=gallery&p=2'),
        __('Fontawesome 5 lists and icons name' , 'arther'),
        __('so that you can use any icon from here.' ,'arther')
    ),
    'section'   => 'arther_footer_section',
    'settings'  => 'arther_options[arther-go-to-top-icon-new]',
    'type'      => 'text',
    'priority'  => 15,
    'active_callback'=> 'arther_go_to_top_active_callback',
) );

/*Social Icons Footer*/
$wp_customize->add_setting( 'arther_options[arther-footer-social-icons]', array(
    'capability'        => 'edit_theme_options',
    'transport' => 'refresh',
    'default'           => $default['arther-footer-social-icons'],
    'sanitize_callback' => 'arther_sanitize_checkbox'
) );
$wp_customize->add_control( 'arther_options[arther-footer-social-icons]', array(
    'label'     => __( 'Enable Social Icons', 'arther' ),
    'description' => __('Checked to Enable Social Icons. Make Social Menus from Appearance > Menus.', 'arther'),
    'section'   => 'arther_footer_section',
    'settings'  => 'arther_options[arther-footer-social-icons]',
    'type'      => 'checkbox',
    'priority'  => 15,
) );

if(function_exists('mc4wp_get_form')) {

    /*Enable Subscribe in Footer*/
    $wp_customize->add_setting('arther_options[arther-footer-mailchimp-subscribe]', array(
        'capability' => 'edit_theme_options',
        'transport' => 'refresh',
        'default' => $default['arther-footer-mailchimp-subscribe'],
        'sanitize_callback' => 'arther_sanitize_checkbox'
    ));
    $wp_customize->add_control('arther_options[arther-footer-mailchimp-subscribe]', array(
        'label' => __('Mailchimp Subscribe Form', 'arther'),
        'description' => sprintf('%1$s <a href="%2$s" target="_blank">%3$s</a> %4$s',
        __( 'Install and Customize', 'arther' ),
        esc_url('https://wordpress.org/plugins/mailchimp-for-wp/'),
        __('Mailchimp Subscribe Plugin' , 'arther'),
        __('and paste the form ID below.' ,'arther')
    ),
        'section' => 'arther_footer_section',
        'settings' => 'arther_options[arther-footer-mailchimp-subscribe]',
        'type' => 'checkbox',
        'priority' => 15,
    ));

    /*callback functions mailchimp enable*/
    if (!function_exists('arther_footer_mailchimp_enable')) :
        function arther_footer_mailchimp_enable()
        {
            global $arther_theme_options;
            $arther_theme_options = arther_get_options_value();
            $enable_mailchimp = absint($arther_theme_options['arther-footer-mailchimp-subscribe']);
            if ($enable_mailchimp == true) {
                return true;
            } else {
                return false;
            }
        }
    endif;

    /*Enable Mailchimp form Id in Footer*/
    $wp_customize->add_setting('arther_options[arther-footer-mailchimp-form-id]', array(
        'capability' => 'edit_theme_options',
        'transport' => 'refresh',
        'default' => $default['arther-footer-mailchimp-form-id'],
        'sanitize_callback' => 'absint'
    ));
    $wp_customize->add_control('arther_options[arther-footer-mailchimp-form-id]', array(
        'label' => __('Mailchimp Form ID', 'arther'),
        'description' => __('From your dashboard go to the mailchimp form plugin and get the ID and put here.', 'arther'),
        'section' => 'arther_footer_section',
        'settings' => 'arther_options[arther-footer-mailchimp-form-id]',
        'type' => 'number',
        'priority' => 15,
        'active_callback'=> 'arther_footer_mailchimp_enable',
    ));

    /*Title for mailchimp*/
    $wp_customize->add_setting('arther_options[arther-footer-mailchimp-form-title]', array(
        'capability' => 'edit_theme_options',
        'transport' => 'refresh',
        'default' => $default['arther-footer-mailchimp-form-title'],
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('arther_options[arther-footer-mailchimp-form-title]', array(
        'label' => __('Mailchimp Section Title', 'arther'),
        'description' => __('Enter the title of subscribe.', 'arther'),
        'section' => 'arther_footer_section',
        'settings' => 'arther_options[arther-footer-mailchimp-form-title]',
        'type' => 'text',
        'priority' => 15,
        'active_callback'=> 'arther_footer_mailchimp_enable',
    ));


    /*subTitle for mailchimp*/
    $wp_customize->add_setting('arther_options[arther-footer-mailchimp-form-subtitle]', array(
        'capability' => 'edit_theme_options',
        'transport' => 'refresh',
        'default' => $default['arther-footer-mailchimp-form-subtitle'],
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('arther_options[arther-footer-mailchimp-form-subtitle]', array(
        'label' => __('Mailchimp Section Sub Title', 'arther'),
        'description' => __('Enter the sub title of subscribe.', 'arther'),
        'section' => 'arther_footer_section',
        'settings' => 'arther_options[arther-footer-mailchimp-form-subtitle]',
        'type' => 'text',
        'priority' => 15,
        'active_callback'=> 'arther_footer_mailchimp_enable',
    ));
}