<?php
/**
 * Arther Theme Customizer default values
 *
 * @package Arther
 */
if ( !function_exists('arther_default_theme_options_values') ) :
    function arther_default_theme_options_values() {
        $default_theme_options = array(
            /*Top Header*/
            'arther-enable-top-header'=> true,
            'arther-enable-top-header-social'=> true,
            'arther-enable-top-header-menu'=> true,
            'arther-enable-top-header-search'=> true,

            /*Primary Menu Section Option*/
            'arther-enable-sticky-primary-menu' => false,

            /*Slider Settings Option*/
            'arther-enable-slider'=> true,
            'arther-select-category'=> 0,
            'arther-image-size-slider'=> 'cropped-image',

            /*Category Boxes*/
            'arther-enable-category-boxes'=> true,
            'arther-single-cat-posts-select-1'=> 0,


            /*Sidebar Options*/
            'arther-sidebar-blog-page'=>'right-sidebar',
            'arther-sidebar-single-page' =>'right-sidebar',
            'arther-enable-sticky-sidebar'=> true,


            /*Blog Page Default Value*/
            'arther-column-blog-page'=> 'one-column',
            'arther-content-show-from'=>'excerpt',
            'arther-excerpt-length'=>20,
            'arther-pagination-options'=>'numeric',
            'arther-read-more-text'=> esc_html__('Read More','arther'),
            'arther-blog-page-masonry-normal'=> 'masonry',
            'arther-blog-page-image-position'=> 'left-image',
            'arther-image-size-blog-page'=> 'original-image',

            /*Blog Layout Overlay*/
            'arther-site-layout-blog-overlay'=> 1,

            /*Single Page Default Value*/
            'arther-single-page-featured-image'=> true,
            'arther-single-page-tags'=> false,
            'arther-enable-underline-link' => true,
            'arther-single-page-related-posts'=> true,
            'arther-single-page-related-posts-title'=> esc_html__('Related Posts','arther'),

            /*Breadcrumb Settings*/
            'arther-blog-site-breadcrumb'=> true,
            'arther-breadcrumb-display-from-option'=> 'theme-default',
            'arther-breadcrumb-text'=> '',

            /*General Colors*/
            'arther-primary-color' => '#a136ab',
            'arther-header-description-color'=>'#404040',

            'arther-overlay-color' => 'rgba(0, 0, 0, 0.01)',
            'arther-overlay-second-color'=>'rgba(0, 0, 0, 0.75)',

            /*Footer Options*/
            'arther-footer-copyright'=> esc_html__('All Rights Reserved 2025.','arther'),
            'arther-go-to-top'=> true,
            'arther-go-to-top-icon'=> esc_html__('fa-angle-double-up','arther'),
            'arther-go-to-top-icon-new'=> esc_html__('fa-angles-up','arther'),
            'arther-footer-social-icons'=> false,
            'arther-footer-mailchimp-subscribe'=> false,
            'arther-footer-mailchimp-form-id'=> '',
            'arther-footer-mailchimp-form-title'=>  esc_html__('Subscribe to my Newsletter','arther'),
            'arther-footer-mailchimp-form-subtitle'=> esc_html__('Be the first to receive the latest buzz on upcoming contests & more!','arther'),

            /*Font Options*/
            'arther-font-family-url'=> 'Mulish:wght@300;400;500;600;700',
            'arther-font-heading-family-url'=> 'Oxygen:400,300,700',

            /*Extra Options*/
            'arther-post-published-updated-date'=> 'post-published',
            'arther-font-awesome-version-loading'=> 'version-4', 

        );
        return apply_filters( 'arther_default_theme_options_values', $default_theme_options );
    }
endif;

/**
 *  Arther Theme Options and Settings
 *
 * @since Arther 1.0.0
 *
 * @param null
 * @return array arther_get_options_value
 *
 */
if ( !function_exists('arther_get_options_value') ) :
    function arther_get_options_value() {
        $arther_default_theme_options_values = arther_default_theme_options_values();
        $arther_get_options_value = get_theme_mod( 'arther_options');
        if( is_array( $arther_get_options_value )){
            return array_merge( $arther_default_theme_options_values, $arther_get_options_value );
        }
        else{
            return $arther_default_theme_options_values;
        }
    }
endif;