<?php
/**
 *  Arther Color Option
 *
 * @since Arther 1.0.0
 *
 */

/* Site Title hover color */
$wp_customize->add_setting( 'arther_options[arther-primary-color]',
    array(
        'sanitize_callback' => 'sanitize_hex_color',
        'capability'        => 'edit_theme_options',
        'transport' => 'refresh',
        'default'           => $default['arther-primary-color'],
    )
);
$wp_customize->add_control(
    new WP_Customize_Color_Control(
        $wp_customize,
        'arther_options[arther-primary-color]',
        array(
            'label'       => esc_html__( 'Site Primary Color', 'arther' ),
            'description' => esc_html__( 'It will change the color of site whole site.', 'arther' ),
            'section'     => 'colors',
             'settings'  => 'arther_options[arther-primary-color]',
        )
    )
);

/* Site Title hover color */
$wp_customize->add_setting( 'arther_options[arther-header-description-color]',
    array(
        'sanitize_callback' => 'sanitize_hex_color',
        'capability'        => 'edit_theme_options',
        'transport' => 'refresh',
        'default'           => $default['arther-header-description-color'],
    )
);
$wp_customize->add_control(
    new WP_Customize_Color_Control(
        $wp_customize,
        'arther_options[arther-header-description-color]',
        array(
            'label'       => esc_html__( 'Header Description Color', 'arther' ),
            'description' => esc_html__( 'It will change the color of site header description.', 'arther' ),
            'section'     => 'colors',
             'settings'  => 'arther_options[arther-header-description-color]',
        )
    )
);

/*callback functions slider*/
if ( !function_exists('arther_slider_active_callback') ) :
    function arther_slider_active_callback(){
      global $arther_theme_options;
      $arther_theme_options = arther_get_options_value();
      $enable_slider = absint($arther_theme_options['arther-enable-slider']);
      if( true == $enable_slider ){
        return true;
      }
      else{
        return false;
      }
    }
  endif;

//Color option for slider hex color
$wp_customize->add_setting( 'arther_options[arther-overlay-color]' , array(
    'default'           => $default['arther-overlay-color'], // Use any HEX or RGBA value.
    'transport'         => 'refresh',
    'sanitize_callback' => 'arther_alpha_color_sanitization_callback'
) );
include_once get_theme_file_path( 'candidthemes/alpha-color/src/ColorAlpha.php' );

$wp_customize->add_control( new ColorAlpha( $wp_customize, 'arther_options[arther-overlay-color]', [
    'label'      => __( 'Overlay First Color', 'arther' ),
    'description' => esc_html__( 'It will change the overlay color of slider and category box sections.', 'arther' ),
    'section'    => 'colors',
    'settings'   => 'arther_options[arther-overlay-color]',
    'active_callback'=>'arther_slider_active_callback',
] ) );


$wp_customize->add_setting( 'arther_options[arther-overlay-second-color]' , array(
    'default'           => $default['arther-overlay-second-color'], // Use any HEX or RGBA value.
    'transport'         => 'refresh',
    'sanitize_callback' => 'arther_alpha_color_sanitization_callback'
) );

$wp_customize->add_control( new ColorAlpha( $wp_customize, 'arther_options[arther-overlay-second-color]', [
    'label'      => __( 'Overlay Second Color', 'arther' ),
    'description' => esc_html__( 'It will change the overlay color of slider and category box sections.', 'arther' ),
    'section'    => 'colors',
    'settings'   => 'arther_options[arther-overlay-second-color]',
    'active_callback'=>'arther_slider_active_callback',
] ) );