<?php
/**
 *  Arther Boxed Option
 *
 * @since Arther 1.0.0
 *
 */
/* Header Types Options*/
$wp_customize->add_section( 'arther_category_boxes_section', array(
    'priority'       => 25,
    'capability'     => 'edit_theme_options',
    'theme_supports' => '',
    'title'          => __( 'Category Boxes Options', 'arther' ),
    'panel' 		 => 'arther_panel',
) );
/*Enable Boxes*/
$wp_customize->add_setting( 'arther_options[arther-enable-category-boxes]', array(
 'capability'        => 'edit_theme_options',
 'transport' => 'refresh',
 'default'           => $default['arther-enable-category-boxes'],
 'sanitize_callback' => 'arther_sanitize_checkbox'
) );
$wp_customize->add_control( 'arther_options[arther-enable-category-boxes]', array(
 'label'     => __( 'Enable Category Boxes Section', 'arther' ),
 'description' => __('Checked to show category boxes section in Home Page.', 'arther'),
 'section'   => 'arther_category_boxes_section',
 'settings'  => 'arther_options[arther-enable-category-boxes]',
 'type'      => 'checkbox',
 'priority'  => 10,
) );

/*callback functions header section*/
if ( !function_exists('arther_category_enable_boxes_callback') ) :
  function arther_category_enable_boxes_callback(){
      global $arther_theme_options;
      $arther_theme_options = arther_get_options_value();
      $enable_box = absint($arther_theme_options['arther-enable-category-boxes']);
      if( true == $enable_box ){
          return true;
      }
      else{
          return false;
      }
  }
endif;

/*Boxes Category*/
$wp_customize->add_setting( 'arther_options[arther-single-cat-posts-select-1]', array(
  'capability'        => 'edit_theme_options',
  'transport' => 'refresh',
  'default'           => $default['arther-single-cat-posts-select-1'],
  'sanitize_callback' => 'absint'
) );
$wp_customize->add_control(
  new Arther_Customize_Category_Dropdown_Control(
    $wp_customize,
    'arther_options[arther-single-cat-posts-select-1]',
    array(
      'label'     => __( 'Select Category', 'arther' ),
      'description' => __('Three Posts from the same category will appear.', 'arther'),
      'section'   => 'arther_category_boxes_section',
      'settings'  => 'arther_options[arther-single-cat-posts-select-1]',
      'type'      => 'category_dropdown',
      'priority'  => 10,
      'active_callback'=>'arther_category_enable_boxes_callback'
    )
  )
);