<?php 
/**
 *  Arther Breadcrumb Settings Option
 *
 * @since Arther 1.0.0
 *
 */
/*Breadcrumb Options*/
$wp_customize->add_section( 'arther_breadcrumb_options', array(
    'priority'       => 50,
    'capability'     => 'edit_theme_options',
    'theme_supports' => '',
    'title'          => __( 'Breadcrumb Options', 'arther' ),
    'panel'          => 'arther_panel',
) );

/*Breadcrumb Enable*/
$wp_customize->add_setting( 'arther_options[arther-blog-site-breadcrumb]', array(
    'capability'        => 'edit_theme_options',
    'transport' => 'refresh',
    'default'           => $default['arther-blog-site-breadcrumb'],
    'sanitize_callback' => 'arther_sanitize_checkbox'
) );
$wp_customize->add_control( 'arther_options[arther-blog-site-breadcrumb]', array(
    'label'     => __( 'Enable Breadcrumb', 'arther' ),
    'description' => __( 'Breadcrumb will appear on all pages except home page. You can use  Yoast SEO, Rank Math or Breadcrumb NavXT plugin breadcrumb as well. Install the plugin and activate the breadcrumb from the settings.', 'arther' ),
    'section'   => 'arther_breadcrumb_options',
    'settings'  => 'arther_options[arther-blog-site-breadcrumb]',
    'type'      => 'checkbox',
    'priority'  => 15,
) );

/*callback functions breadcrumb enable*/
if ( !function_exists('arther_breadcrumb_selection_enable') ) :
  function arther_breadcrumb_selection_enable(){
      global $arther_theme_options;
      $arther_theme_options = arther_get_options_value();
      $enable_bc = absint($arther_theme_options['arther-blog-site-breadcrumb']);
      if( $enable_bc == true){
          return true;
      }
      else{
          return false;
      }
  }
endif;

/*Show Breadcrumb Types Selection*/
$wp_customize->add_setting( 'arther_options[arther-breadcrumb-display-from-option]', array(
    'capability'        => 'edit_theme_options',
    'transport' => 'refresh',
    'default'           => $default['arther-breadcrumb-display-from-option'],
    'sanitize_callback' => 'arther_sanitize_select'
) );
$wp_customize->add_control( 'arther_options[arther-breadcrumb-display-from-option]', array(
    'choices' => array(
        'theme-default'    => __('Theme Default Breadcrumb','arther'),
        'yoast-breadcrumb'    => __('Yoast SEO Breadcrumb','arther'),
        'rankmath-breadcrumb'    => __('Rank Math Breadcrumb','arther'),
        'breadcrumb-navxt'    => __('NavXT Breadcrumb','arther'),
    ),
    'label'     => __( 'Select the Breadcrumb Show Option', 'arther' ),
    'description' => __('Theme has its own breadcrumb. If you want to use the plugin breadcrumb, you need to enable the breadcrumb on the respected plugins first. Check plugin settings and enable it.', 'arther'),
    'section'   => 'arther_breadcrumb_options',
    'settings'  => 'arther_options[arther-breadcrumb-display-from-option]',
    'type'      => 'select',
    'priority'  => 15,
    'active_callback'=> 'arther_breadcrumb_selection_enable',
) );

/*Breadcrumb Text*/
$wp_customize->add_setting( 'arther_options[arther-breadcrumb-text]', array(
    'capability'        => 'edit_theme_options',
    'transport' => 'refresh',
    'default'           => $default['arther-breadcrumb-text'],
    'sanitize_callback' => 'sanitize_text_field'
) );
$wp_customize->add_control( 'arther_options[arther-breadcrumb-text]', array(
    'label'     => __( 'Breadcrumb Text', 'arther' ),
    'description' => __( 'Write your own text in place of You are Here', 'arther' ),
    'section'   => 'arther_breadcrumb_options',
    'settings'  => 'arther_options[arther-breadcrumb-text]',
    'type'      => 'text',
    'priority'  => 15,
    'active_callback' => 'arther_breadcrumb_selection_enable',
) );
