<?php

/**
 *  Arther Blog Page Option
 *
 * @since Arther 1.0.0
 *
 */
/*Blog Page Options*/
$wp_customize->add_section('arther_blog_page_section', array(
    'priority'       => 35,
    'capability'     => 'edit_theme_options',
    'theme_supports' => '',
    'title'          => __('Blog Section Options', 'arther'),
    'panel'          => 'arther_panel',
));

/*Blog Page Layout Masonry*/
$wp_customize->add_setting('arther_options[arther-blog-page-masonry-normal]', array(
    'capability'        => 'edit_theme_options',
    'transport' => 'refresh',
    'default'           => $default['arther-blog-page-masonry-normal'],
    'sanitize_callback' => 'arther_sanitize_select'
));
$wp_customize->add_control('arther_options[arther-blog-page-masonry-normal]', array(
    'choices' => array(
        'normal'    => __('Normal Layout', 'arther'),
        'masonry'   => __('Masonry Layout', 'arther'),
        'full-image'   => __('Full Image Layout', 'arther'),
    ),
    'label'     => __('Masonry or Normal Layout', 'arther'),
    'description' => __('Some image layout option will not work in masonry.', 'arther'),
    'section'   => 'arther_blog_page_section',
    'settings'  => 'arther_options[arther-blog-page-masonry-normal]',
    'type'      => 'select',
    'priority'  => 10,
));

/*Blog Page Show content from*/
$wp_customize->add_setting('arther_options[arther-content-show-from]', array(
    'capability'        => 'edit_theme_options',
    'transport' => 'refresh',
    'default'           => $default['arther-content-show-from'],
    'sanitize_callback' => 'arther_sanitize_select'
));
$wp_customize->add_control('arther_options[arther-content-show-from]', array(
    'choices' => array(
        'excerpt'    => __('Excerpt', 'arther'),
        'content'    => __('Content', 'arther'),
        'hide'    => __('Hide Content', 'arther'),
    ),
    'label'     => __('Select Content Display Option', 'arther'),
    'description' => __('You can enable excerpt from Screen Options inside post section of dashboard', 'arther'),
    'section'   => 'arther_blog_page_section',
    'settings'  => 'arther_options[arther-content-show-from]',
    'type'      => 'select',
    'priority'  => 10,
));

/*Blog image size*/
$wp_customize->add_setting('arther_options[arther-image-size-blog-page]', array(
    'capability'        => 'edit_theme_options',
    'transport' => 'refresh',
    'default'           => $default['arther-image-size-blog-page'],
    'sanitize_callback' => 'arther_sanitize_select'
));
$wp_customize->add_control('arther_options[arther-image-size-blog-page]', array(
    'choices' => array(
        'cropped-image'    => __('Cropped Image', 'arther'),
        'original-image'   => __('Original Image', 'arther'),
    ),
    'label'     => __('Size of the image, either cropped or original', 'arther'),
    'description' => __('The image will be either cropped or original size based on the image. Recommended image size is 800*600 px.', 'arther'),
    'section'   => 'arther_blog_page_section',
    'settings'  => 'arther_options[arther-image-size-blog-page]',
    'type'      => 'select',
    'priority'  => 10,
));

/*Blog Page excerpt length*/
$wp_customize->add_setting('arther_options[arther-excerpt-length]', array(
    'capability'        => 'edit_theme_options',
    'transport' => 'refresh',
    'default'           => $default['arther-excerpt-length'],
    'sanitize_callback' => 'absint'
));
$wp_customize->add_control('arther_options[arther-excerpt-length]', array(
    'label'     => __('Size of Excerpt Content', 'arther'),
    'description' => __('Enter the number per Words to show the content in blog page.', 'arther'),
    'section'   => 'arther_blog_page_section',
    'settings'  => 'arther_options[arther-excerpt-length]',
    'type'      => 'number',
    'priority'  => 10,
));
/*Blog Page Pagination Options*/
$wp_customize->add_setting('arther_options[arther-pagination-options]', array(
    'capability'        => 'edit_theme_options',
    'transport' => 'refresh',
    'default'           => $default['arther-pagination-options'],
    'sanitize_callback' => 'arther_sanitize_select'
));
$wp_customize->add_control('arther_options[arther-pagination-options]', array(
    'choices' => array(
        'default'    => __('Default', 'arther'),
        'numeric'    => __('Numeric', 'arther'),
        'ajax'    => __('Loading in Same Page', 'arther'),
    ),
    'label'     => __('Pagination Types', 'arther'),
    'description' => __('Select the Required Pagination Type', 'arther'),
    'section'   => 'arther_blog_page_section',
    'settings'  => 'arther_options[arther-pagination-options]',
    'type'      => 'select',
    'priority'  => 10,
));
/*Blog Page read more text*/
$wp_customize->add_setting('arther_options[arther-read-more-text]', array(
    'capability'        => 'edit_theme_options',
    'transport' => 'refresh',
    'default'           => $default['arther-read-more-text'],
    'sanitize_callback' => 'sanitize_text_field'
));
$wp_customize->add_control('arther_options[arther-read-more-text]', array(
    'label'     => __('Enter Read More Text', 'arther'),
    'description' => __('Read more text for blog and archive page.', 'arther'),
    'section'   => 'arther_blog_page_section',
    'settings'  => 'arther_options[arther-read-more-text]',
    'type'      => 'text',
    'priority'  => 10,
));
