<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package arther
 */
global $arther_theme_options;

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <!-- for full single column card layout add [.card-full-width] class -->
    <div class="card card-blog-post card-full-width card-single-article">
        <div class="card_body">
            <div class="card_body_header">
                <?php
                    arther_list_category();
                ?>

                <?php
                    the_title('<h1 class="card_title">', '</h1>');
                ?>
                
                <?php
                if ('post' === get_post_type()) :
                    ?>
                    <div class="entry-meta">
                        <?php
                            arther_posted_by();
                            arther_posted_on();
                        ?>
                    </div><!-- .entry-meta -->
                <?php endif; ?>
            </div>

            <?php
                if(has_post_thumbnail() && ($arther_theme_options['arther-single-page-featured-image'] == 1)) {
                ?>
                <figure class="card_media">
                        <?php arther_post_thumbnail(); ?>
                </figure>
                    <?php
                }
            ?>

            <div class="entry-content">
                <?php
                    the_content(
                        sprintf(
                            wp_kses(
                            /* translators: %s: Name of current post. Only visible to screen readers */
                                __('Continue reading<span class="screen-reader-text"> "%s"</span>', 'arther'),
                                array(
                                    'span' => array(
                                        'class' => array(),
                                    ),
                                )
                            ),
                            wp_kses_post(get_the_title())
                        )
                    );

                    wp_link_pages(
                        array(
                            'before' => '<div class="page-links">' . esc_html__('Pages:', 'arther'),
                            'after' => '</div>',
                        )
                    );

                ?>
            </div>
            <?php
            $arther_show_tags = $arther_theme_options['arther-single-page-tags'];
            if($arther_show_tags == 1){
                arther_meta_tags();
            }
            ?>


        </div>
    </div>
    <?php
    /**
     * arther_related_posts hook
     * @since 1.0.0
     *
     * @hooked arther_related_posts -  10
     */
    do_action('arther_related_posts', get_the_ID());
    ?>
    <!-- Related Post Code Here -->

</article><!-- #post-<?php the_ID(); ?> -->
