<?php
if (!function_exists('arther_construct_gototop')) {
    /**
     * Add Go to Top Button on Site.
     *
     * @since 1.0.0
     *
     * @param none
     * @return void
     *
     */
    function arther_construct_gototop()
    {
        global $arther_theme_options;
        $font_awesome_version = $arther_theme_options['arther-font-awesome-version-loading'];
        if ($font_awesome_version == 'version-6') {
            $go_to_top_class = esc_attr($arther_theme_options['arther-go-to-top-icon-new']);
        } else {
            $go_to_top_class = esc_attr($arther_theme_options['arther-go-to-top-icon']);
        }
        if ($arther_theme_options['arther-go-to-top'] == true && !empty($go_to_top_class)) :
?>
            <a href="javascript:void(0);" class="footer-go-to-top go-to-top"><i class="fa <?php echo esc_attr($go_to_top_class); ?>"></i></a>
        <?php
        endif;
    }
}
add_action('arther_gototop', 'arther_construct_gototop', 10);

if (!function_exists('arther_construct_footer_social')) {
    /**
     * Add social icon menu on footer
     *
     * @since 1.0.0
     */
    function arther_construct_footer_social()
    {
        global $arther_theme_options;
        if ($arther_theme_options['arther-footer-social-icons'] != true)
            return false;
        arther_social_menu();
    }
}
add_action('arther_footer_social', 'arther_construct_footer_social', 10);

if (!function_exists('arther_footer_copyright')) {
    /**
     * Add Footer copyright texts on footer
     *
     * @since 1.0.0
     */
    function arther_footer_copyright()
    {
        global $arther_theme_options;
        $copyright_text = $arther_theme_options['arther-footer-copyright'];
        if (!empty($copyright_text)) {
        ?>
            <div class="site-reserved text-center">
                <?php echo esc_html($copyright_text); ?>
            </div>
        <?php
        }
    }
}
add_action('arther_footer_info_texts', 'arther_footer_copyright', 10);

if (!function_exists('arther_footer_theme_info')) {
    /**
     * Add Powered by texts on footer
     *
     * @since 1.0.0
     */
    function arther_footer_theme_info()
    {
        ?>
        <div class="site-info text-center">
            <a href="<?php echo esc_url(__('https://wordpress.org/', 'arther')); ?>">
                <?php
                /* translators: %s: CMS name, i.e. WordPress. */
                printf(esc_html__('Proudly powered by %s', 'arther'), 'WordPress');
                ?>
            </a>
            <span class="sep"> | </span>
            <?php
            /* translators: 1: Theme name, 2: Theme author. */
            printf(esc_html__('Theme: %1$s by %2$s.', 'arther'), 'Arther', '<a href="http://www.candidthemes.com/">Candid Themes</a>');
            ?>
        </div><!-- .site-info -->
    <?php
    }
}
add_action('arther_footer_info_texts', 'arther_footer_theme_info', 20);

if (!function_exists('arther_construct_newsletter')) {
    /**
     * Add Newsletter section on footer
     *
     * @since 1.0.0
     */
    function arther_construct_newsletter()
    {
        global $arther_theme_options;
        $mailchimp_id = $arther_theme_options['arther-footer-mailchimp-form-id'];
        if (($arther_theme_options['arther-footer-mailchimp-subscribe']) != 1 || (empty($mailchimp_id)) || (!function_exists('mc4wp_get_form')) || (get_post_status($mailchimp_id) == false))
            return false;
        $newsletter_title =  $arther_theme_options['arther-footer-mailchimp-form-title'];
        $newsletter_description =  $arther_theme_options['arther-footer-mailchimp-form-subtitle'];
    ?>
        <section class="newsletter-section">
            <div class="container">
                <article class="newsletter-content">
                    <div class="row">
                        <div class="col-1-1 col-md-1-2">
                            <?php
                            if (!empty($newsletter_title)) {
                            ?>
                                <h2><?php echo esc_html($newsletter_title); ?></h2>
                            <?php
                            }
                            ?>
                            <?php
                            if (!empty($newsletter_description)) {
                            ?>
                                <p><?php echo esc_html($newsletter_description);; ?></p>
                            <?php
                            }
                            ?>
                        </div>
                        <div class="col-1-1 col-md-1-2">
                            <?php echo mc4wp_get_form(absint($mailchimp_id)); ?>
                        </div>
                    </div>
                </article>
            </div>
        </section>
<?php
    }
}
add_action('arther_newsletter', 'arther_construct_newsletter', 10);
