<?php
if (!function_exists('arther_social_menu')) {
    /**
     * Add social icons menu
     *
     * @since 1.0.0
     *
     */
    function arther_social_menu()
    {
        if (has_nav_menu('social-menu')) :
            wp_nav_menu(array(
                'theme_location' => 'social-menu',
                'container' => 'ul',
                'menu_class' => 'social-menu'
            ));
        endif;
    }
}


if (!function_exists('arther_custom_body_class')) {
    /**
     * Add sidebar class in body
     *
     * @since 1.0.0
     *
     */
    function arther_custom_body_class($classes)
    {
        global $arther_theme_options;
        if (!empty($arther_theme_options['arther-enable-sticky-sidebar']) &&  $arther_theme_options['arther-enable-sticky-sidebar'] == 1) {
            $classes[] = 'ct-sticky-sidebar';
        }

        if (!empty($arther_theme_options['arther-font-awesome-version-loading'])) {
            $classes[] = 'arther-fontawesome-' . $arther_theme_options['arther-font-awesome-version-loading'];
        }

        return $classes;
    }
}

add_filter('body_class', 'arther_custom_body_class');



if (!function_exists('arther_excerpt_more')) :
    /**
     * Remove ... From Excerpt
     *
     * @since 1.0.0
     */
    function arther_excerpt_more($more)
    {
        if (!is_admin()) {
            return '';
        }
    }
endif;
add_filter('excerpt_more', 'arther_excerpt_more');


if (!function_exists('arther_alter_excerpt')) :
    /**
     * Filter to change excerpt length size
     *
     * @since 1.0.0
     */
    function arther_alter_excerpt($length)
    {
        if (is_admin()) {
            return $length;
        }
        global $arther_theme_options;
        if (!empty($arther_theme_options['arther-excerpt-length'])) {
            return absint($arther_theme_options['arther-excerpt-length']);
        }
        return 25;
    }
endif;
add_filter('excerpt_length', 'arther_alter_excerpt');


if (!function_exists('arther_tag_cloud_widget')) :
    /**
     * Function to modify tag clouds font size
     *
     * @param none
     * @return array $args
     *
     * @since 1.0.0
     *
     */
    function arther_tag_cloud_widget($args)
    {
        $args['largest'] = 0.9; //largest tag
        $args['smallest'] = 0.9; //smallest tag
        $args['unit'] = 'rem'; //tag font unit
        return $args;
    }
endif;
add_filter('widget_tag_cloud_args', 'arther_tag_cloud_widget');


/**
 * Google Fonts
 *
 * @param null
 * @return array
 *
 * @since Arther 1.0.0
 *
 */
if (!function_exists('arther_google_fonts')) :
    function arther_google_fonts()
    {
        $arther_google_fonts = array(
            'Libre+Baskerville' => 'Libre Baskerville',
            'Merriweather:400,400italic,300,900,700' => 'Merriweather',
            'Montserrat:400,700' => 'Montserrat',
            'Muli:400,300italic,300' => 'Muli',
            'Mulish:wght@300;400;500;600;700' => 'Mulish',
            'Open+Sans:400,400italic,600,700' => 'Open Sans',
            'Open+Sans+Condensed:300,300italic,700' => 'Open Sans Condensed',
            'Oswald:400,300,700' => 'Oswald',
            'Oxygen:400,300,700' => 'Oxygen',
            'Poppins:400,500,600,700' => 'Poppins',
            'Roboto:400,500,300,700,400italic' => 'Roboto',
            'Voltaire' => 'Voltaire',
            'Space+Grotesk:300,700'=> 'Space Grotesk',
            'Yanone+Kaffeesatz:400,300,700' => 'Yanone Kaffeesatz'
        );
        return apply_filters('arther_google_fonts', $arther_google_fonts);
    }
endif;


/**
 * Enqueue the list of fonts.
 */
function arther_customizer_fonts()
{
    wp_enqueue_style('arther_customizer_fonts', 'https://fonts.googleapis.com/css?family=Libre+Baskerville|Merriweather|Montserrat|Muli|Mulish|Open+Sans|Open+Sans+Condensed|Oswald|Oxygen|Poppins|Roboto|Voltaire|Space+Grotesk|Yanone+Kaffeesatz', array(), null);
}

add_action('customize_controls_print_styles', 'arther_customizer_fonts');
add_action('customize_preview_init', 'arther_customizer_fonts');

add_action(
    'customize_controls_print_styles',
    function () {
?>
    <style>
        <?php
        $arr = array('Libre+Baskerville', 'Merriweather', 'Montserrat', 'Muli','Mulish', 'Open+Sans', 'Open+Sans+Condensed', 'Oswald', 'Oxygen', 'Poppins', 'Roboto', 'Voltaire', 'Space+Grotesk','Yanone+Kaffeesatz');

        foreach ($arr as $font) {
            $font_family = str_replace("+", " ", $font);
            echo '.customize-control select option[value*="' . $font . '"] {font-family: ' . $font_family . '; font-size: 22px;}';
        }
        ?>
    </style>
<?php
    }
);


if (!function_exists('arther_editor_assets')) {
    /**
     * Add styles and fonts for the editor.
     */
    function arther_editor_assets()
    {
        wp_enqueue_style('arther-fonts', arther_fonts_url(), array(), null);

        /* Paragraph Font Options */
        $arther_custom_css = '';
        global $arther_theme_options;
        $arther_theme_options = arther_get_options_value();
        $arther_google_fonts = arther_google_fonts();

        $arther_body_fonts = esc_attr($arther_theme_options['arther-font-family-url']);
        $arther_heading_fonts = esc_attr($arther_theme_options['arther-font-heading-family-url']);

        $arther_google_fonts_enqueue = array(
            $arther_body_fonts,
            $arther_heading_fonts,
        );
        $arther_google_fonts_enqueue_uniques = array_unique($arther_google_fonts_enqueue);
        foreach ($arther_google_fonts_enqueue_uniques as $arther_google_fonts_enqueue_unique) {
            wp_enqueue_style(
                $arther_google_fonts_enqueue_unique,
                '//fonts.googleapis.com/css?family=' . $arther_google_fonts_enqueue_unique . '',
                array(),
                ''
            );
        }
        if (!empty($arther_body_fonts)) {
            $arther_font_family = esc_attr($arther_google_fonts[$arther_body_fonts]);
            if (!empty($arther_font_family)) {
                $arther_custom_css .= ".editor-styles-wrapper .wp-block-table td, .editor-styles-wrapper .wp-block-table th, .editor-styles-wrapper, .editor-styles-wrapper .wp-block-button__link, .editor-styles-wrapper ul li, .editor-styles-wrapper ol li, .editor-styles-wrapper p, .editor-styles-wrapper .editor-block-list__block-edit, .editor-block-list__block  { font-family: '{$arther_font_family}'; }";
            }
        }

        /* Heading H1 Font Option */
        if (!empty($arther_heading_fonts)) {
            $arther_heading_font_family = $arther_google_fonts[$arther_heading_fonts];
            if (!empty($arther_heading_font_family)) {
                $arther_custom_css .= ".editor-post-title__block .editor-post-title__input , .editor-styles-wrapper h1, .editor-styles-wrapper h2, .editor-styles-wrapper h3, .editor-styles-wrapper h4, .editor-styles-wrapper h5, .editor-styles-wrapper h6 { font-family: '{$arther_heading_font_family}'; }";
            }
        }

        wp_add_inline_style($arther_google_fonts_enqueue_unique, $arther_custom_css);
    }

    add_action('enqueue_block_editor_assets', 'arther_editor_assets');
}
