<?php
/**
 *  Arther Typography Option
 *
 * @since Arther 1.1.9
 *
 */
$wp_customize->add_panel( 'arther_typography', array(
    'priority' => 30,
    'capability' => 'edit_theme_options',
    'title' => __( 'Fonts Options', 'arther' ),
) );

/*
* Font and Typography Options
* Paragraph Option Section
* Arther 1.1.9
*/
$wp_customize->add_section( 'arther_font_options', array(
   'priority'       => 20,
   'capability'     => 'edit_theme_options',
   'theme_supports' => '',
   'title'          => __( 'Paragraph Font', 'arther' ),
   'panel' 		 => 'arther_typography',
) );
/*Paragraph Font Family*/
$wp_customize->add_setting( 'arther_options[arther-font-family-url]', array(
    'capability'        => 'edit_theme_options',
    'transport' => 'refresh',
    'default'           => $default['arther-font-family-url'],
    'sanitize_callback' => 'wp_kses_post'
) );
$choices = arther_google_fonts();
$wp_customize->add_control( 'arther_options[arther-font-family-url]', array(
    'label'     => __( 'Body Paragraph Font Family', 'arther' ),
    'description' =>__( 'Select the required font from the dropdown.', 'arther' ),
    'choices'  	=> $choices,
    'section'   => 'arther_font_options',
    'settings'  => 'arther_options[arther-font-family-url]',
    'type'      => 'select',
    'priority'  => 15,
) );

/*
* Heading Fonts Options
* Heading Font Option Section
* Arther 1.1.9
*/

/*Heading Fonts*/
$wp_customize->add_section( 'arther_heading_font_options', array(
    'priority'       => 30,
    'capability'     => 'edit_theme_options',
    'theme_supports' => '',
    'title'          => __( 'Heading Font Family', 'arther' ),
    'panel'         => 'arther_typography',
) );
/*Font Family URL*/
$wp_customize->add_setting( 'arther_options[arther-font-heading-family-url]', array(
    'capability'        => 'edit_theme_options',
    'transport' => 'refresh',
    'default'           => $default['arther-font-heading-family-url'],
    'sanitize_callback' => 'wp_kses_post'
) );
$choices = arther_google_fonts();
$wp_customize->add_control( 'arther_options[arther-font-heading-family-url]', array(
    'label'     => __( 'Select Heading Font Family', 'arther' ),
    'description' => __( 'Select the required font from the dropdown(H1-H6).', 'arther' ),
    'choices'  	=> $choices,
    'section'   => 'arther_heading_font_options',
    'settings'  => 'arther_options[arther-font-heading-family-url]',
    'type'      => 'select',
    'priority'  => 10,
) );