<?php
/**
 *  Arther Slider Featured Section Option
 *
 * @since Arther 1.0.0
 *
 */
/*Slider Options*/
$wp_customize->add_section( 'arther_slider_section', array(
 'priority'       => 20,
 'capability'     => 'edit_theme_options',
 'theme_supports' => '',
 'title'          => __( 'Slider Section Options', 'arther' ),
 'panel' 		 => 'arther_panel',
) );
/*callback functions slider*/
if ( !function_exists('arther_slider_active_callback') ) :
  function arther_slider_active_callback(){
    global $arther_theme_options;
    $arther_theme_options = arther_get_options_value();
    $enable_slider = absint($arther_theme_options['arther-enable-slider']);
    if( true == $enable_slider ){
      return true;
    }
    else{
      return false;
    }
  }
endif;
/*Slider Enable Option*/
$wp_customize->add_setting( 'arther_options[arther-enable-slider]', array(
 'capability'        => 'edit_theme_options',
 'transport' => 'refresh',
 'default'           => $default['arther-enable-slider'],
 'sanitize_callback' => 'arther_sanitize_checkbox'
) );
$wp_customize->add_control( 'arther_options[arther-enable-slider]', array(
 'label'     => __( 'Enable Slider Section', 'arther' ),
 'description' => __('Checked to show slider section in Home Page.', 'arther'),
 'section'   => 'arther_slider_section',
 'settings'  => 'arther_options[arther-enable-slider]',
 'type'      => 'checkbox',
 'priority'  => 10,
) );

/*Slider Category Selection*/
$wp_customize->add_setting( 'arther_options[arther-select-category]', array(
  'capability'        => 'edit_theme_options',
  'transport' => 'refresh',
  'default'           => $default['arther-select-category'],
  'sanitize_callback' => 'absint'
) );
$wp_customize->add_control(
  new Arther_Customize_Category_Dropdown_Control(
    $wp_customize,
    'arther_options[arther-select-category]',
    array(
      'label'     => __( 'Select Category For Slider Section', 'arther' ),
      'description' => __('From the dropdown select the category for the featured left section. Category having post will display in below dropdown.', 'arther'),
      'section'   => 'arther_slider_section',
      'settings'  => 'arther_options[arther-select-category]',
      'type'      => 'category_dropdown',
      'priority'  => 10,
      'active_callback'=>'arther_slider_active_callback'
    )
  )
);

/*Slider image size*/
$wp_customize->add_setting( 'arther_options[arther-image-size-slider]', array(
    'capability'        => 'edit_theme_options',
    'transport' => 'refresh',
    'default'           => $default['arther-image-size-slider'],
    'sanitize_callback' => 'arther_sanitize_select'
) );
$wp_customize->add_control( 'arther_options[arther-image-size-slider]', array(
   'choices' => array(
    'cropped-image'    => __('Cropped Image','arther'),
    'original-image'   => __('Original Image','arther'),
),
   'label'     => __( 'Size of the image, either cropped or original', 'arther' ),
   'description' => __('The image will be either cropped or original size based on the image. Recommended image size is 1170*606 px. Make the image with this size and add in the featured image.', 'arther'),
   'section'   => 'arther_slider_section',
   'settings'  => 'arther_options[arther-image-size-slider]',
   'type'      => 'select',
   'priority'  => 10,
   'active_callback'=>'arther_slider_active_callback'
) );