<?php

/**
 *  Arther Extra Option
 *
 * @since Arther 1.0.0
 *
 */
/*Extra Options*/
$wp_customize->add_section('arther_extra_section', array(
   'priority'       => 60,
   'capability'     => 'edit_theme_options',
   'theme_supports' => '',
   'title'          => __('Extra Options', 'arther'),
   'panel'        => 'arther_panel',
));

/*post published or updated date*/
$wp_customize->add_setting('arther_options[arther-post-published-updated-date]', array(
   'capability'        => 'edit_theme_options',
   'transport' => 'refresh',
   'default'           => $default['arther-post-published-updated-date'],
   'sanitize_callback' => 'arther_sanitize_select'
));
$wp_customize->add_control('arther_options[arther-post-published-updated-date]', array(
   'choices' => array(
      'post-published'    => __('Show Post Published Date', 'arther'),
      'post-updated'   => __('Show Post Updated Date', 'arther'),
   ),
   'label'     => __('Show Post Publish or Updated Date', 'arther'),
   'description' => __('Show either post published or updated date.', 'arther'),
   'section'   => 'arther_extra_section',
   'settings'  => 'arther_options[arther-post-published-updated-date]',
   'type'      => 'select',
   'priority'  => 10,
));

/*Font awesome version loading*/
$wp_customize->add_setting('arther_options[arther-font-awesome-version-loading]', array(
   'capability'        => 'edit_theme_options',
   'transport' => 'refresh',
   'default'           => $default['arther-font-awesome-version-loading'],
   'sanitize_callback' => 'arther_sanitize_select'
));
$wp_customize->add_control('arther_options[arther-font-awesome-version-loading]', array(
   'choices' => array(
      'version-4'    => __('Fontawesome Version Version 4', 'arther'),
      'version-6'   => __('Current Theme Used Version 6', 'arther'),
   ),
   'label'     => __('Select the preferred fontawesome version', 'arther'),
   'description' => __('You can select the latest fontawesome version to get more options for icons', 'arther'),
   'section'   => 'arther_extra_section',
   'settings'  => 'arther_options[arther-font-awesome-version-loading]',
   'type'      => 'select',
   'priority'  => 10,
));

