<?php
/**
 * Added arther Page. */

/**
 * Add a new page under Appearance
 */
function arther_menu()
{
	add_theme_page(__('Arther Options', 'arther'), __('Arther Options', 'arther'), 'edit_theme_options', 'arther-theme', 'arther_page');
}
add_action('admin_menu', 'arther_menu');

/**
 * Enqueue styles for the help page.
 */
function arther_admin_scripts($hook)
{
	if ('appearance_page_arther-theme' !== $hook) {
		return;
	}
	wp_enqueue_style('arther-admin-style', get_template_directory_uri() . '/candidthemes/about/about.css', array(), '');
}
add_action('admin_enqueue_scripts', 'arther_admin_scripts');

/**
 * Add the theme page
 */
function arther_page()
{
?>
<div class="das-wrap">
  <div class="arther-panel header">
    <div class="arther-logo">
      <img class="ts-logo"
        src="<?php echo esc_url(get_template_directory_uri() . '/candidthemes/about/images/arther-logo.png'); ?>"
        alt="Logo">
    </div>
    <p>
      <?php esc_html_e('A perfect theme for blog and magazine site. With masonry layout and multiple blog page layout, this theme is the awesome and minimal theme.', 'arther'); ?>
    </p>
    <a class="btn btn-primary" href="<?php echo esc_url(admin_url('/customize.php?'));
?>"><?php esc_html_e('Theme Options - Click Here', 'arther'); ?></a>
  </div>

  <div class="das-wrap-inner">
    <div class="das-col das-col-7">
      <div class="arther-panel">
        <div class="arther-panel-content">
          <div class="theme-title">
            <h3><?php esc_html_e('Looking for theme Documentation?', 'arther'); ?></h3>
          </div>
          <a href="https://docs.candidthemes.com/arther/" target="_blank"
            class="btn btn-secondary"><?php esc_html_e('Documentation - Click Here', 'arther'); ?></a>
        </div>
      </div>
      <div class="arther-panel">
        <div class="arther-panel-content">
          <div class="theme-title">
            <h3><?php esc_html_e('If you like the theme, please leave a review', 'arther'); ?></h3>
          </div>
          <a href="https://wordpress.org/support/theme/arther/reviews/?filter=5" target="_blank"
            class="btn btn-secondary"><?php esc_html_e('Rate this theme', 'arther'); ?></a>
        </div>
      </div>
      <div class="arther-panel">
        <div class="arther-panel-content">
          <div class="theme-title">
            <h3><?php esc_html_e('View all Demos', 'arther'); ?></h3>
          </div>
          <a href="https://arther.candidthemes.com/" target="_blank"
            class="btn btn-secondary"><?php esc_html_e('Default Demo', 'arther'); ?></a>
          <a href="https://demo.candidthemes.com/arther-pro/" target="_blank"
            class="btn btn-secondary"><?php esc_html_e('Arther Pro', 'arther'); ?></a>
          <a href="https://demo.candidthemes.com/arther-rtl/" target="_blank"
            class="btn btn-secondary"><?php esc_html_e('Arther RTL', 'arther'); ?></a>
        </div>
      </div>
    </div>
    <div class="das-col das-col-3">
      <div class="upgrade-div">
        <p>
          <strong>
            <?php esc_html_e('Pro Features Include:', 'arther'); ?>
          </strong>
          </h4>
        <ul>
          <li>
          <?php esc_html_e('Author Information including social icons and descriptions.', 'arther'); ?>
          </li>
          <li>
          <?php esc_html_e('Write your own powered by text with link in HTML formats.', 'arther'); ?>
          </li>
          <li>
          <?php esc_html_e('Change search placeholder text easily and write your own text.', 'arther'); ?>            
          </li>
          <li>
          <?php esc_html_e('Make your menu sticky on the top for better user experience.', 'arther'); ?>  
          </li>
        </ul>
        <div class="text-center">
          <a href="https://www.candidthemes.com/themes/arther-pro/" target="_blank"
            class="btn btn-success"><?php esc_html_e('Upgrade Pro $49', 'arther'); ?></a>
        </div>
      </div>
      <div class="arther-panel">
        <div class="theme-title">
          <h3><?php esc_html_e('Important Links', 'arther'); ?></h3>
        </div>
        <div>
          <ul>
            <li>
              <a href="https://www.candidthemes.com/themes/arther/"><?php esc_html_e('Theme page', 'arther'); ?></a>
            </li>
            <li>
              <a href="https://www.candidthemes.com/support-tickets/"><?php esc_html_e('Support', 'arther'); ?></a>
            </li>
          </ul>
        </div>
      </div>
      <div class="arther-panel">
        <div class="theme-title">
          <h3><?php esc_html_e('Other Popular Theme', 'arther'); ?></h3>
        </div>
        <a href="https://www.candidthemes.com/themes/refined-magazine-free-magazine-wordpress-theme/" target="_blank"
          class="btn btn-success"><?php esc_html_e('Refined Magazine', 'arther'); ?></a>
      </div>
    </div>
  </div>
</div>
<?php
}