<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Arterior
 */

get_header();
?>

	<main id="primary" class="site-main p-5">
		<div class="container-fluid">
			<div class="row">
				<div class="col-lg-8 col-md-8 col-12">
					<?php
						while ( have_posts() ) :
						the_post();

						get_template_part( 'template-parts/content', get_post_type() );

						the_post_navigation(
							array(
								'prev_text' => '<span class="nav-subtitle">' . esc_html__( 'Previous:', 'arterior' ) . '</span> <span class="nav-title">%title</span>',
								'next_text' => '<span class="nav-subtitle">' . esc_html__( 'Next:', 'arterior' ) . '</span> <span class="nav-title">%title</span>',
							)
						);

						// If comments are open or we have at least one comment, load up the comment template.
						if ( comments_open() || get_comments_number() ) :
							comments_template();
						endif;

						endwhile; // End of the loop.
					?>
				</div>
				<div class="col-lg-4 col-md-4 col-12">
					<?php get_sidebar(); ?>
				</div>
			</div>
			
		</div>

		

	</main><!-- #main -->

<?php

get_footer();
