<?php
/**
 * Arterior functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Arterior
 */

if ( ! defined( 'ARTERIOR_S_VERSION' ) ) {
	// Replace the version number of the theme on each release.
	define( 'ARTERIOR_S_VERSION', '1.0.0' );
}

/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function arterior_setup() {
	/*
		* Make theme available for translation.
		* Translations can be filed in the /languages/ directory.
		* If you're building a theme based on Arterior, use a find and replace
		* to change 'arterior' to the name of your theme in all the template files.
		*/
	load_theme_textdomain( 'arterior', get_template_directory() . '/languages' );

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	/*
		* Let WordPress manage the document title.
		* By adding theme support, we declare that this theme does not use a
		* hard-coded <title> tag in the document head, and expect WordPress to
		* provide it for us.
		*/
	add_theme_support( 'title-tag' );

	/*
		* Enable support for Post Thumbnails on posts and pages.
		*
		* @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		*/
	add_theme_support( 'post-thumbnails' );

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus(
		array(
			'header' => esc_html__( 'Header', 'arterior' ),
		)
	);

	/*
		* Switch default core markup for search form, comment form, and comments
		* to output valid HTML5.
		*/
	add_theme_support(
		'html5',
		array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
			'style',
			'script',
		)
	);

	// Set up the WordPress core custom background feature.
	add_theme_support(
		'custom-background',
		apply_filters(
			'arterior_custom_background_args',
			array(
				'default-color' => 'ffffff',
				'default-image' => '',
			)
		)
	);

	// Add theme support for selective refresh for widgets.
	add_theme_support( 'customize-selective-refresh-widgets' );

	/**
	 * Add support for core custom logo.
	 *
	 * @link https://codex.wordpress.org/Theme_Logo
	 */
	add_theme_support(
		'custom-logo',
		array(
			'height'      => 250,
			'width'       => 250,
			'flex-width'  => true,
			'flex-height' => true,
		)
	);
}
add_action( 'after_setup_theme', 'arterior_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $arterior_cont_content_width
 */
function arterior_content_width() {
	$GLOBALS['arterior_cont_content_width'] = apply_filters( 'arterior_content_width', 640 );
}
add_action( 'after_setup_theme', 'arterior_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function arterior_widgets_init() {
	register_sidebar(
		array(
			'name'          => esc_html__( 'Sidebar', 'arterior' ),
			'id'            => 'sidebar-1',
			'description'   => esc_html__( 'Add widgets here.', 'arterior' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
}
add_action( 'widgets_init', 'arterior_widgets_init' );

function arterior_customizer_setting($wp_customize){	

	$wp_customize->add_panel(
        'arterior_section_panel',
        [
           'priority' => 30,
           'capability' => 'edit_theme_options',
           'title' => esc_html__('Arterior Section', 'arterior'),
        ]
    );

    $wp_customize->add_section( 'arterior_section' , array(

	'title'      => esc_html__( 'Banner Section', 'arterior' ),
	'capability' => 'edit_theme_options',
	'panel' => 'arterior_section_panel'

	) );

	$wp_customize->add_section( 'arterior_section_designwork' , array(

	'title'      => esc_html__( 'About Section', 'arterior' ),
	'capability' => 'edit_theme_options',
	'panel' => 'arterior_section_panel'

	) );
	//Banner Section
	$wp_customize->add_setting( 'arterior_banner_display' , array(

	'default'   => false,

	'sanitize_callback' => 'arterior_sanitize_switch',

	) );

	$wp_customize->add_control( new Arterior_Toggle_Switch_Custom_Control( $wp_customize, 'arterior_banner_display_control', array(

	'label'      => esc_html__( 'Display this section', 'arterior' ),

	'section'    => 'arterior_section',

	'settings'   => 'arterior_banner_display',

	) ) );


	$wp_customize->add_setting( 'arterior_bannersection_texttitle' , array(

	'default'   => 'Luxurious',

	'sanitize_callback' => 'arterior_sanitise_custom_text',

	) );

	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'arterior_bannersection_texttitle_control', array(

	'label'      => esc_html__( 'Title', 'arterior' ),

	'section'    => 'arterior_section',

	'settings'   => 'arterior_bannersection_texttitle',

	'type' => 'text',   	
    

	) ) );

	$wp_customize->add_setting( 'arterior_bannersection_text' , array(

	'default'   => 'We Create a Comfortable Home Decore',

	'sanitize_callback' => 'arterior_sanitise_custom_text',

	) );

	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'arterior_bannersection_text_control', array(

	'label'      => esc_html__( 'Text', 'arterior' ),

	'section'    => 'arterior_section',

	'settings'   => 'arterior_bannersection_text',

	'type' => 'text',  
	) ) );

	$wp_customize->add_setting( 'arterior_bannersection_image' , array(

	'sanitize_callback' => 'arterior_sanitise_custom_url',

	'capability' => 'edit_theme_options',

	'type' => 'theme_mod',
	) );

	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'arterior_bannerection_image_control', array(

	'label'      => esc_html__( 'Image', 'arterior' ),

	'section'    => 'arterior_section',

	'settings'   => 'arterior_bannersection_image',
	) ) );


	//About Section
	$wp_customize->add_setting( 'arterior_about_display' , array(

	'default'   => false,

	'sanitize_callback' => 'arterior_sanitize_switch',

	) );

	$wp_customize->add_control( new Arterior_Toggle_Switch_Custom_Control( $wp_customize, 'arterior_about_display_control', array(

	'label'      => esc_html__( 'Display this section', 'arterior' ),

	'section'    => 'arterior_section_designwork',

	'settings'   => 'arterior_about_display',

	) ) );


	$wp_customize->add_setting( 'arterior_aboutsection_texttitle' , array(

	'default'   => 'Designed for the way you work',

	'sanitize_callback' => 'arterior_sanitise_custom_text',

	) );

	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'arterior_aboutsection_texttitle_control', array(

	'label'      => esc_html__( 'Title', 'arterior' ),

	'section'    => 'arterior_section_designwork',

	'settings'   => 'arterior_aboutsection_texttitle',

	'type' => 'text',   	
    

	) ) );

	$wp_customize->add_setting( 'arterior_aboutsection_text' , array(

	'default'   => 'Lorem ipsum dolor sit amet. Est quia eveniet hic optio consectetur est reiciendis perspiciatis qui galisum quia! 33 blanditiis ipsam ea suscipit recusandae et necessitatibus eligendi rem voluptatem libero. Est consequatur laudantium et nisi illum aut atque modi.Lorem ipsum dolor sit amet. Est quia eveniet hic optio consectetur est reiciendis perspiciatis qui galisum quia! 33 blanditiis ipsam ea suscipit recusandae et necessitatibus eligendi rem voluptatem libero. Est consequatur laudantium et nisi illum aut atque modi.',

	'sanitize_callback' => 'arterior_sanitise_custom_text',

	) );

	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'arterior_aboutsection_text_control', array(

	'label'      => esc_html__( 'Text', 'arterior' ),

	'section'    => 'arterior_section_designwork',

	'settings'   => 'arterior_aboutsection_text',

	'type' => 'textarea',   	
    

	) ) );

	$wp_customize->add_setting( 'arterior_button_display' , array(

	'default'   => false,

	'sanitize_callback' => 'arterior_sanitize_switch',

	) );

	$wp_customize->add_control( new Arterior_Toggle_Switch_Custom_Control( $wp_customize, 'arterior_button_display_control', array(

	'label'      => esc_html__( 'Display button', 'arterior' ),

	'section'    => 'arterior_section_designwork',

	'settings'   => 'arterior_button_display',

	) ) );

	//Theme Option
	//Footer Text
	$wp_customize->add_panel(
        'arterior_theme_section_panel',
        [
           'priority' => 30,
           'capability' => 'edit_theme_options',
           'title' => esc_html__('Theme Option Section', 'arterior'),
        ]
    );

    $wp_customize->add_section( 'arterior_footer_section' , array(

	'title'      => esc_html__( 'Footer Section', 'arterior' ),
	'capability' => 'edit_theme_options',
	'panel' => 'arterior_theme_section_panel'

	) );


	$wp_customize->add_setting( 'arterior_footertext_setting' , array(

	'default'   => esc_html__('Arterior WordPress Theme by','arterior'),

	'sanitize_callback' => 'arterior_sanitise_custom_text',

	) );

	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'arterior_aboutsection_text_control', array(

	'label'      => esc_html__( 'Footer Text', 'arterior' ),

	'section'    => 'arterior_footer_section',

	'settings'   => 'arterior_footertext_setting',
    

	) ) );

	$wp_customize->add_setting( 'arterior_footer_authortext_setting' , array(

	'default'   => esc_html__('Appnotick','arterior'),

	'sanitize_callback' => 'arterior_sanitise_custom_text',

	) );

	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'arterior_footerauthor_text_control', array(

	'label'      => esc_html__( 'Author Text', 'arterior' ),

	'section'    => 'arterior_footer_section',

	'settings'   => 'arterior_footer_authortext_setting',
    

	) ) );

	$wp_customize->add_section(
	'arterior_post_options',
	array(
		'title' => esc_html__( 'Post Options', 'arterior' ),
		'panel' => 'arterior_theme_section_panel',
		)
	);

	// Post Options - Hide Date.
	$wp_customize->add_setting(
		'arterior_post_hide_date',
		array(
			'default'           => false,
			'sanitize_callback' => 'arterior_sanitize_switch',
		)
	);

	$wp_customize->add_control(
		new Arterior_Toggle_Switch_Custom_Control(
			$wp_customize,
			'arterior_post_hide_date',
			array(
				'label'   => esc_html__( 'Hide Date', 'arterior' ),
				'section' => 'arterior_post_options',
			)
		)
	);

	// Post Options - Hide Author.
	$wp_customize->add_setting(
		'arterior_post_hide_author',
		array(
			'default'           => false,
			'sanitize_callback' => 'arterior_sanitize_switch',
		)
	);

	$wp_customize->add_control(
		new Arterior_Toggle_Switch_Custom_Control(
			$wp_customize,
			'arterior_post_hide_author',
			array(
				'label'   => esc_html__( 'Hide Author', 'arterior' ),
				'section' => 'arterior_post_options',
			)
		)
	);

	// Post Options - Comments.
	$wp_customize->add_setting(
		'arterior_post_comments',
		array(
			'default'           => false,
			'sanitize_callback' => 'arterior_sanitize_switch',
		)
	);

	$wp_customize->add_control(
		new Arterior_Toggle_Switch_Custom_Control(
			$wp_customize,
			'arterior_post_comments',
			array(
				'label'   => esc_html__( 'Hide Comments', 'arterior' ),
				'section' => 'arterior_post_options',
			)
		)
	);

	// Post Options - Hide Time.
	$wp_customize->add_setting(
		'arterior_post_hide_time',
		array(
			'default'           => false,
			'sanitize_callback' => 'arterior_sanitize_switch',
		)
	);

	$wp_customize->add_control(
		new Arterior_Toggle_Switch_Custom_Control(
			$wp_customize,
			'arterior_post_hide_time',
			array(
				'label'   => esc_html__( 'Hide Time', 'arterior' ),
				'section' => 'arterior_post_options',
			)
		)
	);
	
	function arterior_sanitise_custom_text($input){
		return filter_var($input, FILTER_SANITIZE_STRING);
	}

	function arterior_sanitise_custom_texttitle($inputtitle){
		return filter_var($inputtitle, FILTER_SANITIZE_STRING);
	}

	function arterior_sanitise_custom_url($input){
		return filter_var($input, FILTER_SANITIZE_URL);
	}

	function arterior_sanitize_switch( $input ) {
		if ( true === $input ) {
			return true;
		} else {
			return false;
		}
	}

	
}
add_action('customize_register', 'arterior_customizer_setting');

/**
 * Enqueue scripts and styles.
 */
function arterior_scripts() {
	wp_enqueue_style( 'arterior-bootstrap.min', get_stylesheet_directory_uri()."/assets/css/arterior-bootstrap.min.css",'', ARTERIOR_S_VERSION );
	wp_enqueue_style( 'arterior-style', get_stylesheet_uri(), array(), ARTERIOR_S_VERSION );
	wp_style_add_data( 'arterior-style', 'rtl', 'replace' );
	wp_enqueue_style( 'arterior-fonts', get_stylesheet_directory_uri()."/assets/fonts", array(), ARTERIOR_S_VERSION );

	wp_enqueue_script( 'arterior-navigation', get_template_directory_uri() . '/js/navigation.js', array(), ARTERIOR_S_VERSION, true );
	wp_enqueue_script( 'anterior-jquery.min', get_stylesheet_directory_uri() . '/assets/js/arterior-jquery.min.js', array(), ARTERIOR_S_VERSION, true );
	wp_enqueue_script( 'anterior-jquery.slim.min', get_stylesheet_directory_uri() . '/assets/js/arterior-jquery.slim.min.js', array(), ARTERIOR_S_VERSION, true );
	wp_enqueue_script( 'arterior-fontawesome', get_stylesheet_directory_uri() . '/assets/js/fontawesome.js', array(), ARTERIOR_S_VERSION, true );
	wp_enqueue_script( 'anterior-custom', get_stylesheet_directory_uri() . '/assets/js/custom.js', array(), ARTERIOR_S_VERSION, true );
	wp_enqueue_script( 'anterior-bootstrap.min', get_stylesheet_directory_uri() . '/assets/js/bootstrap.min.js', array(), ARTERIOR_S_VERSION, true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
	/* Enqueue the Dashicons script */
	wp_enqueue_style( 'dashicons' );
}
add_action( 'wp_enqueue_scripts', 'arterior_scripts' );

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require get_template_directory() . '/inc/jetpack.php';
}

