<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Arterior
 */

?>
	<footer id="colophon" class="site-footer border-top">
		<div class="container footer-container">
	    	<div class="row">
	    		<div class="col-lg-3 col-md-3 col-12 align-self-lg-center">
					<?php if ( has_nav_menu( 'footer' ) ): ?>
			            <nav class="navbar footer-menu">
							<?php
								wp_nav_menu( array(
									'theme_location' => 'footer',
									'container'      => 'div',
									'container_id'   => 'main-nav',
									'menu_id'        => false,
									'depth'          => 1,
								) );
							?>
			            </nav>
					<?php endif ?>
				</div>
		        <div class="site-info col-lg-9 col-md-9 col-12">
		            <div class="footer-menu-left">
		            	<?php if(! get_theme_mod('arterior_footer_text_setting') != ''){ ?>
						    <a href="<?php echo esc_url( __( 'https://wordpress.org/', 'arterior' ) ); ?>">
								<?php
								/* translators: %s: CMS name, i.e. WordPress. */
								printf( esc_html__( 'Proudly powered by %s', 'arterior' ), 'WordPress' );
								?>
							</a>
						    <span class="sep mr-1"> | </span>
						    <span>
					           	<?php
					            	/* translators: 1: Theme name,  */
					            	printf( esc_html( get_theme_mod('arterior_footertext_setting','Arterior WordPress Theme by' )) );
					            ?>
						        <?php
						        	/* translators: 1: Theme author. */				
						        	echo esc_html(get_theme_mod('arterior_footer_authortext_setting','Appnotick'));
						        	
						        ?>
						    </span>
						<?php }?>
						<?php echo esc_html(get_theme_mod('arterior_footer_text_setting','')); ?>
		            </div>
		        </div>
		    </div>

	     <a href="#" class="scrollup"><i id="scrolltop" class="<?php echo esc_attr(get_theme_mod('arterior_scroll_to_top_icon','fas fa-long-arrow-alt-up')); ?>"></i><span class="screen-reader-text"><?php esc_html_e( 'Scroll Up', 'arterior' ); ?></span></a>

   
	</footer><!-- #colophon -->
</div><!-- #page -->

<?php wp_footer(); ?>

</body>
</html>
