<?php

/**
 * Art Portfolio Welcome Notice
 *
 * @package artportfolio
 */

// Add custom welcome notice for Art Portfolio
add_action( 'after_switch_theme', 'artportfolio_set_activation_flag' );
add_action( 'admin_notices', 'artportfolio_welcome_notice' );
add_action( 'wp_ajax_artportfolio_dismiss_notice', 'artportfolio_dismiss_notice' );

// Hide parent theme's welcome notice when child theme is active
add_action( 'init', 'artportfolio_hide_parent_notice' );
function artportfolio_hide_parent_notice() {
    // Remove parent theme's welcome notice
    remove_action( 'admin_notices', 'minimalio_welcome_notice' );
}

function artportfolio_set_activation_flag() {
    set_transient( 'artportfolio_show_welcome_notice', true, WEEK_IN_SECONDS );
}


function artportfolio_welcome_notice() {
    $screen = get_current_screen();
    if ( $screen->id !== 'themes' ) {
        return;
    }

    if ( ! get_transient( 'artportfolio_show_welcome_notice' ) ) {
        return;
    }

    if ( get_user_meta( get_current_user_id(), 'artportfolio_dismissed_notice', true ) ) {
        return;
    }

    // Get current theme info
    $theme = wp_get_theme();
    $theme_name = $theme->get( 'Name' );
    $screenshot = $theme->get_screenshot();
    
    // Prepare welcome message
    $welcome_title = sprintf( __( 'Thank you for using %s!', 'art-portfolio' ), $theme_name );
    $welcome_text = __( 'You are using a child theme based on Minimalio. Please checkout the Minimalio admin page, where you can find the demos, tutorials and more.', 'art-portfolio' );
    $customizer_text = __( 'And please, also check out the video tutorial how to achieve the exact look of this theme!', 'art-portfolio' );
    $screenshot_alt = sprintf( __( '%s Theme Screenshot', 'art-portfolio' ), $theme_name );
    ?>
    <div class="notice notice-success is-dismissible minimalio-welcome-notice artportfolio-welcome-notice">
        <div class="minimalio-notice-content">
            <div class="minimalio-notice-text">
                <h1><?php echo esc_html( $welcome_title ); ?></h1>
                <p><?php echo esc_html( $welcome_text ); ?></p>
                <p><?php echo esc_html( $customizer_text ); ?></p>
                <div>
                    <a href="https://minimalio.org/art-portfolio-child-theme/" target="_blank" class="button minimalio-premium-button">
                        <?php _e( 'How to Set Up Video Tutorial', 'art-portfolio' ); ?>
                    </a>             
                    <a href="<?php echo admin_url( 'admin.php?page=minimalio-dashboard' ); ?>" style="margin-top: 10px; margin-left: 10px;" class="button">
                        <?php _e( 'Minimalio Admin Page', 'art-portfolio' ); ?>
                    </a>
                </div>
            </div>
            <?php if ( $screenshot ) : ?>
            <div class="minimalio-notice-image">
                <img src="<?php echo esc_url( $screenshot ); ?>" alt="<?php echo esc_attr( $screenshot_alt ); ?>">
            </div>
            <?php endif; ?>
        </div>
    </div>
        <script>
        jQuery(document).ready(function($) {
            $('.artportfolio-welcome-notice').on('click', '.notice-dismiss', function() {
                $.post(ajaxurl, {
                    action: 'artportfolio_dismiss_notice',
                    notice: 'artportfolio-welcome-notice',
                    nonce: '<?php echo wp_create_nonce( 'artportfolio_dismiss_notice' ); ?>'
                });
            });
        });
        </script>
    <?php
}

function artportfolio_dismiss_notice() {
    check_ajax_referer( 'artportfolio_dismiss_notice', 'nonce' );
    
    if ( isset( $_POST['notice'] ) && $_POST['notice'] === 'artportfolio-welcome-notice' ) {
        // Set user meta to permanently dismiss the notice for this user
        update_user_meta( get_current_user_id(), 'artportfolio_dismissed_notice', true );
        delete_transient( 'artportfolio_show_welcome_notice' );
        wp_die();
    }
    
    wp_die();
}