<?php

/**
 * Art Portfolio Admin Redirect and Dashboard Customization
 *
 * @package artportfolio
 */


// Add Art Portfolio section to the top of Minimalio admin page
add_action( 'admin_init', 'artportfolio_modify_admin_output' );
function artportfolio_modify_admin_output() {
    add_action( 'admin_head', 'artportfolio_buffer_admin_page' );
}

function artportfolio_buffer_admin_page() {
    global $pagenow;
    if ( isset( $_GET['page'] ) && $_GET['page'] === 'minimalio-dashboard' ) {
        ob_start( 'artportfolio_inject_admin_content' );
    }
}

function artportfolio_inject_admin_content( $buffer ) {
    // Find the position after the h1 title
    $search = '<h1>' . __( 'Minimalio Dashboard', 'minimalio' ) . '</h1>';
    $pos = strpos( $buffer, $search );
    
    if ( $pos !== false ) {
        $art_portfolio_section = '
        <div class="minimalio-admin-card artportfolio-welcome-section">
            <div class="minimalio-two-columns">
                <div class="minimalio-column-text">
                    <h2>' . __( 'Welcome to Art Portfolio!', 'art-portfolio' ) . '</h2>
                    <p class="minimalio-moto">' . __( 'Child theme of Minimalio', 'art-portfolio' ) . '</p>
                    
                    <p>' . __( 'Art Portfolio extends Minimalio with additional Theme Settings.', 'art-portfolio' ) . '</p>

                    <p>' . __( 'Please, check out this tutorial for using this child theme.', 'art-portfolio' ) . '</p>
                    
                    <a href="https://minimalio.org/art-portfolio-child-theme/" target="_blank" class="button button-primary">
                        ' . __( 'Art Portfolio Tutorial', 'art-portfolio' ) . '
                    </a>
                    
                    <a href="https://eadweard.minimalio.org"  target="_blank" class="button button-secondary">
                        ' . __( 'View Demo Site', 'art-portfolio' ) . '
                    </a>
                </div>
                <div class="minimalio-column-video">
                   
                    <img style="max-width:300px; float:right; border: 1px solid #000;" src="' . esc_url( get_stylesheet_directory_uri() . '/screenshot.png' ) . '" style="" alt="' . esc_attr__( 'Art Portfolio Theme Screenshot', 'art-portfolio' ) . '">
                </div>
            </div>
        </div>';
        
        // Insert after the h1 title
        $insert_pos = $pos + strlen( $search );
        $buffer = substr_replace( $buffer, $art_portfolio_section, $insert_pos, 0 );
    }
    
    return $buffer;
}