<?php

/**
 * Art Portfolio - Minimalio Child Theme
 *
 * @package artportfolio
 */

//Add Minimalio default styles
add_action('wp_enqueue_scripts', 'artportfolio_theme_enqueue_styles', 97);
function artportfolio_theme_enqueue_styles()
{
    $parenthandle = 'art-portfolio-parent-style';
    $theme = wp_get_theme();
    wp_enqueue_style(
        $parenthandle,
        get_template_directory_uri() . '/style.css',
        array(),  // if the parent theme code has a dependency, copy it to here
        $theme->parent()->get('Version')
    );
}

//Add Art Portfolio styles
add_action('wp_enqueue_scripts', 'artportfolio_child_add_stylesheet', 99);
function artportfolio_child_add_stylesheet()
{
    wp_enqueue_style('artportfolio-child-style', get_stylesheet_directory_uri() . '/style.css', false, '1.0', 'all');
}


//Add Art Portfolio custom styles
add_action('wp_enqueue_scripts', 'artportfolio_child_add_custom_stylesheet', 98);
function artportfolio_child_add_custom_stylesheet()
{
    wp_enqueue_style('artportfolio-child-custom-style', get_stylesheet_directory_uri() . '/assets/artportfolio-styles.css', false, '1.0', 'all');
}


//Add Art Portfolio custom scripts
add_action('wp_enqueue_scripts', 'artportfolio_scripts_child_theme');
function artportfolio_scripts_child_theme()
{
    wp_enqueue_script(
        'custom-script',
        get_stylesheet_directory_uri() . '/assets/artportfolio-script.js',
        array('jquery')
    );
}

//Make Art Portfolio available for translation.
load_theme_textdomain('art-portfolio', get_stylesheet_directory_uri() . '/languages');

// Set up the WordPress Theme logo feature.
add_theme_support( 'custom-logo' );


// Include files for the Art Portfolio Customizer options
$artportfolio_includes = [
    '/artportfolio-customizer/artportfolio-customizer.php',
    '/artportfolio-customizer/artportfolio-theme-customizer.php',
    '/preview-content/preview-content.php',
    '/preview-content/admin-redirect.php',
    '/preview-content/welcome-notice.php'
];

foreach ($artportfolio_includes as $file) {
    $filepath = locate_template($file);
    if (! $filepath) {
        trigger_error(sprintf('Error locating /inc%s for inclusion', $file), E_USER_ERROR);
    }
    require_once $filepath;
}