<?php
/**
 * Art Portfolio - Minimalio Theme
 * Inline styles
 *
 * @package artportfolio
 */

defined( 'ABSPATH' ) || exit();

function artportfolio_child_dynamic_styles() {

	$styles = [
		'menu_margin'         => get_theme_mod(
			'artportfolio_settings_menu_margin'
		),
		'category_size'         => get_theme_mod(
			'artportfolio_settings_category_font_size'
		),
		'category_margin_top'         => get_theme_mod(
			'artportfolio_settings_category_margin_top'
		),
		'category_align'         => get_theme_mod(
			'artportfolio_settings_category_align'
		),
	];


	global $artportfolio_parameters;
	$artportfolio_parameters = $styles;
	$css = require_once(__DIR__ . '/artportfolio-customizer.css.php');

	wp_register_style( 'artportfolio-options', false );
	wp_enqueue_style( 'artportfolio-options' );

	wp_add_inline_style(
		'artportfolio-options',
		$css,
	);
}
add_action( 'wp_enqueue_scripts', 'artportfolio_child_dynamic_styles' );


