<?php
/**
 * Art Portfolio - artportfolio Theme Customizer
 *
 * @package artportfolio
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit();

new Artportfolio_Child_Customizer();
class Artportfolio_Child_Customizer {
	/**
	 * Called on class initialisation
	 */
	public function __construct() {
		/* Add the WordPress actions to register customizer components */
		add_action( 'customize_register', [ $this, 'artportfolio_settings' ] );
	}

	/**
	 * Register artportfolio customizer area
	 * @return null
	 */
	public function artportfolio_settings( $customizer ) {
		if ( ! function_exists( 'artportfolio_theme_slug_sanitize_select' ) ) {
			/**
			 * Select sanitization function
			 * @param string               $input Ensure input is a slug.
			 * @param WP_Customize_Setting $setting Settings.
			 * @return string
			 */
			function artportfolio_theme_slug_sanitize_select( $input, $setting ) {
				// Ensure input is a slug (lowercase alphanumeric characters, dashes and underscores are allowed only).
				$input = sanitize_key( $input );
				// Get the list of possible select options.
				$choices = $setting->manager->get_control( $setting->id )
					->choices;
				// If the input is a valid key, return it; otherwise, return the default.
				return array_key_exists( $input, $choices )
					? $input
					: $setting->default;
			}
			// old definition here
		}



		


		// Theme Layout options
		$customizer->add_section('artportfolio_theme_child_options', [
			'title'      => esc_html__( 'Art Portfolio Child', 'art-portfolio' ),
			'capability' => 'edit_theme_options',
			'panel'      => 'minimalio_panel',
		]);

		// Settings

		$customizer->add_setting('artportfolio_settings_menu_margin', [
			'default'           => 0,
			'type'              => 'theme_mod',
			'sanitize_callback' => 'sanitize_text_field',
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
		]);

		$customizer->add_setting('artportfolio_settings_category_font_size', [
			'default'           => 20,
			'type'              => 'theme_mod',
			'sanitize_callback' => 'sanitize_text_field',
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
		]);

		$customizer->add_setting('artportfolio_settings_category_margin_top', [
			'default'           => 0,
			'type'              => 'theme_mod',
			'sanitize_callback' => 'sanitize_text_field',
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
		]);

		$customizer->add_setting('artportfolio_settings_category_align', [
			'default'           => 'left',
			'type'              => 'theme_mod',
			'sanitize_callback' => 'sanitize_text_field',
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
		]);

		// Controls
		$customizer->add_control(
			new WP_Customize_Control(
				$customizer,
				'artportfolio__options_menu_margin',
				[
					'label'       => esc_html__( 'Vertical Menu Margin Top ', 'art-portfolio' ),
					'description' => esc_html__(
						'Number in REM values (1REM=16px)',
						'art-portfolio'
					),
					'section'     => 'artportfolio_theme_child_options',
					'settings'    => 'artportfolio_settings_menu_margin',
					'type'        => 'number',
				]
			)
		);

		$customizer->add_control(
			new WP_Customize_Control(
				$customizer,
				'artportfolio__options_category_font_size',
				[
					'label'       => esc_html__( 'Portfolio/Blog Category Filtering Font Size', 'art-portfolio' ),
					'description' => esc_html__(
						'Number in PX',
						'art-portfolio'
					),
					'section'     => 'artportfolio_theme_child_options',
					'settings'    => 'artportfolio_settings_category_font_size',
					'type'        => 'number',
				]
			)
		);

		$customizer->add_control(
			new WP_Customize_Control(
				$customizer,
				'artportfolio__options_category_margin_top',
				[
					'label'       => esc_html__( 'Portfolio/Blog Category Filtering Top Margin', 'art-portfolio' ),
					'description' => esc_html__(
						'Number in PX',
						'art-portfolio'
					),
					'section'     => 'artportfolio_theme_child_options',
					'settings'    => 'artportfolio_settings_category_margin_top',
					'type'        => 'number',
				]
			)
		);

		$customizer->add_control(
			new WP_Customize_Control(
				$customizer,
				'artportfolio__options_category_align',
				[
					'label'       => esc_html__( 'Portfolio/Blog Category Filtering Align ', 'art-portfolio' ),
					'section'     => 'artportfolio_theme_child_options',
					'settings'    => 'artportfolio_settings_category_align',
					'type'     => 'select',
					'sanitize_callback' =>
						'artportfolio_theme_slug_sanitize_select',
					'choices'  => [
						'justify-between' => esc_html__( 'Left', 'art-portfolio' ),
						'flex-end' => esc_html__( 'Right', 'art-portfolio' ),
						'center' => esc_html__( 'Center', 'art-portfolio' ),
					],
				]
			)
		);

	

        return $customizer;
	}
}

