<?php
/**
 * Ariland functions and definitions.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Ariland
 */

if ( ! defined( 'ARILAND_VERSION' ) ) {
	// Replace the version number of the theme on each release.
	define( 'ARILAND_VERSION', '1.0.0' );
}

if ( ! function_exists( 'ariland_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function ariland_setup() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on ariland, use a find and replace
		 * to change 'ariland' to the name of your theme in all the template files.
		 */
		load_theme_textdomain( 'ariland', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support( 'post-thumbnails' );

		// This theme uses wp_nav_menu() in one location.
		register_nav_menus(
			array(
				'menu-1' => esc_html__( 'Primary', 'ariland' ),
			)
		);

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support(
			'html5',
			array(
				'search-form',
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
				'style',
				'script',
			)
		);

		// Set up the WordPress core custom background feature.
		add_theme_support(
			'custom-background',
			apply_filters(
				'ariland_custom_background_args',
				array(
					'default-color' => 'ffffff',
					'default-image' => '',
				)
			)
		);

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support(
			'custom-logo',
			array(
				'height'      => 90,
				'width'       => 90,
				'flex-width'  => true,
				'flex-height' => true,
			)
		);
	}
endif;
add_action( 'after_setup_theme', 'ariland_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function ariland_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'ariland_content_width', 640 );
}
add_action( 'after_setup_theme', 'ariland_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function ariland_widgets_init() {
	register_sidebar(
		array(
			'name'          => esc_html__( 'Sidebar', 'ariland' ),
			'id'            => 'sidebar-1',
			'description'   => esc_html__( 'Add widgets here.', 'ariland' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);

	 
}
add_action( 'widgets_init', 'ariland_widgets_init' );

/**
 * Enqueue scripts and styles.
 */
function ariland_scripts() {
	wp_enqueue_style( 'ariland-style', get_stylesheet_uri(), array(), ARILAND_VERSION );
	wp_style_add_data( 'ariland-style', 'rtl', 'replace' );

	wp_enqueue_style( 'fontawesome', get_template_directory_uri() . '/css/font-awesome/css/fontawesome-all-v5.3.1.min.css' );
	wp_enqueue_style( 'ariland-fonts', 'https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,400;0,600;0,700;1,400;1,600;1,700&family=Roboto:ital,wght@0,400;0,700;1,400;1,700&display=swap', array(), null );

	wp_enqueue_script( 'ariland-navigation', get_template_directory_uri() . '/js/navigation.js', array(), ARILAND_VERSION, true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'ariland_scripts' );

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Breadcbrumbs
 */
require get_template_directory() . '/inc/breadcrumb.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

// Custom comment walker.
require get_template_directory() . '/inc/class-walker-comment.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';
require get_template_directory() . '/inc/customizer-typography.php';
require get_template_directory() . '/inc/class-customize.php';







/**
 * Compare page CSS
 */

function ariland_comparepage_css($hook) {
	if ( 'appearance_page_ariland-info' != $hook ) {
		return;
	}
	wp_enqueue_style( 'ariland-custom-style', get_template_directory_uri() . '/css/compare.css' );
}
add_action( 'admin_enqueue_scripts', 'ariland_comparepage_css' );

/**
 * Compare page content
 */

add_action('admin_menu', 'ariland_themepage');
function ariland_themepage(){
	$theme_info = add_theme_page( __('Ariland Info','ariland'), __('Ariland Info','ariland'), 'manage_options', 'ariland-info.php', 'ariland_info_page' );
}

function ariland_info_page() {
	$user = wp_get_current_user();
	?>
	<div class="wrap about-wrap ariland-add-css">
		<div>
			<h1>
				<?php echo esc_html_e('Thank you for using Ariland Theme','ariland'); ?>
			</h1>

			<div class="feature-section three-col">
				<div class="col">
					<div class="widgets-holder-wrap">
						<h3><?php echo esc_html_e("View Premium Edition Theme Demo", "ariland"); ?></h3>
						<p><?php echo esc_html_e("You can see more features & functionality in our PRO Version. You will get tension free many advance theme options just to customize your theme very easily. Watch the Demo by clicking the link below.", "ariland"); ?></p>
						<p><a target="blank" href="http://arinio.com/ariland-responsive-multipurpose-wordpress-theme/" class="button button-primary">
							<?php echo esc_html_e("View Demo", "ariland"); ?>
						</a></p>
					</div>
				</div>
				<div class="col">
					<div class="widgets-holder-wrap">
						<h3><?php echo esc_html_e("View our other themes", "ariland"); ?></h3>
						<p><?php echo esc_html_e("Want to see more our amazing themes you simply visit our site. Click the link below.", "ariland"); ?></p>
						<p><a target="blank" href="http://arinio.com/" class="button button-primary">
							<?php echo esc_html_e("View All Themes", "ariland"); ?>
						</a></p>
					</div>
				</div>
				 
			</div>
		</div>
		<hr>

		<h2><?php echo esc_html_e("Get Ariland PRO Theme Just $12","ariland"); ?></h2>
		<div class="col">
					<div class="widgets-holder-wrap">
						 <p><?php echo esc_html_e("You are using the Ariland, Free Version of Ariland Pro Theme. Upgrade to Pro for extra features like Home Page Unlimited Slider, Work Gallery, Team section, Client Section, Contact Page and many more Page Templates, Social Link Section, Documents, Life time theme support and much more.", "ariland"); ?></p>
						 
					</div>
				</div>
		<div class="ariland-button-container">
			<a target="blank" href="http://arinio.com/ariland-responsive-multipurpose-wordpress-theme/" class="button button-primary arilandbt">
				<?php echo esc_html_e("Upgrade to Ariland Pro", "ariland"); ?>
			</a>
		</div>


		

	</div>
	<?php
}
