<?php
/**
 * Functions.php
 *
 * Magic happens here,
 * If you're not comfortable with PHP / WordPress, please do not edit this file.
 *
 * CAUTION: all the changes you do to this file, will be lost upon theme update. 
 * I would highly recommend making changes only in a child theme.
 * http://codex.wordpress.org/Child_Themes
 *
 * @package Aries
 * @since 1.0.0
 * @author Tom <hello@wplov.in>
 */

/**
 * Setup some basic constants.
 *
 * @package Aries
 * @since 1.0.0
 */
define( 'WPLOVIN_THEME_VERSION', '1.0.1' );
define( 'WPLOVIN_THEME_NAME', 'Aries' );
define( 'WPLOVIN_THEME_SLUG', 'aries' );
define( 'WPLOVIN_THEME_URL', 'http://wplov.in/wordpress-themes/aries' );
define( 'WPLOVIN_THEME_AUTHOR', 'Tom' );
define( 'WPLOVIN_THEME_AUTHOR_EMAIL', 'hello@wplov.in' );
define( 'WPLOVIN_THEME_AUTHOR_URL', 'http://wplov.in/' );
define( 'WPLOVIN_THEME_PATH', get_template_directory_uri() );

/**
 * Set the content width.
 *
 * @package Aries
 * @since 1.0.0
 */
if ( ! isset( $content_width ) ) {
	$content_width = 780;
}

/**
 * Aries only works in WordPress 4.1 or later. 
 * 
 * @package Aries
 * @since 1.0.0
 */
if ( version_compare( $GLOBALS['wp_version'], '4.1-alpha', '<' ) ) {
	require get_template_directory() . '/inc/back-compat.php';
}

/**
 * Customizer additions.
 *
 * @package Aries
 * @since 1.0.0
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Setup the theme.
 *
 * @package Aries
 * @since 1.0.0
 */
function aries_setup() {
    load_theme_textdomain( 'aries', get_template_directory() . '/languages' );
    add_theme_support( 'automatic-feed-links' );
    add_theme_support( 'html5', array( 'search-form', 'comment-form', 'comment-list' ) );
    add_theme_support( 'post-formats', array( 'aside', 'audio', 'chat', 'gallery', 'image', 'link', 'quote', 'status', 'video' ) );
    add_theme_support( 'post-thumbnails' );
    $background_defaults = array(
		'wp-head-callback'       => 'aries_custom_background_cb',
	);
    add_theme_support( 'custom-background', $background_defaults );
    add_theme_support( 'title-tag' );
    register_nav_menu( 'primary', __( 'Navigation Menu', 'aries' ) );
    if ( ! isset( $content_width ) )  $content_width = 780;
    add_filter( 'use_default_gallery_style', '__return_false' );
    //add_editor_style( array( 'editor-style.css' ) );
}
add_action( 'after_setup_theme', 'aries_setup' );

/**
 * Register widgetized areas.
 *
 * @package Aries
 * @since 1.0.0
 */
function aries_sidebar_init() {
	register_sidebar( array(
		'name'          => __( 'Main Widget Area', 'aries' ),
		'id'            => 'sidebar-1',
		'description'   => __( 'Main sidebar.', 'aries' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );		
}
add_action( 'widgets_init', 'aries_sidebar_init' );

/**
 * Conditionally include needed JavaScript plugins, stylesheets, etc.
 *
 * @package Aries
 * @since 1.0.0
 */
function aries_scripts_styles() {
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) 
		wp_enqueue_script( 'comment-reply' );

	wp_enqueue_style( WPLOVIN_THEME_SLUG . '-crete-round', aries_fonts_url(), array(), WPLOVIN_THEME_VERSION );	
	wp_enqueue_style( WPLOVIN_THEME_SLUG . '-fa-icons', WPLOVIN_THEME_PATH . '/assets/font-awesome/css/font-awesome.min.css', array(), 'v4.3.0' );
	wp_enqueue_style( WPLOVIN_THEME_SLUG . '-styles', apply_filters( 'aries_stylesheet_url' , get_stylesheet_uri() ), array(), WPLOVIN_THEME_VERSION );
	if( is_child_theme() ) wp_enqueue_style( WPLOVIN_THEME_SLUG . '-child-styles',  get_stylesheet_uri(), array(), WPLOVIN_THEME_VERSION );
	wp_enqueue_script( WPLOVIN_THEME_SLUG .'-fitvids-js', WPLOVIN_THEME_PATH . '/js/jquery.fitvids.js', array( 'jquery' ), 'v1.0.3', true );
	wp_enqueue_script( WPLOVIN_THEME_SLUG .'-scripts', WPLOVIN_THEME_PATH . '/js/scripts.js', array( 'jquery' ), WPLOVIN_THEME_VERSION, true );
}
add_action( 'wp_enqueue_scripts', 'aries_scripts_styles' );

/**
 * Filter out and return correct stylesheet URL.
 *
 * @package Aries
 * @since 1.0.1
 */
function aries_stylesheet_skin_url( $aries_stylesheet_url ){
	$predefined_color_schemes = array( 'default', 'red', 'violet', 'blue', 'green', 'yellow', 'black' );
	$skin = get_theme_mod( 'aries_color_scheme' );

	if( ! in_array( $skin, $predefined_color_schemes ) ) $skin = 'default';

	if( $skin == 'default' ) {
		$aries_stylesheet_url = get_stylesheet_uri();
		if( is_child_theme() ) $aries_stylesheet_url = get_template_directory_uri() . '/style.css';
	} else {
		$aries_stylesheet_url = WPLOVIN_THEME_PATH . '/skins/skin-' . $skin . '.css'; 
	}

	return $aries_stylesheet_url;
}
add_filter( 'aries_stylesheet_url', 'aries_stylesheet_skin_url', 10, 1 );

/**
 * Return the Google font stylesheet URL, if available.
 *
 * The use of Crete Round by default is localized. For languages
 * that use characters not supported by the font, the font can be disabled.
 *
 * Credits: Twenty Thirteen.
 *
 * @package Aries
 * @since 1.0.0
 */
function aries_fonts_url() {
	$fonts_url = '';
	/* Translators: If there are characters in your language that are not
	 * supported by Crete Round, translate this to 'off'. Do not translate
	 * into your own language.
	 */
	$crete_round = _x( 'on', 'Crete Round font: on or off', 'aries' );
	if ( 'off' !== $crete_round ) {
		$font_families = array();
		$font_families[] = 'Crete Round';
		$query_args = array(
			'family' => urlencode( implode( '|', $font_families ) ),
			'subset' => urlencode( 'latin,latin-ext' ),
		);
		$fonts_url = add_query_arg( $query_args, "//fonts.googleapis.com/css" );
	}
	return $fonts_url;
}

/**
 * Return class for .content-wrap HTML element.
 *
 * @package Aries
 * @since 1.0.0
 */
function get_aries_content_wrap_class(){
	$classes = array();
	if ( is_active_sidebar( 'sidebar-1' ) ) {
		$classes[] = 'sidebar-active';
	} else {
		$classes[] = 'sidebar-inactive';
	}
	$classes = apply_filters( 'aries_content_wrap_classes', $classes );
	return implode(' ', $classes);
}

/**
 * Echo additional .content-wrap classes.
 *
 * @package Aries
 * @since 1.0.0
 */
function aries_content_wrap_class(){
	echo get_aries_content_wrap_class();
}

/**
 * Filters out empty post title, and sets it to 'Untitled'.
 *
 * @package Aries
 * @since 1.0.0
 */
function aries_filter_post_title( $title ){
	if( $title == '' || !$title ) {
		$title = __('Untitled', 'aries');
	}
	return $title;
}
add_filter( 'the_title', 'aries_filter_post_title' );

/**
 * Custom background image wp_head() callback, to enable 'Full Screen Background'.
 *
 * @package Aries
 * @since 1.0.0
 */
function aries_custom_background_cb() {
	$background = set_url_scheme( get_background_image() );
	$color = get_background_color();

	if( $color === get_theme_support( 'custom-background', 'default-color' ) ) {
		$color = false;
	}

	if( ! $background && ! $color )
		return;

	$style = $color ? "background-color: #$color;" : '';

	if( $background ) {
		$image = " background-image: url('$background');";

		$repeat = get_theme_mod( 'background_repeat', get_theme_support( 'custom-background', 'default-repeat' ) );
		if( !in_array( $repeat, array( 'no-repeat', 'repeat-x', 'repeat-y', 'repeat' ) ) )
			$repeat = 'repeat';
		$repeat = " background-repeat: $repeat;";

		$position = get_theme_mod( 'background_position_x', get_theme_support( 'custom-background', 'default-position-x' ) );
		if( !in_array( $position, array( 'center', 'right', 'left' ) ) )
			$position = 'left';
		$position = " background-position: top $position;";

		if( get_theme_mod( 'aries_fullscreen_bg' ) == true ) $position = " background-size: cover;";

		$attachment = get_theme_mod( 'background_attachment', get_theme_support( 'custom-background', 'default-attachment' ) );
		if( !in_array( $attachment, array( 'fixed', 'scroll' ) ) )
			$attachment = 'scroll';
		$attachment = " background-attachment: $attachment;";

		$style .= $image . $repeat . $position . $attachment;
	}
	?>
		<style type="text/css" id="custom-background-css">
		body.custom-background { <?php echo trim( $style ); ?> }
		</style>
	<?php
}

/**
 * Function which returns the post date.
 *
 * @package Aries
 * @since 1.0.0
 */
if ( ! function_exists( 'aries_get_post_date' ) ) {
	function aries_get_post_date() {
	
		if ( has_post_format( array( 'chat', 'status' ) ) )
			$format_prefix = _x( '%1$s on %2$s', '1: post format name. 2: date', 'aries' );
		else
			$format_prefix = '%2$s';
		$date = sprintf( '<span class="date"><i class="fa fa-calendar"></i><a href="%1$s" title="%2$s" rel="bookmark"><time class="entry-date" datetime="%3$s">%4$s</time></a></span>',
			esc_url( get_permalink() ),
			esc_attr( sprintf( __( 'Permalink to %s', 'aries' ), the_title_attribute( 'echo=0' ) ) ),
			esc_attr( get_the_date( 'c' ) ),
			esc_html( sprintf( $format_prefix, get_post_format_string( get_post_format() ), get_the_date() ) )
		);
		return $date;
	}
	
}

/**
 * Function which prints out the post meta.
 *
 * @package Aries
 * @since 1.0.0
 */
if ( ! function_exists( 'aries_post_meta' ) ) {
	function aries_post_meta() {

		if( !is_page() && is_singular() && ('chat' != get_post_format() && 'quote' != get_post_format() && 'status' != get_post_format() ) ) {
			$categories = get_the_category_list( __( ', ', 'aries' ) );
			if ( $categories ) {
				echo '<span class="categories"><i class="fa fa-folder-open"></i>' . $categories . '</span>';
			}
			$tags = get_the_tag_list( '', __( ', ', 'aries' ) );
			if ( $tags ) {
				echo '<span class="tags"><i class="fa fa-tags"></i>' . $tags . '</span>';
			}
		}

	}
	
}

/**
 * Function which prints out archive header.
 *
 * @package Aries
 * @since 1.0.0
 */
if ( ! function_exists( 'aries_archive_title' ) ) {
	function aries_archive_title() { 
	
		if( !is_home() && !is_404() ) { ?>
		<h3 class="archive-title"><?php
			if ( is_day() ) :
				printf( __( 'Browsing daily archives: %s', 'aries' ), '<span>' . get_the_date() . '</span>' );
			elseif ( is_month() ) :
				printf( __( 'Browsing monthly archives: %s', 'aries' ), '<span>' . get_the_date( _x( 'F Y', 'monthly archives date format', 'aries' ) ) . '</span>' );
			elseif ( is_year() ) :
				printf( __( 'Browsing yearly archives: %s', 'aries' ), '<span>' . get_the_date( _x( 'Y', 'yearly archives date format', 'aries' ) ) . '</span>' );
			elseif ( is_category() )  :
				printf( __( 'Browsing category archives: %s', 'aries' ), '<span>' . single_cat_title( '', false ) . '</span>' );
			elseif ( is_tag() )  :
				printf( __( 'Browsing tag archives: %s', 'aries' ), '<span>' . single_tag_title( '', false ) . '</span>' );				
			elseif ( is_search() )  :
				printf( __( 'Browsing search results: %s', 'aries' ), '<span>' . esc_html( $_GET['s'] ) . '</span>' );
			else : 
				_e( 'Archives', 'aries' ); 
			endif;
		?></h3>
	<?php } 
	
	}
}

/**
 * Go on! This theme is meant for hacking. 
 *
 * Add some codes below this line to tweak it further, and don't forget to report the bugs to hello@wplovin.com, thanks!
 *
 * CAUTION: all the changes you do to this file, will be lost upon theme update. 
 * I would highly recommend making changes only in a child theme.
 * http://codex.wordpress.org/Child_Themes
 *
 */
