<?php
/**
 * The template for displaying single posts and pages.
 * @package Architect Contractor
 * @since 1.0.0
 */

get_header();

$architect_contractor_default = architect_contractor_get_default_theme_options();
$architect_contractor_global_layout = get_theme_mod('architect_contractor_global_sidebar_layout', $architect_contractor_default['architect_contractor_global_sidebar_layout']);
$architect_contractor_page_layout = get_theme_mod('architect_contractor_page_sidebar_layout', $architect_contractor_global_layout);
$architect_contractor_post_layout = get_theme_mod('architect_contractor_post_sidebar_layout', $architect_contractor_global_layout);
$architect_contractor_post_meta = get_post_meta(get_the_ID(), 'architect_contractor_post_sidebar_option', true);

$architect_contractor_final_layout = $architect_contractor_global_layout;
if (!empty($architect_contractor_post_meta) && $architect_contractor_post_meta !== 'default') {
    $architect_contractor_final_layout = $architect_contractor_post_meta;
} elseif (is_page() || (function_exists('is_shop') && is_shop())) {
    $architect_contractor_final_layout = $architect_contractor_page_layout;
} elseif (is_single()) {
    $architect_contractor_final_layout = $architect_contractor_post_layout;
}

// Set content column order based on sidebar layout
$architect_contractor_sidebar_column_class = 'column-order-1';
if ($architect_contractor_final_layout === 'left-sidebar') {
    $architect_contractor_sidebar_column_class = 'column-order-2';
}

?>

<div id="single-page" class="singular-main-block">
    <div class="wrapper">
        <div class="column-row <?php echo esc_attr($architect_contractor_final_layout === 'no-sidebar' ? 'no-sidebar-layout' : ''); ?>">

            <?php if ($architect_contractor_final_layout === 'left-sidebar') : ?>
                <?php get_sidebar(); ?>
            <?php endif; ?>

            <div id="primary" class="content-area <?php echo esc_attr($architect_contractor_final_layout === 'no-sidebar' ? 'full-width-content' : $architect_contractor_sidebar_column_class); ?>">
                <main id="site-content" role="main">

                    <?php
                    architect_contractor_breadcrumb(); // Display breadcrumb

                    if (have_posts()) : ?>

                        <div class="article-wraper">
                            <?php while (have_posts()) : the_post(); ?>

                                <?php get_template_part('template-parts/content', 'single'); ?>

                                <?php if ((is_single() || is_page()) && (comments_open() || get_comments_number()) && !post_password_required()) : ?>
                                    <div class="comments-wrapper">
                                        <?php comments_template(); ?>
                                    </div>
                                <?php endif; ?>

                            <?php endwhile; ?>
                        </div>

                    <?php else : ?>

                        <?php get_template_part('template-parts/content', 'none'); ?>

                    <?php endif;

                    do_action('architect_contractor_navigation_action');
                    ?>

                </main>
            </div>

            <?php if ($architect_contractor_final_layout === 'right-sidebar') : ?>
                <?php get_sidebar(); ?>
            <?php endif; ?>

        </div>
    </div>
</div>

<?php get_footer(); ?>