<?php
$architect_contractor_layout = architect_contractor_get_final_sidebar_layout();
$architect_contractor_sidebar_class = 'column-order-1';

if ( $architect_contractor_layout === 'left-sidebar' ) {
    $architect_contractor_sidebar_class = 'column-order-1';
} elseif ( $architect_contractor_layout === 'right-sidebar' ) {
    $architect_contractor_sidebar_class = 'column-order-2';
}

if ( $architect_contractor_layout !== 'no-sidebar' ) : ?>
    <aside id="secondary" class="widget-area <?php echo esc_attr( $architect_contractor_sidebar_class ); ?>">
        <div class="widget-area-wrapper">
            <?php if ( is_active_sidebar('sidebar-1') ) : ?>
                <?php dynamic_sidebar( 'sidebar-1' ); ?>
            <?php else : ?>
                <!-- Default widgets -->
                <div class="widget widget_block widget_search">
                    <h3 class="widget-title"><?php esc_html_e('Search', 'architect-contractor'); ?></h3>
                    <?php get_search_form(); ?>
                </div>

                <div class="widget widget_pages">
                    <h3 class="widget-title"><?php esc_html_e('Pages', 'architect-contractor'); ?></h3>
                    <ul>
                        <?php
                        wp_list_pages(array(
                            'title_li' => '',
                        ));
                        ?>
                    </ul>
                </div>

                <div class="widget widget_archive">
                    <h3 class="widget-title"><?php esc_html_e('Archives', 'architect-contractor'); ?></h3>
                    <ul>
                        <?php wp_get_archives(['type' => 'monthly', 'show_post_count' => true]); ?>
                    </ul>
                </div>

                <div class="widget widget_categories">
                    <h3 class="widget-title"><?php esc_html_e('Categories', 'architect-contractor'); ?></h3>
                    <ul class="wp-block-categories-list wp-block-categories">
                        <?php wp_list_categories(['orderby' => 'name', 'title_li' => '', 'show_count' => true]); ?>
                    </ul>
                </div>

                <div class="widget widget_tag_cloud">
                    <h3 class="widget-title"><?php esc_html_e('Tags', 'architect-contractor'); ?></h3>
                    <?php
                    $architect_contractor_tags = get_tags();
                    if ( $architect_contractor_tags ) {
                        echo '<div class="tagcloud">';
                        foreach ( $architect_contractor_tags as $architect_contractor_tag ) {
                            $architect_contractor_link = get_tag_link($architect_contractor_tag->term_id);
                            echo '<a href="' . esc_url($architect_contractor_link) . '" class="tag-cloud-link">' . esc_html($architect_contractor_tag->name) . '</a> ';
                        }
                        echo '</div>';
                    } else {
                        echo '<p>' . esc_html__('No tags found.', 'architect-contractor') . '</p>';
                    }
                    ?>
                </div>

            <?php endif; ?>
        </div>
    </aside>
<?php endif; ?>
