<?php
/**
* Widget Functions.
*
* @package Architect Contractor
*/

function architect_contractor_widgets_init(){

	register_sidebar(array(
	    'name' => esc_html__('Main Sidebar', 'architect-contractor'),
	    'id' => 'sidebar-1',
	    'description' => esc_html__('Add widgets here.', 'architect-contractor'),
	    'before_widget' => '<div id="%1$s" class="widget %2$s">',
	    'after_widget' => '</div>',
	    'before_title' => '<h3 class="widget-title"><span>',
	    'after_title' => '</span></h3>',
	));


    $architect_contractor_default = architect_contractor_get_default_theme_options();
    $architect_contractor_footer_column_layout = absint( get_theme_mod( 'architect_contractor_footer_column_layout',$architect_contractor_default['architect_contractor_footer_column_layout'] ) );

    for( $architect_contractor_i = 0; $architect_contractor_i < $architect_contractor_footer_column_layout; $architect_contractor_i++ ){
    	
    	if( $architect_contractor_i == 0 ){ $architect_contractor_count = esc_html__('One','architect-contractor'); }
    	if( $architect_contractor_i == 1 ){ $architect_contractor_count = esc_html__('Two','architect-contractor'); }
    	if( $architect_contractor_i == 2 ){ $architect_contractor_count = esc_html__('Three','architect-contractor'); }

	    register_sidebar( array(
	        'name' => esc_html__('Footer Widget ', 'architect-contractor').$architect_contractor_count,
	        'id' => 'architect-contractor-footer-widget-'.$architect_contractor_i,
	        'description' => esc_html__('Add widgets here.', 'architect-contractor'),
	        'before_widget' => '<div id="%1$s" class="widget %2$s">',
	        'after_widget' => '</div>',
	        'before_title' => '<h2 class="widget-title">',
	        'after_title' => '</h2>',
	    ));
	}

}

add_action('widgets_init', 'architect_contractor_widgets_init');