<?php
/**
 *
 * Pagination Functions
 *
 * @package Architect  Contractor
 */

/**
 * Pagination for archive.
 */
function architect_contractor_render_posts_pagination() {
    // Get the setting to check if pagination is enabled
    $architect_contractor_is_pagination_enabled = get_theme_mod( 'architect_contractor_enable_pagination', true );

    // Check if pagination is enabled
    if ( $architect_contractor_is_pagination_enabled ) {
        // Get the selected pagination type from the Customizer
        $architect_contractor_pagination_type = get_theme_mod( 'architect_contractor_theme_pagination_type', 'numeric' );

        // Check if the pagination type is "newer_older" (Previous/Next) or "numeric"
        if ( 'newer_older' === $architect_contractor_pagination_type ) :
            // Display "Newer/Older" pagination (Previous/Next navigation)
            the_posts_navigation(
                array(
                    'prev_text' => __( '&laquo; Newer', 'architect-contractor' ),  // Change the label for "previous"
                    'next_text' => __( 'Older &raquo;', 'architect-contractor' ),  // Change the label for "next"
                    'screen_reader_text' => __( 'Posts navigation', 'architect-contractor' ),
                )
            );
        else :
            // Display numeric pagination (Page numbers)
            the_posts_pagination(
                array(
                    'prev_text' => __( '&laquo; Previous', 'architect-contractor' ),
                    'next_text' => __( 'Next &raquo;', 'architect-contractor' ),
                    'type'      => 'list', // Display as <ul> <li> tags
                    'screen_reader_text' => __( 'Posts navigation', 'architect-contractor' ),
                )
            );
        endif;
    }
}
add_action( 'architect_contractor_posts_pagination', 'architect_contractor_render_posts_pagination', 10 );