<?php

function architect_contractor_enqueue_fonts() {
    $architect_contractor_default_font_content = 'Lato';
    $architect_contractor_default_font_heading = 'Kanit';

    $architect_contractor_font_content = esc_attr(get_theme_mod('architect_contractor_content_typography_font', $architect_contractor_default_font_content));
    $architect_contractor_font_heading = esc_attr(get_theme_mod('architect_contractor_heading_typography_font', $architect_contractor_default_font_heading));

    $architect_contractor_css = '';

    // Always enqueue main font
    $architect_contractor_css .= '
    :root {
        --font-main: ' . $architect_contractor_font_content . ', ' . (in_array($architect_contractor_font_content, ['bitter', 'charis-sil']) ? 'serif' : 'sans-serif') . '!important;
    }';
    wp_enqueue_style('architect-contractor-style-font-general', get_template_directory_uri() . '/fonts/' . $architect_contractor_font_content . '/font.css');

    // Always enqueue header font
    $architect_contractor_css .= '
    :root {
        --font-head: ' . $architect_contractor_font_heading . ', ' . (in_array($architect_contractor_font_heading, ['bitter', 'charis-sil']) ? 'serif' : 'sans-serif') . '!important;
    }';
    wp_enqueue_style('architect-contractor-style-font-h', get_template_directory_uri() . '/fonts/' . $architect_contractor_font_heading . '/font.css');

    // Add inline style
    wp_add_inline_style('architect-contractor-style-font-general', $architect_contractor_css);
}
add_action('wp_enqueue_scripts', 'architect_contractor_enqueue_fonts', 50);