<?php
/**
* Typography Settings.
*
* @package Architect Contractor
*/

$architect_contractor_default = architect_contractor_get_default_theme_options();

// Layout Section.
$wp_customize->add_section( 'architect_contractor_typography_setting',
	array(
	'title'      => esc_html__( 'Typography Settings', 'architect-contractor' ),
	'priority'   => 21,
	'capability' => 'edit_theme_options',
	'panel'      => 'architect_contractor_theme_option_panel',
	)
);

// -----------------  Font array
$architect_contractor_fonts = array(
    'Select'           => __('Default Font', 'architect-contractor'),
    'bad-script' => 'Bad Script',
    'bitter'     => 'Bitter',
    'cuprum'     => 'Cuprum',
    'exo-2'      => 'Exo 2',
    'jost'       => 'Jost',
    'open-sans'  => 'Open Sans',
    'oswald'     => 'Oswald',
    'play'       => 'Play',
    'roboto'     => 'Roboto',
    'outfit'     => 'Outfit',
    'ubuntu'     => 'Ubuntu',
    'Kanit'     => 'Kanit',
    'Lato'     => 'Lato',
);

 // -----------------  General text font
 $wp_customize->add_setting( 'architect_contractor_content_typography_font', array(
    'default'           => 'Lato',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'architect_contractor_radio_sanitize',
) );
$wp_customize->add_control( 'architect_contractor_content_typography_font', array(
    'type'     => 'select',
    'label'    => esc_html__( 'General Content Font', 'architect-contractor' ),
    'section'  => 'architect_contractor_typography_setting',
    'settings' => 'architect_contractor_content_typography_font',
    'choices'  => $architect_contractor_fonts,
) );

 // -----------------  General Heading Font
$wp_customize->add_setting( 'architect_contractor_heading_typography_font', array(
    'default'           => 'Kanit',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'architect_contractor_radio_sanitize',
) );
$wp_customize->add_control( 'architect_contractor_heading_typography_font', array(
    'type'     => 'select',
    'label'    => esc_html__( 'General Heading Font', 'architect-contractor' ),
    'section'  => 'architect_contractor_typography_setting',
    'settings' => 'architect_contractor_heading_typography_font',
    'choices'  => $architect_contractor_fonts,
) );