<?php
/**
* Social Options.
*
* @package Architect Contractor
*/

$architect_contractor_default = architect_contractor_get_default_theme_options();

// Social Section.
$wp_customize->add_section( 'architect_contractor_social_icon_setting',
	array(
	'title'      => esc_html__( 'Social Settings', 'architect-contractor' ),
	'priority'   => 10,
	'capability' => 'edit_theme_options',
	'panel'      => 'architect_contractor_theme_option_panel',
	)
);

$wp_customize->add_setting( 'architect_contractor_header_banner_social_facebook_link',
    array(
    'default'           => $architect_contractor_default['architect_contractor_header_banner_social_facebook_link'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'esc_url_raw',
    )
);
$wp_customize->add_control( 'architect_contractor_header_banner_social_facebook_link',
    array(
    'label'    => esc_html__( 'Facebook Link', 'architect-contractor' ),
    'section'  => 'architect_contractor_social_icon_setting',
    'type'     => 'url',
    )
);

$wp_customize->add_setting( 'architect_contractor_header_banner_social_twitter_link',
    array(
    'default'           => $architect_contractor_default['architect_contractor_header_banner_social_twitter_link'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'esc_url_raw',
    )
);
$wp_customize->add_control( 'architect_contractor_header_banner_social_twitter_link',
    array(
    'label'    => esc_html__( 'Twitter Link', 'architect-contractor' ),
    'section'  => 'architect_contractor_social_icon_setting',
    'type'     => 'url',
    )
);

$wp_customize->add_setting( 'architect_contractor_header_banner_social_instagram_link',
    array(
    'default'           => $architect_contractor_default['architect_contractor_header_banner_social_instagram_link'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'esc_url_raw',
    )
);
$wp_customize->add_control( 'architect_contractor_header_banner_social_instagram_link',
    array(
    'label'    => esc_html__( 'Instagram Link', 'architect-contractor' ),
    'section'  => 'architect_contractor_social_icon_setting',
    'type'     => 'url',
    )
);

$wp_customize->add_setting( 'architect_contractor_header_banner_social_linkdin_link',
    array(
    'default'           => $architect_contractor_default['architect_contractor_header_banner_social_linkdin_link'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'esc_url_raw',
    )
);
$wp_customize->add_control( 'architect_contractor_header_banner_social_linkdin_link',
    array(
    'label'    => esc_html__( 'Linkedin Link', 'architect-contractor' ),
    'section'  => 'architect_contractor_social_icon_setting',
    'type'     => 'url',
    )
);

$wp_customize->add_setting( 'architect_contractor_header_banner_social_watsapp_link',
    array(
    'default'           => $architect_contractor_default['architect_contractor_header_banner_social_watsapp_link'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'esc_url_raw',
    )
);
$wp_customize->add_control( 'architect_contractor_header_banner_social_watsapp_link',
    array(
    'label'    => esc_html__( 'Watsapp Link', 'architect-contractor' ),
    'section'  => 'architect_contractor_social_icon_setting',
    'type'     => 'url',
    )
);