<?php
/**
* Custom Functions.
*
* @package Architect Contractor
*/

if( !function_exists( 'architect_contractor_sanitize_sidebar_option' ) ) :

    // Sidebar Option Sanitize.
    function architect_contractor_sanitize_sidebar_option( $architect_contractor_input ){

        $architect_contractor_metabox_options = array( 'global-sidebar','left-sidebar','right-sidebar','no-sidebar' );
        if( in_array( $architect_contractor_input,$architect_contractor_metabox_options ) ){

            return $architect_contractor_input;

        }

        return;

    }

endif;

if ( ! function_exists( 'architect_contractor_sanitize_checkbox' ) ) :

	/**
	 * Sanitize checkbox.
	 */
	function architect_contractor_sanitize_checkbox( $architect_contractor_checked ) {

		return ( ( isset( $architect_contractor_checked ) && true === $architect_contractor_checked ) ? true : false );

	}

endif;


if ( ! function_exists( 'architect_contractor_sanitize_select' ) ) :

    /**
     * Sanitize select.
     */
    function architect_contractor_sanitize_select( $architect_contractor_input, $architect_contractor_setting ) {
        $architect_contractor_input = sanitize_text_field( $architect_contractor_input );
        $choices = $architect_contractor_setting->manager->get_control( $architect_contractor_setting->id )->choices;
        return ( array_key_exists( $architect_contractor_input, $choices ) ? $architect_contractor_input : $architect_contractor_setting->default );
    }

endif;