<?php
/**
* Posts Settings.
*
* @package Architect Contractor
*/

$architect_contractor_default = architect_contractor_get_default_theme_options();

// Single Post Section.
$wp_customize->add_section( 'architect_contractor_single_posts_settings',
    array(
    'title'      => esc_html__( 'Single Meta Information Settings', 'architect-contractor' ),
    'priority'   => 35,
    'capability' => 'edit_theme_options',
    'panel'      => 'architect_contractor_theme_option_panel',
    )
);

$wp_customize->add_setting('architect_contractor_display_single_post_image',
    array(
        'default' => $architect_contractor_default['architect_contractor_display_single_post_image'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'architect_contractor_sanitize_checkbox',
    )
);
$wp_customize->add_control('architect_contractor_display_single_post_image',
    array(
        'label' => esc_html__('Enable Single Posts Image', 'architect-contractor'),
        'section' => 'architect_contractor_single_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('architect_contractor_post_author',
    array(
        'default' => $architect_contractor_default['architect_contractor_post_author'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'architect_contractor_sanitize_checkbox',
    )
);
$wp_customize->add_control('architect_contractor_post_author',
    array(
        'label' => esc_html__('Enable Posts Author', 'architect-contractor'),
        'section' => 'architect_contractor_single_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('architect_contractor_post_date',
    array(
        'default' => $architect_contractor_default['architect_contractor_post_date'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'architect_contractor_sanitize_checkbox',
    )
);
$wp_customize->add_control('architect_contractor_post_date',
    array(
        'label' => esc_html__('Enable Posts Date', 'architect-contractor'),
        'section' => 'architect_contractor_single_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('architect_contractor_post_category',
    array(
        'default' => $architect_contractor_default['architect_contractor_post_category'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'architect_contractor_sanitize_checkbox',
    )
);
$wp_customize->add_control('architect_contractor_post_category',
    array(
        'label' => esc_html__('Enable Posts Category', 'architect-contractor'),
        'section' => 'architect_contractor_single_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('architect_contractor_post_tags',
    array(
        'default' => $architect_contractor_default['architect_contractor_post_tags'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'architect_contractor_sanitize_checkbox',
    )
);
$wp_customize->add_control('architect_contractor_post_tags',
    array(
        'label' => esc_html__('Enable Posts Tags', 'architect-contractor'),
        'section' => 'architect_contractor_single_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting( 'architect_contractor_single_page_content_alignment',
    array(
    'default'           => $architect_contractor_default['architect_contractor_single_page_content_alignment'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'architect_contractor_sanitize_page_content_alignment',
    )
);
$wp_customize->add_control( 'architect_contractor_single_page_content_alignment',
    array(
    'label'       => esc_html__( 'Single Page Content Alignment', 'architect-contractor' ),
    'section'     => 'architect_contractor_single_posts_settings',
    'type'        => 'select',
    'choices'     => array(
        'left' => esc_html__( 'Left', 'architect-contractor' ),
        'center'  => esc_html__( 'Center', 'architect-contractor' ),
        'right'    => esc_html__( 'Right', 'architect-contractor' ),
        ),
    )
);

$wp_customize->add_setting( 'architect_contractor_single_post_content_alignment',
    array(
    'default'           => $architect_contractor_default['architect_contractor_single_post_content_alignment'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'architect_contractor_sanitize_page_content_alignment',
    )
);
$wp_customize->add_control( 'architect_contractor_single_post_content_alignment',
    array(
    'label'       => esc_html__( 'Single Post Content Alignment', 'architect-contractor' ),
    'section'     => 'architect_contractor_single_posts_settings',
    'type'        => 'select',
    'choices'     => array(
        'left' => esc_html__( 'Left', 'architect-contractor' ),
        'center'  => esc_html__( 'Center', 'architect-contractor' ),
        'right'    => esc_html__( 'Right', 'architect-contractor' ),
        ),
    )
);

// Archive Post Section.
$wp_customize->add_section( 'architect_contractor_posts_settings',
    array(
    'title'      => esc_html__( 'Archive Meta Information Settings', 'architect-contractor' ),
    'priority'   => 36,
    'capability' => 'edit_theme_options',
    'panel'      => 'architect_contractor_theme_option_panel',
    )
);

$wp_customize->add_setting('architect_contractor_display_archive_post_format_icon',
    array(
        'default' => $architect_contractor_default['architect_contractor_display_archive_post_format_icon'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'architect_contractor_sanitize_checkbox',
    )
);
$wp_customize->add_control('architect_contractor_display_archive_post_format_icon',
    array(
        'label' => esc_html__('Enable Posts Format Icon', 'architect-contractor'),
        'section' => 'architect_contractor_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('architect_contractor_display_archive_post_image',
    array(
        'default' => $architect_contractor_default['architect_contractor_display_archive_post_image'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'architect_contractor_sanitize_checkbox',
    )
);
$wp_customize->add_control('architect_contractor_display_archive_post_image',
    array(
        'label' => esc_html__('Enable Posts Image', 'architect-contractor'),
        'section' => 'architect_contractor_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('architect_contractor_display_archive_post_category',
    array(
        'default' => $architect_contractor_default['architect_contractor_display_archive_post_category'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'architect_contractor_sanitize_checkbox',
    )
);
$wp_customize->add_control('architect_contractor_display_archive_post_category',
    array(
        'label' => esc_html__('Enable Posts Category', 'architect-contractor'),
        'section' => 'architect_contractor_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('architect_contractor_display_archive_post_title',
    array(
        'default' => $architect_contractor_default['architect_contractor_display_archive_post_title'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'architect_contractor_sanitize_checkbox',
    )
);
$wp_customize->add_control('architect_contractor_display_archive_post_title',
    array(
        'label' => esc_html__('Enable Posts Title', 'architect-contractor'),
        'section' => 'architect_contractor_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('architect_contractor_display_archive_post_content',
    array(
        'default' => $architect_contractor_default['architect_contractor_display_archive_post_content'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'architect_contractor_sanitize_checkbox',
    )
);
$wp_customize->add_control('architect_contractor_display_archive_post_content',
    array(
        'label' => esc_html__('Enable Posts Content', 'architect-contractor'),
        'section' => 'architect_contractor_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('architect_contractor_display_archive_post_button',
    array(
        'default' => $architect_contractor_default['architect_contractor_display_archive_post_button'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'architect_contractor_sanitize_checkbox',
    )
);
$wp_customize->add_control('architect_contractor_display_archive_post_button',
    array(
        'label' => esc_html__('Enable Posts Button', 'architect-contractor'),
        'section' => 'architect_contractor_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('architect_contractor_excerpt_limit',
    array(
        'default'           => $architect_contractor_default['architect_contractor_excerpt_limit'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'architect_contractor_sanitize_number_range',
    )
);
$wp_customize->add_control('architect_contractor_excerpt_limit',
    array(
        'label'       => esc_html__('Blog Posts Excerpt limit', 'architect-contractor'),
        'section'     => 'architect_contractor_posts_settings',
        'type'        => 'number',
        'input_attrs' => array(
           'min'   => 1,
           'max'   => 100,
           'step'   => 1,
        ),
    )
);

$wp_customize->add_setting( 'architect_contractor_archive_image_size',
	array(
	'default'           => 'medium',
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'architect_contractor_sanitize_select',
	)
);
$wp_customize->add_control( 'architect_contractor_archive_image_size',
	array(
	'label'       => esc_html__( 'Blog Posts Image Size', 'architect-contractor' ),
	'section'     => 'architect_contractor_posts_settings',
	'type'        => 'select',
	'choices'               => array(
		'full' => esc_html__( 'Large Size Image', 'architect-contractor' ),
		'large' => esc_html__( 'Big Size Image', 'architect-contractor' ),
		'medium' => esc_html__( 'Medium Size Image', 'architect-contractor' ),
		'small' => esc_html__( 'Small Size Image', 'architect-contractor' ),
		'xsmall' => esc_html__( 'Extra Small Size Image', 'architect-contractor' ),
		'thumbnail' => esc_html__( 'Thumbnail Size Image', 'architect-contractor' ),
	    ),
	)
);

$wp_customize->add_setting('architect_contractor_posts_per_columns',
    array(
    'default'           => '3',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'architect_contractor_sanitize_number_range',
    )
);
$wp_customize->add_control('architect_contractor_posts_per_columns',
    array(
    'label'       => esc_html__('Blog Posts Per Column', 'architect-contractor'),
    'section'     => 'architect_contractor_posts_settings',
    'type'        => 'number',
    'input_attrs' => array(
    'min'   => 1,
    'max'   => 5,
    'step'   => 1,
    ),
    )
);