<?php
/**
* Layouts Settings.
*
* @package Architect Contractor
*/

$architect_contractor_default = architect_contractor_get_default_theme_options();

// Layout Section.
$wp_customize->add_section( 'architect_contractor_layout_setting',
	array(
	'title'      => esc_html__( 'Sidebar Settings', 'architect-contractor' ),
	'priority'   => 20,
	'capability' => 'edit_theme_options',
	'panel'      => 'architect_contractor_theme_option_panel',
	)
);

$wp_customize->add_setting( 'architect_contractor_global_sidebar_layout',
    array(
    'default'           => $architect_contractor_default['architect_contractor_global_sidebar_layout'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'architect_contractor_sanitize_sidebar_option',
    )
);
$wp_customize->add_control( 'architect_contractor_global_sidebar_layout',
    array(
    'label'       => esc_html__( 'Global Sidebar Layout', 'architect-contractor' ),
    'section'     => 'architect_contractor_layout_setting',
    'type'        => 'select',
    'choices'     => array(
        'right-sidebar' => esc_html__( 'Right Sidebar', 'architect-contractor' ),
        'left-sidebar'  => esc_html__( 'Left Sidebar', 'architect-contractor' ),
        'no-sidebar'    => esc_html__( 'No Sidebar', 'architect-contractor' ),
        ),
    )
);

$wp_customize->add_setting('architect_contractor_page_sidebar_layout', array(
    'default'           => $architect_contractor_default['architect_contractor_global_sidebar_layout'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'architect_contractor_sanitize_sidebar_option',
));

$wp_customize->add_control('architect_contractor_page_sidebar_layout', array(
    'label'       => esc_html__('Single Page Sidebar Layout', 'architect-contractor'),
    'section'     => 'architect_contractor_layout_setting',
    'type'        => 'select',
    'choices'     => array(
        'right-sidebar' => esc_html__('Right Sidebar', 'architect-contractor'),
        'left-sidebar'  => esc_html__('Left Sidebar', 'architect-contractor'),
        'no-sidebar'    => esc_html__('No Sidebar', 'architect-contractor'),
    ),
));

$wp_customize->add_setting('architect_contractor_post_sidebar_layout', array(
    'default'           => $architect_contractor_default['architect_contractor_global_sidebar_layout'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'architect_contractor_sanitize_sidebar_option',
));

$wp_customize->add_control('architect_contractor_post_sidebar_layout', array(
    'label'       => esc_html__('Single Post Sidebar Layout', 'architect-contractor'),
    'section'     => 'architect_contractor_layout_setting',
    'type'        => 'select',
    'choices'     => array(
        'right-sidebar' => esc_html__('Right Sidebar', 'architect-contractor'),
        'left-sidebar'  => esc_html__('Left Sidebar', 'architect-contractor'),
        'no-sidebar'    => esc_html__('No Sidebar', 'architect-contractor'),
    ),
));

$wp_customize->add_setting('architect_contractor_sticky_sidebar',
    array(
        'default'           => true,
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'architect_contractor_sanitize_checkbox',
    )
);
$wp_customize->add_control('architect_contractor_sticky_sidebar',
    array(
        'label' => esc_html__('Enable/Disable Sticky Sidebar', 'architect-contractor'),
        'section' => 'architect_contractor_layout_setting',
        'type' => 'checkbox',
    )
);