<?php
/**
* Header Banner Options.
*
* @package Architect Contractor
*/

$architect_contractor_default = architect_contractor_get_default_theme_options();
$architect_contractor_post_category_list = architect_contractor_post_category_list();

// Slider Section

$wp_customize->add_section( 'architect_contractor_header_banner_setting',
    array(
    'title'      => esc_html__( 'Slider Settings', 'architect-contractor' ),
    'priority'   => 10,
    'capability' => 'edit_theme_options',
    'panel'      => 'architect_contractor_theme_home_pannel',
    )
);

$wp_customize->add_setting('architect_contractor_display_header_title',
    array(
        'default' => $architect_contractor_default['architect_contractor_display_header_title'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'architect_contractor_sanitize_checkbox',
    )
);
$wp_customize->add_control('architect_contractor_display_header_title',
    array(
        'label' => esc_html__('Enable / Disable Title', 'architect-contractor'),
        'section' => 'title_tagline',
        'type' => 'checkbox',
    )
);

// Show/Hide Site Logo
$wp_customize->add_setting('architect_contractor_display_logo', array(
    'default'           => false,
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'architect_contractor_sanitize_checkbox',
));
$wp_customize->add_control('architect_contractor_display_logo', array(
    'label'    => esc_html__('Enable / Disable Site Logo', 'architect-contractor'),
    'section'  => 'title_tagline',
    'type'     => 'checkbox',
));

// Show/Hide Site Title
$wp_customize->add_setting('architect_contractor_display_title', array(
    'default'           => true,
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'architect_contractor_sanitize_checkbox',
));
$wp_customize->add_control('architect_contractor_display_title', array(
    'label'    => esc_html__('Enable / Disable Site Title', 'architect-contractor'),
    'section'  => 'title_tagline',
    'type'     => 'checkbox',
));

// Show/Hide Site Tagline
$wp_customize->add_setting('architect_contractor_display_header_text',
    array(
        'default'           => false,
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'architect_contractor_sanitize_checkbox',
    )
);
$wp_customize->add_control('architect_contractor_display_header_text',
    array(
        'label' => esc_html__('Enable / Disable Site Tagline', 'architect-contractor'),
        'section' => 'title_tagline',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('architect_contractor_header_banner',
    array(
        'default' => $architect_contractor_default['architect_contractor_header_banner'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'architect_contractor_sanitize_checkbox',
    )
);
$wp_customize->add_control('architect_contractor_header_banner',
    array(
        'label' => esc_html__('Enable Slider', 'architect-contractor'),
        'section' => 'architect_contractor_header_banner_setting',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting( 'architect_contractor_header_banner_cat',
    array(
    'default'           => 'Slider',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'architect_contractor_sanitize_select',
    )
);
$wp_customize->add_control( 'architect_contractor_header_banner_cat',
    array(
    'label'       => esc_html__( 'Slider Post Category', 'architect-contractor' ),
    'section'     => 'architect_contractor_header_banner_setting',
    'type'        => 'select',
    'choices'     => $architect_contractor_post_category_list,
    )
);

// Counter Section

$wp_customize->add_section( 'architect_contractor_header_counter_setting',
    array(
    'title'      => esc_html__( 'Our Counter Settings', 'architect-contractor' ),
    'priority'   => 10,
    'capability' => 'edit_theme_options',
    'panel'      => 'architect_contractor_theme_home_pannel',
    )
);

$wp_customize->add_setting('architect_contractor_architect_contractor_counter',
    array(
        'default' => $architect_contractor_default['architect_contractor_architect_contractor_counter'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'architect_contractor_sanitize_checkbox',
    )
);
$wp_customize->add_control('architect_contractor_architect_contractor_counter',
    array(
        'label' => esc_html__('Enable Counter Section', 'architect-contractor'),
        'section' => 'architect_contractor_header_counter_setting',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting( 'architect_contractor_architect_contractor_counter_cat',
    array(
    'default'           => '',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'architect_contractor_sanitize_select',
    )
);
$wp_customize->add_control( 'architect_contractor_architect_contractor_counter_cat',
    array(
    'label'       => esc_html__( 'Counter Post Category', 'architect-contractor' ),
    'section'     => 'architect_contractor_header_counter_setting',
    'type'        => 'select',
    'choices'     => $architect_contractor_post_category_list,
    )
);

// Services Section

$wp_customize->add_section( 'architect_contractor_header_category_setting',
    array(
    'title'      => esc_html__( 'Our Services Settings', 'architect-contractor' ),
    'priority'   => 10,
    'capability' => 'edit_theme_options',
    'panel'      => 'architect_contractor_theme_home_pannel',
    )
);

$wp_customize->add_setting('architect_contractor_services',
    array(
        'default' => $architect_contractor_default['architect_contractor_services'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'architect_contractor_sanitize_checkbox',
    )
);
$wp_customize->add_control('architect_contractor_services',
    array(
        'label' => esc_html__('Enable Category Section', 'architect-contractor'),
        'section' => 'architect_contractor_header_category_setting',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting( 'architect_contractor_services_section_title',
    array(
    'default'           => $architect_contractor_default['architect_contractor_services_section_title'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'architect_contractor_services_section_title',
    array(
    'label'    => esc_html__( 'Main Title', 'architect-contractor' ),
    'section'  => 'architect_contractor_header_category_setting',
    'type'     => 'text',
    )
);

$wp_customize->add_setting( 'architect_contractor_services_section_short_title',
    array(
    'default'           => $architect_contractor_default['architect_contractor_services_section_short_title'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'architect_contractor_services_section_short_title',
    array(
    'label'    => esc_html__( 'Short Title', 'architect-contractor' ),
    'section'  => 'architect_contractor_header_category_setting',
    'type'     => 'text',
    )
);

$wp_customize->add_setting( 'architect_contractor_services_cat',
    array(
    'default'           => '',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'architect_contractor_sanitize_select',
    )
);
$wp_customize->add_control( 'architect_contractor_services_cat',
    array(
    'label'       => esc_html__( 'Services Post Category', 'architect-contractor' ),
    'section'     => 'architect_contractor_header_category_setting',
    'type'        => 'select',
    'choices'     => $architect_contractor_post_category_list,
    )
);