<?php
/**
* Header Options.
*
* @package Architect Contractor
*/

$architect_contractor_default = architect_contractor_get_default_theme_options();

// Header Section.
$wp_customize->add_section( 'architect_contractor_button_header_setting',
	array(
	'title'      => esc_html__( 'Header Settings', 'architect-contractor' ),
	'priority'   => 10,
	'capability' => 'edit_theme_options',
	'panel'      => 'architect_contractor_theme_option_panel',
	)
);

$wp_customize->add_setting( 'architect_contractor_header_layout_location_address',
    array(
    'default'           => $architect_contractor_default['architect_contractor_header_layout_location_address'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'architect_contractor_header_layout_location_address',
    array(
    'label'    => esc_html__( 'Header Location', 'architect-contractor' ),
    'section'  => 'architect_contractor_button_header_setting',
    'type'     => 'text',
    )
);

$wp_customize->add_setting( 'architect_contractor_header_layout_email_address',
    array(
    'default'           => $architect_contractor_default['architect_contractor_header_layout_email_address'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'architect_contractor_header_layout_email_address',
    array(
    'label'    => esc_html__( 'Header Email Address', 'architect-contractor' ),
    'section'  => 'architect_contractor_button_header_setting',
    'type'     => 'text',
    )
);

$wp_customize->add_setting( 'architect_contractor_header_layout_working_hour',
    array(
    'default'           => $architect_contractor_default['architect_contractor_header_layout_working_hour'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'architect_contractor_header_layout_working_hour',
    array(
    'label'    => esc_html__( 'Header Working Hr Text', 'architect-contractor' ),
    'section'  => 'architect_contractor_button_header_setting',
    'type'     => 'text',
    )
);

$wp_customize->add_setting( 'architect_contractor_header_layout_phone_number',
    array(
    'default'           => $architect_contractor_default['architect_contractor_header_layout_phone_number'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'architect_contractor_header_layout_phone_number',
    array(
    'label'    => esc_html__( 'Header Phone Number', 'architect-contractor' ),
    'section'  => 'architect_contractor_button_header_setting',
    'type'     => 'text',
    )
);

$wp_customize->add_setting('architect_contractor_menu_font_size',
    array(
        'default'           => $architect_contractor_default['architect_contractor_menu_font_size'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'architect_contractor_sanitize_number_range',
    )
);
$wp_customize->add_control('architect_contractor_menu_font_size',
    array(
        'label'       => esc_html__('Menu Font Size', 'architect-contractor'),
        'section'     => 'architect_contractor_button_header_setting',
        'type'        => 'number',
        'input_attrs' => array(
           'min'   => 1,
           'max'   => 30,
           'step'   => 1,
        ),
    )
);

$wp_customize->add_setting( 'architect_contractor_menu_text_transform',
    array(
    'default'           => $architect_contractor_default['architect_contractor_menu_text_transform'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'architect_contractor_sanitize_menu_transform',
    )
);
$wp_customize->add_control( 'architect_contractor_menu_text_transform',
    array(
    'label'       => esc_html__( 'Menu Text Transform', 'architect-contractor' ),
    'section'     => 'architect_contractor_button_header_setting',
    'type'        => 'select',
    'choices'     => array(
        'capitalize' => esc_html__( 'Capitalize', 'architect-contractor' ),
        'uppercase'  => esc_html__( 'Uppercase', 'architect-contractor' ),
        'lowercase'    => esc_html__( 'Lowercase', 'architect-contractor' ),
        ),
    )
);

$wp_customize->add_setting('architect_contractor_header_menus_color', array(
    'default'           => '',
    'sanitize_callback' => 'sanitize_hex_color',
));
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'architect_contractor_header_menus_color', array(
    'label'    => __('Main Menu Color', 'architect-contractor'),
    'section'  => 'architect_contractor_button_header_setting',
)));

$wp_customize->add_setting('architect_contractor_header_menus_hover_color', array(
    'default'           => '',
    'sanitize_callback' => 'sanitize_hex_color',
));
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'architect_contractor_header_menus_hover_color', array(
    'label'    => __('Main Menu Hover Color', 'architect-contractor'),
    'section'  => 'architect_contractor_button_header_setting',
)));

$wp_customize->add_setting('architect_contractor_header_submenus_color', array(
    'default'           => '',
    'sanitize_callback' => 'sanitize_hex_color',
));
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'architect_contractor_header_submenus_color', array(
    'label'    => __('Submenu Color', 'architect-contractor'),
    'section'  => 'architect_contractor_button_header_setting',
)));

$wp_customize->add_setting('architect_contractor_header_submenus_hover_color', array(
    'default'           => '',
    'sanitize_callback' => 'sanitize_hex_color',
));
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'architect_contractor_header_submenus_hover_color', array(
    'label'    => __('Submenu Hover Color', 'architect-contractor'),
    'section'  => 'architect_contractor_button_header_setting',
)));