<?php
/**
* Global Color Settings.
*
* @package Architect Contractor
*/

$architect_contractor_default = architect_contractor_get_default_theme_options();

// Layout Section.
$wp_customize->add_section( 'architect_contractor_global_color_setting',
	array(
	'title'      => esc_html__( 'Global Color Settings', 'architect-contractor' ),
	'priority'   => 21,
	'capability' => 'edit_theme_options',
	'panel'      => 'architect_contractor_theme_option_panel',
	)
);

$wp_customize->add_setting( 'architect_contractor_global_color',
    array(
    'default'           => '#FF4A11',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_hex_color',
    )
);
$wp_customize->add_control( 
    new WP_Customize_Color_Control( 
    $wp_customize, 
    'architect_contractor_global_color',
    array(
        'label'      => esc_html__( 'Global Color', 'architect-contractor' ),
        'section'    => 'architect_contractor_global_color_setting',
        'settings'   => 'architect_contractor_global_color',
    ) ) 
);