<?php
/**
* Footer Settings.
*
* @package Architect Contractor
*/

$architect_contractor_default = architect_contractor_get_default_theme_options();

$wp_customize->add_section( 'architect_contractor_footer_widget_area',
	array(
	'title'      => esc_html__( 'Footer Settings', 'architect-contractor' ),
	'priority'   => 200,
	'capability' => 'edit_theme_options',
	'panel'      => 'architect_contractor_theme_option_panel',
	)
);

$wp_customize->add_setting('architect_contractor_display_footer',
    array(
        'default' => $architect_contractor_default['architect_contractor_display_footer'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'architect_contractor_sanitize_checkbox',
    )
    );
    $wp_customize->add_control('architect_contractor_display_footer',
        array(
            'label' => esc_html__('Enable Footer', 'architect-contractor'),
            'section' => 'architect_contractor_footer_widget_area',
            'type' => 'checkbox',
        )
    );

$wp_customize->add_setting( 'architect_contractor_footer_column_layout',
	array(
	'default'           => $architect_contractor_default['architect_contractor_footer_column_layout'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'architect_contractor_sanitize_select',
	)
);
$wp_customize->add_control( 'architect_contractor_footer_column_layout',
	array(
	'label'       => esc_html__( 'Footer Column Layout', 'architect-contractor' ),
	'section'     => 'architect_contractor_footer_widget_area',
	'type'        => 'select',
	'choices'               => array(
		'1' => esc_html__( 'One Column', 'architect-contractor' ),
		'2' => esc_html__( 'Two Column', 'architect-contractor' ),
		'3' => esc_html__( 'Three Column', 'architect-contractor' ),
	    ),
	)
);

$wp_customize->add_setting( 'architect_contractor_footer_widget_title_alignment',
        array(
        'default'           => $architect_contractor_default['architect_contractor_footer_widget_title_alignment'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'architect_contractor_sanitize_footer_widget_title_alignment',
        )
    );
    $wp_customize->add_control( 'architect_contractor_footer_widget_title_alignment',
        array(
        'label'       => esc_html__( 'Footer Widget Title Alignment', 'architect-contractor' ),
        'section'     => 'architect_contractor_footer_widget_area',
        'type'        => 'select',
        'choices'     => array(
            'left' => esc_html__( 'Left', 'architect-contractor' ),
            'center'  => esc_html__( 'Center', 'architect-contractor' ),
            'right'    => esc_html__( 'Right', 'architect-contractor' ),
            ),
        )
    );

$wp_customize->add_setting( 'architect_contractor_footer_copyright_text',
	array(
	'default'           => $architect_contractor_default['architect_contractor_footer_copyright_text'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control( 'architect_contractor_footer_copyright_text',
	array(
	'label'    => esc_html__( 'Footer Copyright Text', 'architect-contractor' ),
	'section'  => 'architect_contractor_footer_widget_area',
	'type'     => 'text',
	)
);

$wp_customize->add_setting('architect_contractor_copyright_font_size',
    array(
        'default'           => $architect_contractor_default['architect_contractor_copyright_font_size'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'architect_contractor_sanitize_number_range',
    )
);
$wp_customize->add_control('architect_contractor_copyright_font_size',
    array(
        'label'       => esc_html__('Copyright Font Size', 'architect-contractor'),
        'section'     => 'architect_contractor_footer_widget_area',
        'type'        => 'number',
        'input_attrs' => array(
           'min'   => 5,
           'max'   => 30,
           'step'   => 1,
    	),
    )
);

$wp_customize->add_setting( 'architect_contractor_copyright_alignment', array(
    'default'           => 'Default',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'architect_contractor_sanitize_copyright_alignment_meta',
) );

$wp_customize->add_control( 'architect_contractor_copyright_alignment', array(
    'label'    => esc_html__( 'Copyright Section Alignment', 'architect-contractor' ),
    'section'  => 'architect_contractor_footer_widget_area',
    'type'     => 'select',
    'choices'  => array(
        'Default' => esc_html__( 'Default View', 'architect-contractor' ),
        'Reverse' => esc_html__( 'Reverse View', 'architect-contractor' ),
        'Center'  => esc_html__( 'Centered Content', 'architect-contractor' ),
    ),
) );

$wp_customize->add_setting( 'architect_contractor_footer_widget_background_color', array(
    'default' => '',
    'sanitize_callback' => 'sanitize_hex_color'
));
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'architect_contractor_footer_widget_background_color', array(
    'label'     => __('Footer Widget Background Color', 'architect-contractor'),
    'description' => __('It will change the complete footer widget background color.', 'architect-contractor'),
    'section' => 'architect_contractor_footer_widget_area',
    'settings' => 'architect_contractor_footer_widget_background_color',
)));

$wp_customize->add_setting('architect_contractor_footer_widget_background_image',array(
    'default'   => '',
    'sanitize_callback' => 'esc_url_raw',
));
$wp_customize->add_control( new WP_Customize_Image_Control($wp_customize,'architect_contractor_footer_widget_background_image',array(
    'label' => __('Footer Widget Background Image','architect-contractor'),
    'section' => 'architect_contractor_footer_widget_area'
)));

$wp_customize->add_setting('architect_contractor_enable_to_the_top',
    array(
        'default' => $architect_contractor_default['architect_contractor_enable_to_the_top'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'architect_contractor_sanitize_checkbox',
    )
);
$wp_customize->add_control('architect_contractor_enable_to_the_top',
    array(
        'label' => esc_html__('Enable To The Top', 'architect-contractor'),
        'section' => 'architect_contractor_footer_widget_area',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting( 'architect_contractor_to_the_top_text',
    array(
    'default'           => $architect_contractor_default['architect_contractor_to_the_top_text'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'architect_contractor_to_the_top_text',
    array(
    'label'    => esc_html__( 'Edit Text Here', 'architect-contractor' ),
    'section'  => 'architect_contractor_footer_widget_area',
    'type'     => 'text',
    )
);