<?php
/**
 * Default Values.
 *
 * @package Architect Contractor
 */

if ( ! function_exists( 'architect_contractor_get_default_theme_options' ) ) :
	function architect_contractor_get_default_theme_options() {

		$architect_contractor_defaults = array();
		
		// Options.
        $architect_contractor_defaults['architect_contractor_logo_width_range']                                  = 200;
		$architect_contractor_defaults['architect_contractor_global_sidebar_layout']					            = 'right-sidebar';
        $architect_contractor_defaults['architect_contractor_theme_breadcrumb_options_alignment']                      = 'Left';
        $architect_contractor_defaults['architect_contractor_theme_pagination_options_alignment']                      = 'Center';
        $architect_contractor_defaults['architect_contractor_header_banner_social_facebook_link']    = esc_url( 'https://www.facebook.com/', 'architect-contractor' );
        $architect_contractor_defaults['architect_contractor_header_banner_social_twitter_link']      = esc_url( 'https://twitter.com/', 'architect-contractor' );
        $architect_contractor_defaults['architect_contractor_header_banner_social_instagram_link']  = esc_url( 'https://www.instagram.com/', 'architect-contractor' );
        $architect_contractor_defaults['architect_contractor_header_banner_social_linkdin_link']      = esc_url( 'https://linkedin.com/', 'architect-contractor' );
        $architect_contractor_defaults['architect_contractor_header_banner_social_watsapp_link']      = esc_url( 'https://www.whatsapp.com/', 'architect-contractor' );        
        $architect_contractor_defaults['architect_contractor_theme_loader']                 = 0;
        $architect_contractor_defaults['architect_contractor_header_layout_location_address']      = esc_html__( '246, Old York Rd, NY 08080', 'architect-contractor' );
        $architect_contractor_defaults['architect_contractor_header_layout_email_address']       = 'support@example.com';
        $architect_contractor_defaults['architect_contractor_header_layout_working_hour']       = '09:00 AM to 07:00 PM ( Mon - Sat )';
        $architect_contractor_defaults['architect_contractor_header_layout_phone_number']       = '+11 231 456 7890';
        $architect_contractor_defaults['architect_contractor_pagination_layout']         = 'numeric';
		$architect_contractor_defaults['architect_contractor_footer_column_layout'] 						 = 3;
        $architect_contractor_defaults['architect_contractor_menu_font_size']                 = 15;
        $architect_contractor_defaults['architect_contractor_copyright_font_size']                 = 16;
        $architect_contractor_defaults['architect_contractor_theme_breadcrumb_enable']                 = 1;
        $architect_contractor_defaults['architect_contractor_single_post_content_alignment']                 = 'left';
        $architect_contractor_defaults['architect_contractor_breadcrumb_font_size']                 = 16;
        $architect_contractor_defaults['architect_contractor_excerpt_limit']                 = 20;
        $architect_contractor_defaults['architect_contractor_menu_text_transform']                 = 'capitalize';
        $architect_contractor_defaults['architect_contractor_single_page_content_alignment']                 = 'left';  
        $architect_contractor_defaults['architect_contractor_per_columns']                 = 3;  
        $architect_contractor_defaults['architect_contractor_product_per_page']                 = 9;
        $architect_contractor_defaults['architect_contractor_custom_related_products_number'] = 6;
        $architect_contractor_defaults['architect_contractor_custom_related_products_number_per_row'] = 3;
		$architect_contractor_defaults['architect_contractor_footer_copyright_text'] 				     = esc_html__( 'All rights reserved.', 'architect-contractor' );
        $architect_contractor_defaults['twp_navigation_type']              			 = 'theme-normal-navigation';
        $architect_contractor_defaults['architect_contractor_post_author']                		= 1;
        $architect_contractor_defaults['architect_contractor_display_archive_post_sticky_post']            = 1;
        $architect_contractor_defaults['architect_contractor_display_archive_post_category']            = 1;
        $architect_contractor_defaults['architect_contractor_display_archive_post_title']            = 1;
        $architect_contractor_defaults['architect_contractor_display_archive_post_content']            = 1;
        $architect_contractor_defaults['architect_contractor_display_archive_post_button']            = 1;
        $architect_contractor_defaults['architect_contractor_post_date']                		= 1;
        $architect_contractor_defaults['architect_contractor_post_category']                	= 1;
        $architect_contractor_defaults['architect_contractor_post_tags']                		= 1;
        $architect_contractor_defaults['architect_contractor_floating_next_previous_nav']       = 1;
        $architect_contractor_defaults['architect_contractor_header_banner']               		= 1;
        $architect_contractor_defaults['architect_contractor_display_header_title']             = 1;
        $architect_contractor_defaults['architect_contractor_display_header_text']             = 0;
        $architect_contractor_defaults['architect_contractor_services']               	        = 1;
        $architect_contractor_defaults['architect_contractor_services_section_title']           = esc_html__('Our Services That We Provide','architect-contractor');
        $architect_contractor_defaults['architect_contractor_services_section_short_title']     = esc_html__('What We Do','architect-contractor');
        $architect_contractor_defaults['architect_contractor_global_color']                                   = '#FF4A11';
        $architect_contractor_defaults['architect_contractor_display_archive_post_category']          = 1;
        $architect_contractor_defaults['architect_contractor_display_archive_post_title']             = 1;
        $architect_contractor_defaults['architect_contractor_display_archive_post_content']           = 1;
        $architect_contractor_defaults['architect_contractor_display_archive_post_button']            = 1;
        
        $architect_contractor_defaults['architect_contractor_display_single_post_image']            = 1;
        $architect_contractor_defaults['architect_contractor_display_archive_post_format_icon']       = 1;

        $architect_contractor_defaults['architect_contractor_architect_contractor_counter']                         = 1;
       
        $architect_contractor_defaults['architect_contractor_background_color']               	= '#fff';
        $architect_contractor_defaults['architect_contractor_display_footer']            = 1;
        $architect_contractor_defaults['architect_contractor_footer_widget_title_alignment']                 = 'left'; 
        $architect_contractor_defaults['architect_contractor_show_hide_related_product']          = 1;
        $architect_contractor_defaults['architect_contractor_display_archive_post_image']            = 1;

        $architect_contractor_defaults['architect_contractor_enable_to_the_top']                      = 1;
        $architect_contractor_defaults['architect_contractor_to_the_top_text']                      = esc_html__( 'To The Top', 'architect-contractor' );

        // 404 Page Defaults
        $architect_contractor_defaults['architect_contractor_404_main_title'] = esc_html__( 'Oops! That page can’t be found.', 'architect-contractor' );
        $architect_contractor_defaults['architect_contractor_404_subtitle_one'] = esc_html__( 'Maybe it’s out there, somewhere...', 'architect-contractor' );
        $architect_contractor_defaults['architect_contractor_404_para_one'] = esc_html__( 'You can always find insightful stories on our', 'architect-contractor' );
        $architect_contractor_defaults['architect_contractor_404_subtitle_two'] = esc_html__( 'Still feeling lost? You’re not alone.', 'architect-contractor' );
        $architect_contractor_defaults['architect_contractor_404_para_two'] = esc_html__( 'Enjoy these stories about getting lost, losing things, and finding what you never knew you were looking for.', 'architect-contractor' );

		// Pass through filter.
		$architect_contractor_defaults = apply_filters( 'architect_contractor_filter_default_theme_options', $architect_contractor_defaults );

		return $architect_contractor_defaults;
	}
endif;
