<?php
/**
* Customizer Custom Classes.
* @package Architect Contractor
*/

if ( ! function_exists( 'architect_contractor_sanitize_number_range' ) ) :
    function architect_contractor_sanitize_number_range( $architect_contractor_input, $architect_contractor_setting ) {
        $architect_contractor_input = absint( $architect_contractor_input );
        $architect_contractor_atts = $architect_contractor_setting->manager->get_control( $architect_contractor_setting->id )->input_attrs;
        $architect_contractor_min = ( isset( $architect_contractor_atts['min'] ) ? $architect_contractor_atts['min'] : $architect_contractor_input );
        $architect_contractor_max = ( isset( $architect_contractor_atts['max'] ) ? $architect_contractor_atts['max'] : $architect_contractor_input );
        $architect_contractor_step = ( isset( $architect_contractor_atts['step'] ) ? $architect_contractor_atts['step'] : 1 );
        return ( $architect_contractor_min <= $architect_contractor_input && $architect_contractor_input <= $architect_contractor_max && is_int( $architect_contractor_input / $architect_contractor_step ) ? $architect_contractor_input : $architect_contractor_setting->default );
    }
endif;

/**
 * Upsell customizer section.
 *
 * @since  1.0.0
 * @access public
 */
class Architect_Contractor_Customize_Section_Upsell extends WP_Customize_Section {

    /**
     * The type of customize section being rendered.
     *
     * @since  1.0.0
     * @access public
     * @var    string
     */
    public $type = 'upsell';

    /**
     * Custom button text to output.
     *
     * @since  1.0.0
     * @access public
     * @var    string
     */
    public $pro_text = '';

    /**
     * Custom pro button URL.
     *
     * @since  1.0.0
     * @access public
     * @var    string
     */
    public $pro_url = '';

    public $notice = '';
    public $nonotice = '';

    /**
     * Add custom parameters to pass to the JS via JSON.
     *
     * @since  1.0.0
     * @access public
     * @return void
     */
    public function json() {
        $json = parent::json();

        $json['pro_text'] = $this->pro_text;
        $json['pro_url']  = esc_url( $this->pro_url );
        $json['notice']  = esc_attr( $this->notice );
        $json['nonotice']  = esc_attr( $this->nonotice );

        return $json;
    }

    /**
     * Outputs the Underscore.js template.
     *
     * @since  1.0.0
     * @access public
     * @return void
     */
    protected function render_template() { ?>

        <li id="accordion-section-{{ data.id }}" class="accordion-section control-section control-section-{{ data.type }} cannot-expand">

            <# if ( data.notice ) { #>
                <h3 class="accordion-section-notice">
                    {{ data.title }}
                </h3>
            <# } #>

            <# if ( !data.notice ) { #>
                <h3 class="accordion-section-title">
                    {{ data.title }}

                    <# if ( data.pro_text && data.pro_url ) { #>
                        <a href="{{ data.pro_url }}" class="button button-secondary alignright" target="_blank">{{ data.pro_text }}</a>
                    <# } #>
                </h3>
            <# } #>
            
        </li>
    <?php }
}