<?php
/**
* Custom Addons.
*
* @package Architect Contractor
*/

$wp_customize->add_section( 'architect_contractor_theme_pagination_options',
    array(
    'title'      => esc_html__( 'Customizer Custom Settings', 'architect-contractor' ),
    'priority'   => 10,
    'capability' => 'edit_theme_options',
    'panel'      => 'architect_contractor_theme_addons_panel',
    )
);

$wp_customize->add_setting('architect_contractor_theme_loader',
    array(
        'default' => $architect_contractor_default['architect_contractor_theme_loader'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'architect_contractor_sanitize_checkbox',
    )
);
$wp_customize->add_control('architect_contractor_theme_loader',
    array(
        'label' => esc_html__('Enable Preloader', 'architect-contractor'),
        'section' => 'architect_contractor_theme_pagination_options',
        'type' => 'checkbox',
    )
);

// Add Pagination Enable/Disable option to Customizer
$wp_customize->add_setting( 'architect_contractor_enable_pagination', 
    array(
        'default'           => true, // Default is enabled
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'architect_contractor_sanitize_enable_pagination', // Sanitize the input
    )
);

// Add the control to the Customizer
$wp_customize->add_control( 'architect_contractor_enable_pagination', 
    array(
        'label'    => esc_html__( 'Enable Pagination', 'architect-contractor' ),
        'section'  => 'architect_contractor_theme_pagination_options', // Add to the correct section
        'type'     => 'checkbox',
    )
);

$wp_customize->add_setting( 'architect_contractor_theme_pagination_type', 
    array(
        'default'           => 'numeric', // Set "numeric" as the default
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'architect_contractor_sanitize_pagination_type', // Use our sanitize function
    )
);

$wp_customize->add_control( 'architect_contractor_theme_pagination_type',
    array(
        'label'       => esc_html__( 'Pagination Style', 'architect-contractor' ),
        'section'     => 'architect_contractor_theme_pagination_options',
        'type'        => 'select',
        'choices'     => array(
            'numeric'      => esc_html__( 'Numeric (Page Numbers)', 'architect-contractor' ),
            'newer_older'  => esc_html__( 'Newer/Older (Previous/Next)', 'architect-contractor' ), // Renamed to "Newer/Older"
        ),
    )
);


$wp_customize->add_setting( 'architect_contractor_theme_pagination_options_alignment',
    array(
    'default'           => $architect_contractor_default['architect_contractor_theme_pagination_options_alignment'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'architect_contractor_sanitize_pagination_meta',
    )
);
$wp_customize->add_control( 'architect_contractor_theme_pagination_options_alignment',
    array(
    'label'       => esc_html__( 'Pagination Alignment', 'architect-contractor' ),
    'section'     => 'architect_contractor_theme_pagination_options',
    'type'        => 'select',
    'choices'     => array(
        'Center'    => esc_html__( 'Center', 'architect-contractor' ),
        'Right' => esc_html__( 'Right', 'architect-contractor' ),
        'Left'  => esc_html__( 'Left', 'architect-contractor' ),
        ),
    )
);

$wp_customize->add_setting('architect_contractor_theme_breadcrumb_enable',
array(
    'default' => $architect_contractor_default['architect_contractor_theme_breadcrumb_enable'],
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'architect_contractor_sanitize_checkbox',
)
);
$wp_customize->add_control('architect_contractor_theme_breadcrumb_enable',
    array(
        'label' => esc_html__('Enable Breadcrumb', 'architect-contractor'),
        'section' => 'architect_contractor_theme_pagination_options',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting( 'architect_contractor_theme_breadcrumb_options_alignment',
    array(
    'default'           => $architect_contractor_default['architect_contractor_theme_breadcrumb_options_alignment'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'architect_contractor_sanitize_pagination_meta',
    )
);
$wp_customize->add_control( 'architect_contractor_theme_breadcrumb_options_alignment',
    array(
    'label'       => esc_html__( 'Breadcrumb Alignment', 'architect-contractor' ),
    'section'     => 'architect_contractor_theme_pagination_options',
    'type'        => 'select',
    'choices'     => array(
        'Center'    => esc_html__( 'Center', 'architect-contractor' ),
        'Right' => esc_html__( 'Right', 'architect-contractor' ),
        'Left'  => esc_html__( 'Left', 'architect-contractor' ),
        ),
    )
);

$wp_customize->add_setting('architect_contractor_breadcrumb_font_size',
    array(
        'default'           => $architect_contractor_default['architect_contractor_breadcrumb_font_size'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'architect_contractor_sanitize_number_range',
    )
);
$wp_customize->add_control('architect_contractor_breadcrumb_font_size',
    array(
        'label'       => esc_html__('Breadcrumb Font Size', 'architect-contractor'),
        'section'     => 'architect_contractor_theme_pagination_options',
        'type'        => 'number',
        'input_attrs' => array(
           'min'   => 1,
           'max'   => 45,
           'step'   => 1,
        ),
    )
);