<?php
/**
* Additional Woocommerce Settings.
*
* @package Architect Contractor
*/

$architect_contractor_default = architect_contractor_get_default_theme_options();

// Additional Woocommerce Section.
$wp_customize->add_section( 'architect_contractor_additional_woocommerce_options',
	array(
	'title'      => esc_html__( 'Additional Woocommerce Options', 'architect-contractor' ),
	'priority'   => 210,
	'capability' => 'edit_theme_options',
	'panel'      => 'architect_contractor_theme_option_panel',
	)
);

	$wp_customize->add_setting('architect_contractor_per_columns',
		array(
		'default'           => $architect_contractor_default['architect_contractor_per_columns'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'architect_contractor_sanitize_number_range',
		)
	);
	$wp_customize->add_control('architect_contractor_per_columns',
		array(
		'label'       => esc_html__('Products Per Column', 'architect-contractor'),
		'section'     => 'architect_contractor_additional_woocommerce_options',
		'type'        => 'number',
		'input_attrs' => array(
		'min'   => 1,
		'max'   => 6,
		'step'   => 1,
		),
		)
	);

	$wp_customize->add_setting('architect_contractor_product_per_page',
		array(
		'default'           => $architect_contractor_default['architect_contractor_product_per_page'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'architect_contractor_sanitize_number_range',
		)
	);
	$wp_customize->add_control('architect_contractor_product_per_page',
		array(
		'label'       => esc_html__('Products Per Page', 'architect-contractor'),
		'section'     => 'architect_contractor_additional_woocommerce_options',
		'type'        => 'number',
		'input_attrs' => array(
		'min'   => 1,
		'max'   => 100,
		'step'   => 1,
		),
		)
	);

	$wp_customize->add_setting('architect_contractor_show_hide_related_product',
    array(
        'default' => $architect_contractor_default['architect_contractor_show_hide_related_product'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'architect_contractor_sanitize_checkbox',
    )
	);
	$wp_customize->add_control('architect_contractor_show_hide_related_product',
	    array(
	        'label' => esc_html__('Enable Related Products', 'architect-contractor'),
	        'section' => 'architect_contractor_additional_woocommerce_options',
	        'type' => 'checkbox',
	    )
	);

	$wp_customize->add_setting('architect_contractor_custom_related_products_number',
		array(
		'default'           => $architect_contractor_default['architect_contractor_custom_related_products_number'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'architect_contractor_sanitize_number_range',
		)
	);
	$wp_customize->add_control('architect_contractor_custom_related_products_number',
		array(
		'label'       => esc_html__('Related Products Per Page', 'architect-contractor'),
		'section'     => 'architect_contractor_additional_woocommerce_options',
		'type'        => 'number',
		'input_attrs' => array(
		'min'   => 1,
		'max'   => 10,
		'step'   => 1,
		),
		)
	);

	$wp_customize->add_setting('architect_contractor_custom_related_products_number_per_row',
		array(
		'default'           => $architect_contractor_default['architect_contractor_custom_related_products_number_per_row'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'architect_contractor_sanitize_number_range',
		)
	);
	$wp_customize->add_control('architect_contractor_custom_related_products_number_per_row',
		array(
		'label'       => esc_html__('Related Products Per Row', 'architect-contractor'),
		'section'     => 'architect_contractor_additional_woocommerce_options',
		'type'        => 'number',
		'input_attrs' => array(
		'min'   => 1,
		'max'   => 5,
		'step'   => 1,
		),
		)
	);