<?php
/**
* 404 Page Settings.
*
* @package Architect Contractor
*/

$architect_contractor_default = architect_contractor_get_default_theme_options();

$wp_customize->add_section( 'architect_contractor_404_page_settings',
    array(
        'title'      => esc_html__( '404 Page Settings', 'architect-contractor' ),
        'priority'   => 200,
        'capability' => 'edit_theme_options',
        'panel'      => 'architect_contractor_theme_addons_panel',
    )
);

$wp_customize->add_setting( 'architect_contractor_404_main_title',
    array(
        'default'           => $architect_contractor_default['architect_contractor_404_main_title'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'architect_contractor_404_main_title',
    array(
        'label'    => esc_html__( '404 Main Title', 'architect-contractor' ),
        'section'  => 'architect_contractor_404_page_settings',
        'type'     => 'text',
    )
);

$wp_customize->add_setting( 'architect_contractor_404_subtitle_one',
    array(
        'default'           => $architect_contractor_default['architect_contractor_404_subtitle_one'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'architect_contractor_404_subtitle_one',
    array(
        'label'    => esc_html__( '404 Sub Title One', 'architect-contractor' ),
        'section'  => 'architect_contractor_404_page_settings',
        'type'     => 'text',
    )
);

$wp_customize->add_setting( 'architect_contractor_404_para_one',
    array(
        'default'           => $architect_contractor_default['architect_contractor_404_para_one'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'architect_contractor_404_para_one',
    array(
        'label'    => esc_html__( '404 Para Text One', 'architect-contractor' ),
        'section'  => 'architect_contractor_404_page_settings',
        'type'     => 'text',
    )
);

$wp_customize->add_setting( 'architect_contractor_404_subtitle_two',
    array(
        'default'           => $architect_contractor_default['architect_contractor_404_subtitle_two'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'architect_contractor_404_subtitle_two',
    array(
        'label'    => esc_html__( '404 Sub Title Two', 'architect-contractor' ),
        'section'  => 'architect_contractor_404_page_settings',
        'type'     => 'text',
    )
);

$wp_customize->add_setting( 'architect_contractor_404_para_two',
    array(
        'default'           => $architect_contractor_default['architect_contractor_404_para_two'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'architect_contractor_404_para_two',
    array(
        'label'    => esc_html__( '404 Para Text Two', 'architect-contractor' ),
        'section'  => 'architect_contractor_404_page_settings',
        'type'     => 'text',
    )
);