<?php
/**
 * Sample implementation of the Custom Header feature
 * @package Architect Contractor
 */

/**
 * Set up the WordPress core custom header feature.
 *
 * @uses architect_contractor_header_style()
 */
function architect_contractor_custom_header_setup()
{
    add_theme_support('custom-header',
        apply_filters('architect_contractor_custom_header_args', array(
            'default-image' => '',
            'default-text-color' => '000000',
            'width' => 280,
            'height' => 1920,
            'flex-height' => true,
            'flex-width' => true,
            'wp-head-callback' => 'architect_contractor_header_style',
        )));
}

add_action('after_setup_theme', 'architect_contractor_custom_header_setup');

if (!function_exists('architect_contractor_header_style')) :
    /**
     * Styles the header image and text displayed on the blog
     *
     * @see architect_contractor_custom_header_setup().
     */
    function architect_contractor_header_style()
    {
        $architect_contractor_header_text_color = get_header_textcolor();

        if (get_theme_support('custom-header', 'default-text-color') === $architect_contractor_header_text_color) {
            return;
        }

        ?>
        <style type="text/css">
            <?php
                if ( 'blank' == $architect_contractor_header_text_color ) :
            ?>
            .header-titles .custom-logo-name,
            .site-description {
                display: none;
                position: absolute;
                clip: rect(1px, 1px, 1px, 1px);
            }

            <?php
                else :
            ?>
            .header-titles .custom-logo-name:not(:hover):not(:focus),
            .site-description {
                color: #<?php echo esc_attr( $architect_contractor_header_text_color ); ?>;
            }

            <?php endif; ?>
        </style>
        <?php
    }
endif;