<?php
/**
 * Custom Functions.
 *
 * @package Architect Contractor
 */

if( !function_exists( 'architect_contractor_fonts_url' ) ) :

    //Google Fonts URL
    function architect_contractor_fonts_url(){

        $architect_contractor_font_families = array(
            'Kanit:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900',
            'Lato:ital,wght@0,100;0,300;0,400;0,700;0,900;1,100;1,300;1,400;1,700;1,900',
        );

        $architect_contractor_fonts_url = add_query_arg( array(
            'family' => implode( '&family=', $architect_contractor_font_families ),
            'display' => 'swap',
        ), 'https://fonts.googleapis.com/css2' );

        return esc_url_raw($architect_contractor_fonts_url);

    }

endif;

if ( ! function_exists( 'architect_contractor_sub_menu_toggle_button' ) ) :

    function architect_contractor_sub_menu_toggle_button( $architect_contractor_args, $architect_contractor_item, $depth ) {

        // Add sub menu toggles to the main menu with toggles
        if ( $architect_contractor_args->theme_location == 'architect-contractor-primary-menu' && isset( $architect_contractor_args->show_toggles ) ) {
            
            // Wrap the menu item link contents in a div, used for positioning
            $architect_contractor_args->before = '<div class="submenu-wrapper">';
            $architect_contractor_args->after  = '';

            // Add a toggle to items with children
            if ( in_array( 'menu-item-has-children', $architect_contractor_item->classes ) ) {

                $architect_contractor_toggle_target_string = '.menu-item.menu-item-' . $architect_contractor_item->ID . ' > .sub-menu';

                // Add the sub menu toggle
                $architect_contractor_args->after .= '<button type="button" class="theme-aria-button submenu-toggle" data-toggle-target="' . $architect_contractor_toggle_target_string . '" data-toggle-type="slidetoggle" data-toggle-duration="250" aria-expanded="false"><span class="btn__content" tabindex="-1"><span class="screen-reader-text">' . esc_html__( 'Show sub menu', 'architect-contractor' ) . '</span>' . architect_contractor_get_theme_svg( 'chevron-down' ) . '</span></button>';

            }

            // Close the wrapper
            $architect_contractor_args->after .= '</div><!-- .submenu-wrapper -->';
            // Add sub menu icons to the main menu without toggles (the fallback menu)

        }elseif( $architect_contractor_args->theme_location == 'architect-contractor-primary-menu' ) {

            if ( in_array( 'menu-item-has-children', $architect_contractor_item->classes ) ) {

                $architect_contractor_args->before = '<div class="link-icon-wrapper">';
                $architect_contractor_args->after  = architect_contractor_get_theme_svg( 'chevron-down' ) . '</div>';

            } else {

                $architect_contractor_args->before = '';
                $architect_contractor_args->after  = '';

            }

        }

        return $architect_contractor_args;

    }

endif;

add_filter( 'nav_menu_item_args', 'architect_contractor_sub_menu_toggle_button', 10, 3 );

if ( ! function_exists( 'architect_contractor_the_theme_svg' ) ):
    
    function architect_contractor_the_theme_svg( $architect_contractor_svg_name, $architect_contractor_return = false ) {

        if( $architect_contractor_return ){

            return architect_contractor_get_theme_svg( $architect_contractor_svg_name ); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Escaped in architect_contractor_get_theme_svg();.

        }else{

            echo architect_contractor_get_theme_svg( $architect_contractor_svg_name ); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Escaped in architect_contractor_get_theme_svg();.

        }
    }

endif;

if ( ! function_exists( 'architect_contractor_get_theme_svg' ) ):

    function architect_contractor_get_theme_svg( $architect_contractor_svg_name ) {

        // Make sure that only our allowed tags and attributes are included.
        $architect_contractor_svg = wp_kses(
            Architect_Contractor_SVG_Icons::get_svg( $architect_contractor_svg_name ),
            array(
                'svg'     => array(
                    'class'       => true,
                    'xmlns'       => true,
                    'width'       => true,
                    'height'      => true,
                    'viewbox'     => true,
                    'aria-hidden' => true,
                    'role'        => true,
                    'focusable'   => true,
                ),
                'path'    => array(
                    'fill'      => true,
                    'fill-rule' => true,
                    'd'         => true,
                    'transform' => true,
                ),
                'polygon' => array(
                    'fill'      => true,
                    'fill-rule' => true,
                    'points'    => true,
                    'transform' => true,
                    'focusable' => true,
                ),
                'polyline' => array(
                    'fill'      => true,
                    'points'    => true,
                ),
                'line' => array(
                    'fill'      => true,
                    'x1'      => true,
                    'x2' => true,
                    'y1'    => true,
                    'y2' => true,
                ),
            )
        );
        if ( ! $architect_contractor_svg ) {
            return false;
        }
        return $architect_contractor_svg;

    }

endif;

if( !function_exists( 'architect_contractor_post_category_list' ) ) :

    // Post Category List.
    function architect_contractor_post_category_list( $architect_contractor_select_cat = true ){

        $architect_contractor_post_cat_lists = get_categories(
            array(
                'hide_empty' => '0',
                'exclude' => '1',
            )
        );

        $architect_contractor_post_cat_cat_array = array();
        if( $architect_contractor_select_cat ){

            $architect_contractor_post_cat_cat_array[''] = esc_html__( '-- Select Category --','architect-contractor' );

        }

        foreach ( $architect_contractor_post_cat_lists as $architect_contractor_post_cat_list ) {

            $architect_contractor_post_cat_cat_array[$architect_contractor_post_cat_list->slug] = $architect_contractor_post_cat_list->name;

        }

        return $architect_contractor_post_cat_cat_array;
    }

endif;

if( !function_exists('architect_contractor_single_post_navigation') ):

    function architect_contractor_single_post_navigation(){

        $architect_contractor_default = architect_contractor_get_default_theme_options();
        $architect_contractor_twp_navigation_type = esc_attr( get_post_meta( get_the_ID(), 'twp_disable_ajax_load_next_post', true ) );
        $architect_contractor_current_id = '';
        $article_wrap_class = '';
        global $post;
        $architect_contractor_current_id = $post->ID;
        if( $architect_contractor_twp_navigation_type == '' || $architect_contractor_twp_navigation_type == 'global-layout' ){
            $architect_contractor_twp_navigation_type = get_theme_mod('twp_navigation_type', $architect_contractor_default['twp_navigation_type']);
        }

        if( $architect_contractor_twp_navigation_type != 'no-navigation' && 'post' === get_post_type() ){

            if( $architect_contractor_twp_navigation_type == 'theme-normal-navigation' ){ ?>

                <div class="navigation-wrapper">
                    <?php
                    // Previous/next post navigation.
                    the_post_navigation(array(
                        'prev_text' => '<span class="arrow" aria-hidden="true">' . architect_contractor_the_theme_svg('arrow-left',$architect_contractor_return = true ) . '</span><span class="screen-reader-text">' . esc_html__('Previous post:', 'architect-contractor') . '</span><span class="post-title">%title</span>',
                        'next_text' => '<span class="arrow" aria-hidden="true">' . architect_contractor_the_theme_svg('arrow-right',$architect_contractor_return = true ) . '</span><span class="screen-reader-text">' . esc_html__('Next post:', 'architect-contractor') . '</span><span class="post-title">%title</span>',
                    )); ?>
                </div>
                <?php

            }else{

                $architect_contractor_next_post = get_next_post();
                if( isset( $architect_contractor_next_post->ID ) ){

                    $architect_contractor_next_post_id = $architect_contractor_next_post->ID;
                    echo '<div loop-count="1" next-post="' . absint( $architect_contractor_next_post_id ) . '" class="twp-single-infinity"></div>';

                }
            }

        }

    }

endif;

add_action( 'architect_contractor_navigation_action','architect_contractor_single_post_navigation',30 );

if( !function_exists('architect_contractor_content_offcanvas') ):

    // Offcanvas Contents
    function architect_contractor_content_offcanvas(){ ?>

        <div id="offcanvas-menu">
            <div class="offcanvas-wraper">
                <div class="close-offcanvas-menu">
                    <div class="offcanvas-close">
                        <a href="javascript:void(0)" class="skip-link-menu-start"></a>
                        <button type="button" class="button-offcanvas-close">
                            <span class="offcanvas-close-label">
                                <?php echo esc_html__('Close', 'architect-contractor'); ?>
                            </span>
                        </button>
                    </div>
                </div>
                <div id="primary-nav-offcanvas" class="offcanvas-item offcanvas-main-navigation">
                    <nav class="primary-menu-wrapper" aria-label="<?php esc_attr_e('Horizontal', 'architect-contractor'); ?>" role="navigation">
                        <ul class="primary-menu theme-menu">
                            <?php
                            if (has_nav_menu('architect-contractor-primary-menu')) {
                                wp_nav_menu(
                                    array(
                                        'container' => '',
                                        'items_wrap' => '%3$s',
                                        'theme_location' => 'architect-contractor-primary-menu',
                                        'show_toggles' => true,
                                    )
                                );
                            }else{

                                wp_list_pages(
                                    array(
                                        'match_menu_classes' => true,
                                        'show_sub_menu_icons' => true,
                                        'title_li' => false,
                                        'show_toggles' => true,
                                        'walker' => new Architect_Contractor_Walker_Page(),
                                    )
                                );
                            }
                            ?>
                        </ul>
                    </nav><!-- .primary-menu-wrapper -->
                </div>
                <a href="javascript:void(0)" class="skip-link-menu-end"></a>
            </div>
        </div>

    <?php
    }

endif;

add_action( 'architect_contractor_before_footer_content_action','architect_contractor_content_offcanvas',30 );

if( !function_exists('architect_contractor_footer_content_widget') ):

    function architect_contractor_footer_content_widget(){
        
        $architect_contractor_default = architect_contractor_get_default_theme_options();
        
        $architect_contractor_footer_column_layout = absint(get_theme_mod('architect_contractor_footer_column_layout', $architect_contractor_default['architect_contractor_footer_column_layout']));
        $architect_contractor_footer_sidebar_class = 12;
        
        if($architect_contractor_footer_column_layout == 2) {
            $architect_contractor_footer_sidebar_class = 6;
        }
        
        if($architect_contractor_footer_column_layout == 3) {
            $architect_contractor_footer_sidebar_class = 4;
        }
        ?>
        
        <?php if ( get_theme_mod('architect_contractor_display_footer', true) == true ) : ?>
            <div class="footer-widgetarea">
                <div class="wrapper">
                    <div class="column-row">
                    
                        <?php for ($i = 0; $i < $architect_contractor_footer_column_layout; $i++) : ?>
                            
                            <div class="column <?php echo 'column-' . absint($architect_contractor_footer_sidebar_class); ?> column-sm-12">
                                
                                <?php 
                                // If no widgets are assigned, display default widgets
                                if ( ! is_active_sidebar( 'architect-contractor-footer-widget-' . $i ) ) : 

                                    if ($i === 0) : ?>
                                        <div id="media_image-3" class="widget widget_media_image">
                                            <img src="<?php echo esc_url(get_template_directory_uri() . '/assets/images/logo.png'); ?>" alt="<?php echo esc_attr__( 'Footer Image', 'architect-contractor' ); ?>" style="max-width: 100%; height: auto;">
                                        </div>
                                        <div id="text-3" class="widget widget_text">
                                            <div class="textwidget">
                                                <p class="widget_text">
                                                    <?php esc_html_e('Architect Contractor WordPress Theme is a powerful website template specifically designed for professionals and businesses in the architecture, construction, and design industries. This theme caters to architects, architectural designers, construction managers, building contractors, and those offering services like custom home building, renovation, sustainable architecture, and urban planning.', 'architect-contractor'); ?>
                                                </p>
                                            </div>
                                        </div>

                                    <?php elseif ($i === 1) : ?>
                                        <div id="pages-2" class="widget widget_pages">
                                            <h2 class="widget-title"><?php esc_html_e('Calendar', 'architect-contractor'); ?></h2>
                                            <?php get_calendar(); ?>
                                        </div>

                                    <?php elseif ($i === 2) : ?>
                                        <div id="search-2" class="widget widget_search">
                                            <h2 class="widget-title"><?php esc_html_e('Enter Keywords Here', 'architect-contractor'); ?></h2>
                                            <?php get_search_form(); ?>
                                        </div>
                                    <?php endif; 
                                    
                                else :
                                    // Display dynamic sidebar widget if assigned
                                    dynamic_sidebar('architect-contractor-footer-widget-' . $i);
                                endif;
                                ?>
                                
                            </div>
                            
                        <?php endfor; ?>

                    </div>
                </div>
            </div>
        <?php endif; ?> 

    <?php
    }

endif;

add_action( 'architect_contractor_footer_content_action', 'architect_contractor_footer_content_widget', 10 );

if( !function_exists('architect_contractor_footer_content_info') ):

    /**
     * Footer Copyright Area
    **/
    function architect_contractor_footer_content_info(){

        $architect_contractor_default = architect_contractor_get_default_theme_options(); ?>
        <div class="site-info">
            <div class="wrapper">
                <div class="column-row">

                    <div class="column column-9">
                        <div class="footer-credits">

                            <div class="footer-copyright">

                                <?php
                                $architect_contractor_footer_copyright_text = wp_kses_post( get_theme_mod( 'architect_contractor_footer_copyright_text', $architect_contractor_default['architect_contractor_footer_copyright_text'] ) );
                                    echo esc_html( $architect_contractor_footer_copyright_text );
                                    echo '<br>';
                                    echo esc_html__('Theme: ', 'architect-contractor') . '<a href="' . esc_url('https://www.omegathemes.com/products/free-architect-wordpress-theme') . '" title="' . esc_attr__('Architect Contractor', 'architect-contractor') . '" target="_blank"><span>' . esc_html__('Architect Contractor', 'architect-contractor') . '</span></a>' . esc_html__(' By ', 'architect-contractor') . '  <span>' . esc_html__('OMEGA ', 'architect-contractor') . '</span>';
                                    echo esc_html__('Powered by ', 'architect-contractor') . '<a href="' . esc_url('https://wordpress.org') . '" title="' . esc_attr__('WordPress', 'architect-contractor') . '" target="_blank"><span>' . esc_html__('WordPress.', 'architect-contractor') . '</span></a>';
                                 ?>
                            </div>
                        </div>
                    </div>


                    <div class="column column-3 align-text-right">
                        <a class="to-the-top" href="#site-header">
                            <span class="to-the-top-long">
                                <?php if ( get_theme_mod('architect_contractor_enable_to_the_top', true) == true ) : ?>
                                    <?php
                                    $architect_contractor_to_the_top_text = get_theme_mod( 'architect_contractor_to_the_top_text', __( 'To the Top', 'architect-contractor' ) );
                                    printf( 
                                        wp_kses( 
                                            /* translators: %s is the arrow icon markup */
                                            '%s %s', 
                                            array( 'span' => array( 'class' => array(), 'aria-hidden' => array() ) ) 
                                        ), 
                                        esc_html( $architect_contractor_to_the_top_text ),
                                        '<span class="arrow" aria-hidden="true">&uarr;</span>' 
                                    );
                                    ?>
                                <?php endif; ?>
                            </span>
                        </a>

                    </div>
                </div>
            </div>
        </div>

    <?php
    }

endif;

add_action( 'architect_contractor_footer_content_action','architect_contractor_footer_content_info',20 );

if( !function_exists( 'architect_contractor_main_slider' ) ) :

    function architect_contractor_main_slider(){

        $architect_contractor_defaults = architect_contractor_get_default_theme_options();
        $architect_contractor_header_banner = get_theme_mod( 'architect_contractor_header_banner', $architect_contractor_defaults['architect_contractor_header_banner'] );
        $architect_contractor_header_banner_cat = get_theme_mod( 'architect_contractor_header_banner_cat','Slider' );

        $architect_contractor_header_banner_social_facebook_link = esc_html( get_theme_mod( 'architect_contractor_header_banner_social_facebook_link',
        $architect_contractor_defaults['architect_contractor_header_banner_social_facebook_link'] ) );

        $architect_contractor_header_banner_social_twitter_link = esc_html( get_theme_mod( 'architect_contractor_header_banner_social_twitter_link',
        $architect_contractor_defaults['architect_contractor_header_banner_social_twitter_link'] ) );

        $architect_contractor_header_banner_social_instagram_link = esc_html( get_theme_mod( 'architect_contractor_header_banner_social_instagram_link',
        $architect_contractor_defaults['architect_contractor_header_banner_social_instagram_link'] ) );

        $architect_contractor_header_banner_social_linkdin_link = esc_html( get_theme_mod( 'architect_contractor_header_banner_social_linkdin_link',
        $architect_contractor_defaults['architect_contractor_header_banner_social_linkdin_link'] ) );

        $architect_contractor_header_banner_social_watsapp_link = esc_html( get_theme_mod( 'architect_contractor_header_banner_social_watsapp_link',
        $architect_contractor_defaults['architect_contractor_header_banner_social_watsapp_link'] ) );

        if( $architect_contractor_header_banner ){

            $architect_contractor_rtl = '';
            if( is_rtl() ){
                $architect_contractor_rtl = 'dir="rtl"';
            }

          $architect_contractor_banner_query = new WP_Query( array('post_type' => 'post', 'posts_per_page' => 4,'post__not_in' => get_option("sticky_posts"), 'category_name' => esc_html( $architect_contractor_header_banner_cat ) ) );

          if( $architect_contractor_banner_query->have_posts() ): ?>

            <div class="main-banner-area">
                <div class="banner-areas-left">
                    <div class="theme-custom-block theme-banner-block">
                        <div class="swiper-container theme-main-carousel swiper-container" <?php echo $architect_contractor_rtl; ?>>

                            <div class="swiper-wrapper">

                              <?php
                              while( $architect_contractor_banner_query->have_posts() ):
                                $architect_contractor_banner_query->the_post();
                                $architect_contractor_featured_image = wp_get_attachment_image_src(get_post_thumbnail_id(), 'large');
                                $architect_contractor_default_image = get_template_directory_uri() . '/inc/homepage-setup/assets/homepage-setup-images/slider-img1.png'; // Replace with the actual path to your default image
                                $architect_contractor_featured_image = isset( $architect_contractor_featured_image[0] ) ? $architect_contractor_featured_image[0] : $architect_contractor_default_image;?>

                                  <div class="swiper-slide main-carousel-item">
                                     
                                          <div class="theme-article-post">
                                          <div class="entry-thumbnail">
                                              <div class="data-bg data-bg-large" data-background="<?php echo esc_url($architect_contractor_featured_image); ?>">
                                                  <a href="<?php the_permalink(); ?>" class="theme-image-responsive" tabindex="0"></a>
                                              </div>
                                              <?php architect_contractor_post_format_icon(); ?>
                                          </div>
                                    
                                          <div class="main-carousel-caption">
                                                <div class="post-content ">

                                                  <header class="entry-header">
                                                        <h2 class="entry-title entry-title-big">
                                                            <a href="<?php the_permalink(); ?>" rel="bookmark"><span><?php the_title(); ?></span></a>
                                                        </h2>
                                                  </header>


                                                  <div class="entry-content">
                                                      <?php
                                                      if (has_excerpt()) {

                                                          the_excerpt();

                                                      } else {

                                                          echo esc_html(wp_trim_words(get_the_content(), 25, '...'));

                                                      } ?>
                                                  </div>

                                                  <a href="<?php the_permalink(); ?>" class="btn-fancy btn-fancy-primary" tabindex="0">
                                                      <?php echo esc_html__('Know More', 'architect-contractor'); ?>
                                                  </a>

                                              </div>
                                          </div>
                                          </div>


                                  </div>

                              <?php endwhile; ?>

                            </div>

                            <div class="swiper-pagination"></div>                  

                        </div>
                    </div>
                </div>
                <div class="banner-areas-right">
                    <div class="media-link">
                        <?php if( $architect_contractor_header_banner_social_facebook_link ){ ?>
                            <a target="_blank" href="<?php echo esc_url( $architect_contractor_header_banner_social_facebook_link ); ?>"><svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 320 512"><!--! Font Awesome Free 6.4.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. --><path d="M279.14 288l14.22-92.66h-88.91v-60.13c0-25.35 12.42-50.06 52.24-50.06h40.42V6.26S260.43 0 225.36 0c-73.22 0-121.08 44.38-121.08 124.72v70.62H22.89V288h81.39v224h100.17V288z"/></svg></a>
                        <?php } ?>
                        <?php if( $architect_contractor_header_banner_social_twitter_link ){ ?>
                            <a target="_blank" href="<?php echo esc_url( $architect_contractor_header_banner_social_twitter_link ); ?>"><svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 512 512"><!--! Font Awesome Free 6.4.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. --><path d="M459.37 151.716c.325 4.548.325 9.097.325 13.645 0 138.72-105.583 298.558-298.558 298.558-59.452 0-114.68-17.219-161.137-47.106 8.447.974 16.568 1.299 25.34 1.299 49.055 0 94.213-16.568 130.274-44.832-46.132-.975-84.792-31.188-98.112-72.772 6.498.974 12.995 1.624 19.818 1.624 9.421 0 18.843-1.3 27.614-3.573-48.081-9.747-84.143-51.98-84.143-102.985v-1.299c13.969 7.797 30.214 12.67 47.431 13.319-28.264-18.843-46.781-51.005-46.781-87.391 0-19.492 5.197-37.36 14.294-52.954 51.655 63.675 129.3 105.258 216.365 109.807-1.624-7.797-2.599-15.918-2.599-24.04 0-57.828 46.782-104.934 104.934-104.934 30.213 0 57.502 12.67 76.67 33.137 23.715-4.548 46.456-13.32 66.599-25.34-7.798 24.366-24.366 44.833-46.132 57.827 21.117-2.273 41.584-8.122 60.426-16.243-14.292 20.791-32.161 39.308-52.628 54.253z"/></svg></a>
                        <?php } ?>
                        <?php if( $architect_contractor_header_banner_social_instagram_link ){ ?>
                            <a target="_blank" href="<?php echo esc_url( $architect_contractor_header_banner_social_instagram_link ); ?>"><svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 448 512"><!--! Font Awesome Free 6.4.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. --><path d="M224.1 141c-63.6 0-114.9 51.3-114.9 114.9s51.3 114.9 114.9 114.9S339 319.5 339 255.9 287.7 141 224.1 141zm0 189.6c-41.1 0-74.7-33.5-74.7-74.7s33.5-74.7 74.7-74.7 74.7 33.5 74.7 74.7-33.6 74.7-74.7 74.7zm146.4-194.3c0 14.9-12 26.8-26.8 26.8-14.9 0-26.8-12-26.8-26.8s12-26.8 26.8-26.8 26.8 12 26.8 26.8zm76.1 27.2c-1.7-35.9-9.9-67.7-36.2-93.9-26.2-26.2-58-34.4-93.9-36.2-37-2.1-147.9-2.1-184.9 0-35.8 1.7-67.6 9.9-93.9 36.1s-34.4 58-36.2 93.9c-2.1 37-2.1 147.9 0 184.9 1.7 35.9 9.9 67.7 36.2 93.9s58 34.4 93.9 36.2c37 2.1 147.9 2.1 184.9 0 35.9-1.7 67.7-9.9 93.9-36.2 26.2-26.2 34.4-58 36.2-93.9 2.1-37 2.1-147.8 0-184.8zM398.8 388c-7.8 19.6-22.9 34.7-42.6 42.6-29.5 11.7-99.5 9-132.1 9s-102.7 2.6-132.1-9c-19.6-7.8-34.7-22.9-42.6-42.6-11.7-29.5-9-99.5-9-132.1s-2.6-102.7 9-132.1c7.8-19.6 22.9-34.7 42.6-42.6 29.5-11.7 99.5-9 132.1-9s102.7-2.6 132.1 9c19.6 7.8 34.7 22.9 42.6 42.6 11.7 29.5 9 99.5 9 132.1s2.7 102.7-9 132.1z"/></svg></a>
                        <?php } ?>
                        <?php if( $architect_contractor_header_banner_social_linkdin_link ){ ?>
                            <a target="_blank" href="<?php echo esc_url( $architect_contractor_header_banner_social_linkdin_link ); ?>"><svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 448 512"><!--! Font Awesome Free 6.4.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. --><path d="M100.28 448H7.4V148.9h92.88zM53.79 108.1C24.09 108.1 0 83.5 0 53.8a53.79 53.79 0 0 1 107.58 0c0 29.7-24.1 54.3-53.79 54.3zM447.9 448h-92.68V302.4c0-34.7-.7-79.2-48.29-79.2-48.29 0-55.69 37.7-55.69 76.7V448h-92.78V148.9h89.08v40.8h1.3c12.4-23.5 42.69-48.3 87.88-48.3 94 0 111.28 61.9 111.28 142.3V448z"/></svg></a>
                        <?php } ?>
                        <?php if( $architect_contractor_header_banner_social_watsapp_link ){ ?>
                            <a target="_blank" href="<?php echo esc_url( $architect_contractor_header_banner_social_watsapp_link ); ?>"><svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 448 512"><!--! Font Awesome Free 6.4.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. --><path d="M380.9 97.1C339 55.1 283.2 32 223.9 32c-122.4 0-222 99.6-222 222 0 39.1 10.2 77.3 29.6 111L0 480l117.7-30.9c32.4 17.7 68.9 27 106.1 27h.1c122.3 0 224.1-99.6 224.1-222 0-59.3-25.2-115-67.1-157zm-157 341.6c-33.2 0-65.7-8.9-94-25.7l-6.7-4-69.8 18.3L72 359.2l-4.4-7c-18.5-29.4-28.2-63.3-28.2-98.2 0-101.7 82.8-184.5 184.6-184.5 49.3 0 95.6 19.2 130.4 54.1 34.8 34.9 56.2 81.2 56.1 130.5 0 101.8-84.9 184.6-186.6 184.6zm101.2-138.2c-5.5-2.8-32.8-16.2-37.9-18-5.1-1.9-8.8-2.8-12.5 2.8-3.7 5.6-14.3 18-17.6 21.8-3.2 3.7-6.5 4.2-12 1.4-32.6-16.3-54-29.1-75.5-66-5.7-9.8 5.7-9.1 16.3-30.3 1.8-3.7.9-6.9-.5-9.7-1.4-2.8-12.5-30.1-17.1-41.2-4.5-10.8-9.1-9.3-12.5-9.5-3.2-.2-6.9-.2-10.6-.2-3.7 0-9.7 1.4-14.8 6.9-5.1 5.6-19.4 19-19.4 46.3 0 27.3 19.9 53.7 22.6 57.4 2.8 3.7 39.1 59.7 94.8 83.8 35.2 15.2 49 16.5 66.6 13.9 10.7-1.6 32.8-13.4 37.4-26.4 4.6-13 4.6-24.1 3.2-26.4-1.3-2.5-5-3.9-10.5-6.6z"/></svg></a>
                        <?php } ?>
                    </div>
                </div>
            </div>

          <?php
          wp_reset_postdata();
          endif;

        }

    }

endif;

if (!function_exists('architect_contractor_post_format_icon')):

    // Post Format Icon.
    function architect_contractor_post_format_icon() {

        $architect_contractor_format = get_post_format(get_the_ID()) ?: 'standard';
        $architect_contractor_icon = '';
        $architect_contractor_title = '';
        if( $architect_contractor_format == 'video' ){
            $architect_contractor_icon = architect_contractor_get_theme_svg( 'video' );
            $architect_contractor_title = esc_html__('Video','architect-contractor');
        }elseif( $architect_contractor_format == 'audio' ){
            $architect_contractor_icon = architect_contractor_get_theme_svg( 'audio' );
            $architect_contractor_title = esc_html__('Audio','architect-contractor');
        }elseif( $architect_contractor_format == 'gallery' ){
            $architect_contractor_icon = architect_contractor_get_theme_svg( 'gallery' );
            $architect_contractor_title = esc_html__('Gallery','architect-contractor');
        }elseif( $architect_contractor_format == 'quote' ){
            $architect_contractor_icon = architect_contractor_get_theme_svg( 'quote' );
            $architect_contractor_title = esc_html__('Quote','architect-contractor');
        }elseif( $architect_contractor_format == 'image' ){
            $architect_contractor_icon = architect_contractor_get_theme_svg( 'image' );
            $architect_contractor_title = esc_html__('Image','architect-contractor');
        } elseif( $architect_contractor_format == 'link' ){
            $architect_contractor_icon = architect_contractor_get_theme_svg( 'link' );
            $architect_contractor_title = esc_html__('Link','architect-contractor');
        } elseif( $architect_contractor_format == 'status' ){
            $architect_contractor_icon = architect_contractor_get_theme_svg( 'status' );
            $architect_contractor_title = esc_html__('Status','architect-contractor');
        } elseif( $architect_contractor_format == 'aside' ){
            $architect_contractor_icon = architect_contractor_get_theme_svg( 'aside' );
            $architect_contractor_title = esc_html__('Aside','architect-contractor');
        } elseif( $architect_contractor_format == 'chat' ){
            $architect_contractor_icon = architect_contractor_get_theme_svg( 'chat' );
            $architect_contractor_title = esc_html__('Chat','architect-contractor');
        }
        
        if (!empty($architect_contractor_icon)) { ?>
            <div class="theme-post-format">
                <span class="post-format-icom"><?php echo architect_contractor_svg_escape($architect_contractor_icon); ?></span>
                <?php if( $architect_contractor_title ){ echo '<span class="post-format-label">'.esc_html( $architect_contractor_title ).'</span>'; } ?>
            </div>
        <?php }
    }

endif;

if ( ! function_exists( 'architect_contractor_svg_escape' ) ):

    /**
     * Get information about the SVG icon.
     *
     * @param string $architect_contractor_svg_name The name of the icon.
     * @param string $group The group the icon belongs to.
     * @param string $color Color code.
     */
    function architect_contractor_svg_escape( $architect_contractor_input ) {

        // Make sure that only our allowed tags and attributes are included.
        $architect_contractor_svg = wp_kses(
            $architect_contractor_input,
            array(
                'svg'     => array(
                    'class'       => true,
                    'xmlns'       => true,
                    'width'       => true,
                    'height'      => true,
                    'viewbox'     => true,
                    'aria-hidden' => true,
                    'role'        => true,
                    'focusable'   => true,
                ),
                'path'    => array(
                    'fill'      => true,
                    'fill-rule' => true,
                    'd'         => true,
                    'transform' => true,
                ),
                'polygon' => array(
                    'fill'      => true,
                    'fill-rule' => true,
                    'points'    => true,
                    'transform' => true,
                    'focusable' => true,
                ),
            )
        );

        if ( ! $architect_contractor_svg ) {
            return false;
        }

        return $architect_contractor_svg;

    }

endif;

if( !function_exists( 'architect_contractor_sanitize_sidebar_option_meta' ) ) :

    // Sidebar Option Sanitize.
    function architect_contractor_sanitize_sidebar_option_meta( $architect_contractor_input ){

        $architect_contractor_metabox_options = array( 'global-sidebar','left-sidebar','right-sidebar','no-sidebar' );
        if( in_array( $architect_contractor_input,$architect_contractor_metabox_options ) ){

            return $architect_contractor_input;

        }else{

            return '';

        }
    }

endif;

if( !function_exists( 'architect_contractor_sanitize_pagination_meta' ) ) :

    // Sidebar Option Sanitize.
    function architect_contractor_sanitize_pagination_meta( $architect_contractor_input ){

        $architect_contractor_metabox_options = array( 'Center','Right','Left');
        if( in_array( $architect_contractor_input,$architect_contractor_metabox_options ) ){

            return $architect_contractor_input;

        }else{

            return '';

        }
    }

endif;

if( !function_exists( 'architect_contractor_services_slider' ) ) :

    function architect_contractor_services_slider(){

        $architect_contractor_defaults = architect_contractor_get_default_theme_options();
        $architect_contractor_services = get_theme_mod( 'architect_contractor_services', $architect_contractor_defaults['architect_contractor_services'] );
        $architect_contractor_services_cat = get_theme_mod( 'architect_contractor_services_cat' );

        $architect_contractor_services_section_title = esc_html( get_theme_mod( 'architect_contractor_services_section_title',
        $architect_contractor_defaults['architect_contractor_services_section_title'] ) );

        $architect_contractor_services_section_short_title = esc_html( get_theme_mod( 'architect_contractor_services_section_short_title',
        $architect_contractor_defaults['architect_contractor_services_section_short_title'] ) );

        if( $architect_contractor_services ){

            $architect_contractor_rtl = '';
            if( is_rtl() ){
                $architect_contractor_rtl = 'dir="rtl"';
            }

          $architect_contractor_services_query = new WP_Query( array('post_type' => 'post', 'posts_per_page' => 4,'post__not_in' => get_option("sticky_posts"), 'category_name' => esc_html( $architect_contractor_services_cat ) ) );

          if( $architect_contractor_services_query->have_posts() ): ?>

            <div class="theme-custom-block theme-banner-block theme-services-block">
                <div class="theme-custom-block-heading">
                    <div class="wrapper">
                        <?php if( $architect_contractor_services_section_short_title ){ ?>
                            <h6><?php echo esc_html( $architect_contractor_services_section_short_title ); ?></h6>
                        <?php } ?>

                        <?php if( $architect_contractor_services_section_title ){ ?>
                            <h2><?php echo esc_html( $architect_contractor_services_section_title ); ?></h2>
                        <?php } ?>
                    </div>
                </div>                
                <div class="swiper-container theme-main-carousel swiper-container" <?php echo $architect_contractor_rtl; ?>>

                    <div class="swiper-wrapper">

                      <?php
                      while( $architect_contractor_services_query->have_posts() ):
                        $architect_contractor_services_query->the_post();
                        $architect_contractor_featured_image = wp_get_attachment_image_src(get_post_thumbnail_id(), 'large');
                                $architect_contractor_default_image = get_template_directory_uri() . '/inc/homepage-setup/assets/homepage-setup-images/post-img01.png'; // Replace with the actual path to your default image
                                $architect_contractor_featured_image = isset( $architect_contractor_featured_image[0] ) ? $architect_contractor_featured_image[0] : $architect_contractor_default_image;?>

                          <div class="swiper-slide main-carousel-item">
                             
                                <div class="theme-article-post">
                                    <div class="box">
                                        <div class="entry-thumbnail">
                                            <div class="data-bg data-bg-large" data-background="<?php echo esc_url($architect_contractor_featured_image); ?>">
                                                <a href="<?php the_permalink(); ?>" class="theme-image-responsive" tabindex="0"></a>
                                            </div>
                                            <?php architect_contractor_post_format_icon(); ?>
                                        </div>
                                        <div class="box-content">
                                            <h3 class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                                            <span class="post"> 
                                                <?php if (has_excerpt()) {
                                                    the_excerpt();
                                                } else {
                                                    echo esc_html(wp_trim_words(get_the_content(), 10, '...'));
                                                } ?>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </div>

                      <?php endwhile; ?>

                    </div>

                    <div class="swiper-pagination"></div>

                </div>
            </div>

          <?php
          wp_reset_postdata();
          endif;

        }

    }

endif;

if( !function_exists( 'architect_contractor_architect_contractor_counter_slider' ) ) :

    function architect_contractor_architect_contractor_counter_slider(){

        $architect_contractor_defaults = architect_contractor_get_default_theme_options();
        $architect_contractor_architect_contractor_counter = get_theme_mod( 'architect_contractor_architect_contractor_counter', $architect_contractor_defaults['architect_contractor_architect_contractor_counter'] );
        $architect_contractor_architect_contractor_counter_cat = get_theme_mod( 'architect_contractor_architect_contractor_counter_cat' );

        if( $architect_contractor_architect_contractor_counter ){

            $architect_contractor_rtl = '';
            if( is_rtl() ){
                $architect_contractor_rtl = 'dir="rtl"';
            }

          $architect_contractor_counter_query = new WP_Query( array('post_type' => 'post', 'posts_per_page' => 4,'post__not_in' => get_option("sticky_posts"), 'category_name' => esc_html( $architect_contractor_architect_contractor_counter_cat ) ) );

          if( $architect_contractor_counter_query->have_posts() ): ?>

            <div class="theme-custom-block theme-counter-block">
                <div class="wrapper">
                    <div class="swiper-container theme-main-carousel swiper-container" <?php echo $architect_contractor_rtl; ?>>
                        <div class="swiper-wrapper">
                            <?php
                            while( $architect_contractor_counter_query->have_posts() ):
                            $architect_contractor_counter_query->the_post();
                            $architect_contractor_architect_contractor_counter_featured_image = wp_get_attachment_image_src(get_post_thumbnail_id(), 'large');
                                $architect_contractor_default_image = get_template_directory_uri() . '/inc/homepage-setup/assets/homepage-setup-images/post-img1.png'; // Replace with the actual path to your default image
                                $architect_contractor_architect_contractor_counter_featured_image = isset( $architect_contractor_architect_contractor_counter_featured_image[0] ) ? $architect_contractor_architect_contractor_counter_featured_image[0] : $architect_contractor_default_image;?>
                                <div class="swiper-slide main-carousel-item">
                                    <div class="theme-counter-post">
                                        <div class="entry-thumbnail">
                                            <div class="data-bg data-bg-large" data-background="<?php echo esc_url($architect_contractor_architect_contractor_counter_featured_image); ?>">
                                                <a href="<?php the_permalink(); ?>" class="theme-image-responsive" tabindex="0"></a>
                                            </div>
                                            <?php architect_contractor_post_format_icon(); ?>
                                        </div>
                                        <div class="post-content">
                                            <header class="entry-header">
                                                <p class="entry-title entry-title-big">
                                                   <?php the_title(); ?>
                                                </p>
                                            </header>
                                        </div>
                                    </div>
                                </div>
                            <?php endwhile; ?>
                        </div>
                        <div class="swiper-pagination"></div>
                    </div>
                </div>
            </div>

          <?php
          wp_reset_postdata();
          endif;

        }

    }

endif;

if( !function_exists( 'architect_contractor_sanitize_menu_transform' ) ) :

    // Sidebar Option Sanitize.
    function architect_contractor_sanitize_menu_transform( $architect_contractor_input ){

        $architect_contractor_metabox_options = array( 'capitalize','uppercase','lowercase');
        if( in_array( $architect_contractor_input,$architect_contractor_metabox_options ) ){

            return $architect_contractor_input;

        }else{

            return '';

        }
    }

endif;

if( !function_exists( 'architect_contractor_sanitize_page_content_alignment' ) ) :

    // Sidebar Option Sanitize.
    function architect_contractor_sanitize_page_content_alignment( $architect_contractor_input ){

        $architect_contractor_metabox_options = array( 'left','center','right');
        if( in_array( $architect_contractor_input,$architect_contractor_metabox_options ) ){

            return $architect_contractor_input;

        }else{

            return '';

        }
    }

endif;

if( !function_exists( 'architect_contractor_sanitize_footer_widget_title_alignment' ) ) :

    // Footer Option Sanitize.
    function architect_contractor_sanitize_footer_widget_title_alignment( $architect_contractor_input ){

        $architect_contractor_metabox_options = array( 'left','center','right');
        if( in_array( $architect_contractor_input,$architect_contractor_metabox_options ) ){

            return $architect_contractor_input;

        }else{

            return '';

        }
    }

endif;


if( !function_exists( 'architect_contractor_sanitize_pagination_type' ) ) :

    /**
     * Sanitize the pagination type setting.
     *
     * @param string $architect_contractor_input The input value from the Customizer.
     * @return string The sanitized value.
     */
    function architect_contractor_sanitize_pagination_type( $architect_contractor_input ) {
        // Define valid options for the pagination type.
        $architect_contractor_valid_options = array( 'numeric', 'newer_older' ); // Update valid options to include 'newer_older'

        // If the input is one of the valid options, return it. Otherwise, return the default option ('numeric').
        if ( in_array( $architect_contractor_input, $architect_contractor_valid_options, true ) ) {
            return $architect_contractor_input;
        } else {
            // Return 'numeric' as the fallback if the input is invalid.
            return 'numeric';
        }
    }

endif;


// Sanitize the enable/disable setting for pagination
if( !function_exists('architect_contractor_sanitize_enable_pagination') ) :
    function architect_contractor_sanitize_enable_pagination( $architect_contractor_input ) {
        return (bool) $architect_contractor_input;
    }
endif;

if( !function_exists( 'architect_contractor_sanitize_copyright_alignment_meta' ) ) :

    // Sidebar Option Sanitize.
    function architect_contractor_sanitize_copyright_alignment_meta( $architect_contractor_input ){

        $architect_contractor_metabox_options = array( 'Default','Reverse','Center');
        if( in_array( $architect_contractor_input,$architect_contractor_metabox_options ) ){

            return $architect_contractor_input;

        }else{

            return '';

        }
    }

endif;

/**
 * Sidebar Layout Function
 */
function architect_contractor_get_final_sidebar_layout() {
	$architect_contractor_defaults       = architect_contractor_get_default_theme_options();
	$architect_contractor_global_layout  = get_theme_mod('architect_contractor_global_sidebar_layout', $architect_contractor_defaults['architect_contractor_global_sidebar_layout']);
	$architect_contractor_page_layout    = get_theme_mod('architect_contractor_page_sidebar_layout', $architect_contractor_global_layout);
	$architect_contractor_post_layout    = get_theme_mod('architect_contractor_post_sidebar_layout', $architect_contractor_global_layout);
	$architect_contractor_meta_layout    = get_post_meta(get_the_ID(), 'architect_contractor_post_sidebar_option', true);

	if (!empty($architect_contractor_meta_layout) && $architect_contractor_meta_layout !== 'default') {
		return $architect_contractor_meta_layout;
	}
	if (is_page() || (function_exists('is_shop') && is_shop())) {
		return $architect_contractor_page_layout;
	}
	if (is_single()) {
		return $architect_contractor_post_layout;
	}
	return $architect_contractor_global_layout;
}