<?php
/**
 * Architect Contractor functions and definitions
 * @package Architect Contractor
 */

if ( ! function_exists( 'architect_contractor_after_theme_support' ) ) :

	function architect_contractor_after_theme_support() {
		
		add_theme_support( 'automatic-feed-links' );

		add_theme_support('woocommerce');
        add_theme_support('wc-product-gallery-zoom');
        add_theme_support('wc-product-gallery-lightbox');
        add_theme_support('wc-product-gallery-slider');
        add_theme_support('woocommerce', array(
            'gallery_thumbnail_image_width' => 300,
        ));

        load_theme_textdomain( 'architect-contractor', get_template_directory() . '/languages' );

		add_theme_support(
			'custom-background',
			array(
				'default-color' => 'ffffff',
			)
		);

		$GLOBALS['content_width'] = apply_filters( 'architect_contractor_content_width', 1140 );
		
		add_theme_support( 'post-thumbnails' );

		add_theme_support(
			'custom-logo',
			array(
				'height'      => 270,
				'width'       => 90,
				'flex-height' => true,
				'flex-width'  => true,
			)
		);
		
		add_theme_support( 'title-tag' );

		add_theme_support(
			'html5',
			array(
				'search-form',
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
				'script',
				'style',
			)
		);

		add_theme_support( 'post-formats', array(
			'video',  
			'audio',  
			'gallery',
			'quote',  
			'image',  
			'link',   
			'status', 
			'aside',  
			'chat',   
		) );
		
		add_theme_support( 'align-wide' );
		add_theme_support( 'responsive-embeds' );
		add_theme_support( 'wp-block-styles' );

		add_editor_style('/lib/custom/css/editor-style.css');

		require get_template_directory() . '/inc/metabox.php';
		require get_template_directory() . '/inc/homepage-setup/homepage-setup-settings.php';

		if (! defined( 'ARCHITECT_CONTRACTOR_DOCS_PRO' ) ){
		define('ARCHITECT_CONTRACTOR_DOCS_PRO',__('https://layout.omegathemes.com/steps/pro-architect-contractor/','architect-contractor'));
		}
		if (! defined( 'ARCHITECT_CONTRACTOR_BUY_NOW' ) ){
		define('ARCHITECT_CONTRACTOR_BUY_NOW',__('https://www.omegathemes.com/products/contractor-wordpress-theme','architect-contractor'));
		}
		if (! defined( 'ARCHITECT_CONTRACTOR_SUPPORT_FREE' ) ){
		define('ARCHITECT_CONTRACTOR_SUPPORT_FREE',__('https://wordpress.org/support/theme/architect-contractor/','architect-contractor'));
		}
		if (! defined( 'ARCHITECT_CONTRACTOR_REVIEW_FREE' ) ){
		define('ARCHITECT_CONTRACTOR_REVIEW_FREE',__('https://wordpress.org/support/theme/architect-contractor/reviews/#new-post/','architect-contractor'));
		}
		if (! defined( 'ARCHITECT_CONTRACTOR_DEMO_PRO' ) ){
		define('ARCHITECT_CONTRACTOR_DEMO_PRO',__('https://layout.omegathemes.com/architect-contractor/','architect-contractor'));
		}
		if (! defined( 'ARCHITECT_CONTRACTOR_LITE_DOCS_PRO' ) ){
		define('ARCHITECT_CONTRACTOR_LITE_DOCS_PRO',__('https://layout.omegathemes.com/steps/free-architect-contractor/','architect-contractor'));
		}
		if (! defined( 'ARCHITECT_CONTRACTOR_BUNDLE_BUTTON' ) ){
			define('ARCHITECT_CONTRACTOR_BUNDLE_BUTTON',__('https://www.omegathemes.com/products/wp-theme-bundle','architect-contractor'));
		}
	}

endif;

add_action( 'after_setup_theme', 'architect_contractor_after_theme_support' );

/**
 * Register and Enqueue Styles.
 */
function architect_contractor_register_styles() {

	wp_enqueue_style( 'dashicons' );

    $architect_contractor_theme_version = wp_get_theme()->get( 'Version' );
	$architect_contractor_fonts_url = architect_contractor_fonts_url();
    if( $architect_contractor_fonts_url ){
    	require get_theme_file_path( 'lib/custom/css/wptt-webfont-loader.php' );
        wp_enqueue_style(
			'architect-contractor-google-fonts',
			architect_contractor_wptt_get_webfont_url( $architect_contractor_fonts_url ),
			array(),
			$architect_contractor_theme_version
		);
    }

    wp_enqueue_style( 'swiper', get_template_directory_uri() . '/lib/swiper/css/swiper-bundle.min.css');
	wp_enqueue_style( 'architect-contractor-style', get_stylesheet_uri(), array(), $architect_contractor_theme_version );

	wp_enqueue_style( 'architect-contractor-style', get_stylesheet_uri() );
	require get_parent_theme_file_path( '/custom_css.php' );
	wp_add_inline_style( 'architect-contractor-style',$architect_contractor_custom_css );

	$architect_contractor_css = '';

	if ( get_header_image() ) :

		$architect_contractor_css .=  '
			.headerbox{
				background-image: url('.esc_url(get_header_image()).');
				-webkit-background-size: cover !important;
				-moz-background-size: cover !important;
				-o-background-size: cover !important;
				background-size: cover !important;
			}';

	endif;

	wp_add_inline_style( 'architect-contractor-style', $architect_contractor_css );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}	

	wp_enqueue_script( 'imagesloaded' );
    wp_enqueue_script( 'masonry' );
	wp_enqueue_script( 'swiper', get_template_directory_uri() . '/lib/swiper/js/swiper-bundle.min.js', array('jquery'), '', 1);
	wp_enqueue_script( 'architect-contractor-custom', get_template_directory_uri() . '/lib/custom/js/theme-custom-script.js', array('jquery'), '', 1);

    // Global Query
    if( is_front_page() ){

    	$architect_contractor_posts_per_page = absint( get_option('posts_per_page') );
        $architect_contractor_c_paged = ( get_query_var( 'page' ) ) ? absint( get_query_var( 'page' ) ) : 1;
        $architect_contractor_posts_args = array(
            'posts_per_page'        => $architect_contractor_posts_per_page,
            'paged'                 => $architect_contractor_c_paged,
        );
        $architect_contractor_posts_qry = new WP_Query( $architect_contractor_posts_args );
        $max = $architect_contractor_posts_qry->max_num_pages;

    }else{
        global $wp_query;
        $max = $wp_query->max_num_pages;
        $architect_contractor_c_paged = ( get_query_var( 'paged' ) > 1 ) ? get_query_var( 'paged' ) : 1;
    }

    $architect_contractor_default = architect_contractor_get_default_theme_options();
    $architect_contractor_pagination_layout = get_theme_mod( 'architect_contractor_pagination_layout',$architect_contractor_default['architect_contractor_pagination_layout'] );
}

add_action( 'wp_enqueue_scripts', 'architect_contractor_register_styles',200 );

function architect_contractor_admin_enqueue_scripts_callback() {
    if ( ! did_action( 'wp_enqueue_media' ) ) {
    wp_enqueue_media();
    }
    wp_enqueue_script('architect-contractor-uploaderjs', get_stylesheet_directory_uri() . '/lib/custom/js/uploader.js', array(), "1.0", true);
}
add_action( 'admin_enqueue_scripts', 'architect_contractor_admin_enqueue_scripts_callback' );

/**
 * Register navigation menus uses wp_nav_menu in five places.
 */
function architect_contractor_menus() {

	$architect_contractor_locations = array(
		'architect-contractor-primary-menu'  => esc_html__( 'Primary Menu', 'architect-contractor' ),
	);

	register_nav_menus( $architect_contractor_locations );
}

add_action( 'init', 'architect_contractor_menus' );

add_filter('loop_shop_columns', 'architect_contractor_loop_columns');
if (!function_exists('architect_contractor_loop_columns')) {
	function architect_contractor_loop_columns() {
		$architect_contractor_columns = get_theme_mod( 'architect_contractor_per_columns', 3 );
		return $architect_contractor_columns;
	}
}

add_filter( 'loop_shop_per_page', 'architect_contractor_per_page', 20 );
function architect_contractor_per_page( $architect_contractor_cols ) {
  	$architect_contractor_cols = get_theme_mod( 'architect_contractor_product_per_page', 9 );
	return $architect_contractor_cols;
}

add_filter( 'woocommerce_output_related_products_args', 'architect_contractor_products_args' );

function architect_contractor_products_args( $architect_contractor_args ) {

    $architect_contractor_args['posts_per_page'] = get_theme_mod( 'architect_contractor_custom_related_products_number', 6 );

    $architect_contractor_args['columns'] = get_theme_mod( 'architect_contractor_custom_related_products_number_per_row', 3 );

    return $architect_contractor_args;
}

require get_template_directory() . '/inc/custom-header.php';
require get_template_directory() . '/classes/class-svg-icons.php';
require get_template_directory() . '/classes/class-walker-menu.php';
require get_template_directory() . '/inc/customizer/customizer.php';
require get_template_directory() . '/inc/custom-functions.php';
require get_template_directory() . '/inc/template-tags.php';
require get_template_directory() . '/classes/body-classes.php';
require get_template_directory() . '/inc/widgets/widgets.php';
require get_template_directory() . '/inc/pagination.php';
require get_template_directory() . '/lib/breadcrumbs/breadcrumbs.php';
require get_template_directory() . '/lib/custom/css/dynamic-style.php';


function architect_contractor_remove_customize_register() {
    global $wp_customize;

    $wp_customize->remove_setting( 'display_header_text' );
    $wp_customize->remove_control( 'display_header_text' );

}

add_action( 'customize_register', 'architect_contractor_remove_customize_register', 11 );

// Apply styles based on customizer settings

function architect_contractor_radio_sanitize(  $architect_contractor_input, $architect_contractor_setting  ) {
	$architect_contractor_input = sanitize_key( $architect_contractor_input );
	$architect_contractor_choices = $architect_contractor_setting->manager->get_control( $architect_contractor_setting->id )->choices;
	return ( array_key_exists( $architect_contractor_input, $architect_contractor_choices ) ? $architect_contractor_input : $architect_contractor_setting->default );
}
require get_template_directory() . '/inc/general.php';

function architect_contractor_sticky_sidebar_enabled() {
    $architect_contractor_sticky_sidebar = get_theme_mod('architect_contractor_sticky_sidebar', true);
    
    if ($architect_contractor_sticky_sidebar == false) {
        $architect_contractor_custom_css = ".widget-area-wrapper { position: relative !important; }";
        wp_add_inline_style('architect-contractor-style', $architect_contractor_custom_css);
    }
}
add_action('wp_enqueue_scripts', 'architect_contractor_sticky_sidebar_enabled');


// NOTICE FUNCTION

function architect_contractor_admin_notice() { 
    global $pagenow;
    $theme_args = wp_get_theme();
    $meta = get_option( 'architect_contractor_admin_notice' );
    $name = $theme_args->get( 'Name' );
    $current_screen = get_current_screen();

    if ( ! $meta ) {
        if ( is_network_admin() ) {
            return;
        }

        if ( ! current_user_can( 'manage_options' ) ) {
            return;
        }

        if ( $current_screen->base != 'appearance_page_architectcontractor-wizard' ) {
            ?>
            <div class="notice notice-success notice-content">
                <h2><?php esc_html_e('Welcome! Thank you for choosing Architect Contractor. Let’s Set Up Your Website!', 'architect-contractor') ?> </h2>
                <p><?php esc_html_e('Before you dive into customization, let’s go through a quick setup process to ensure everything runs smoothly. Click below to start setting up your website in minutes!', 'architect-contractor') ?> </p>
                <div class="info-link">
                    <a href="<?php echo esc_url( admin_url( 'themes.php?page=architectcontractor-wizard' ) ); ?>"><?php esc_html_e('Get Started with Architect Contractor', 'architect-contractor'); ?></a>
                </div>
                <p class="dismiss-link"><strong><a href="?architect_contractor_admin_notice=1"><?php esc_html_e( 'Dismiss', 'architect-contractor' ); ?></a></strong></p>
            </div>
            <?php
        }
    }
}
add_action( 'admin_notices', 'architect_contractor_admin_notice' );

if ( ! function_exists( 'architect_contractor_update_admin_notice' ) ) :
/**
 * Updating admin notice on dismiss
 */
function architect_contractor_update_admin_notice() {
    if ( isset( $_GET['architect_contractor_admin_notice'] ) && $_GET['architect_contractor_admin_notice'] == '1' ) {
        update_option( 'architect_contractor_admin_notice', true );
    }
}
endif;
add_action( 'admin_init', 'architect_contractor_update_admin_notice' );

// After Switch theme function
add_action( 'after_switch_theme', 'architect_contractor_getstart_setup_options' );
function architect_contractor_getstart_setup_options() {
    update_option( 'architect_contractor_admin_notice', false );
}