<?php
/**
 * Custom page walker for this theme.
 *
 * @package Architect  Contractor
 */

if (!class_exists('architect_contractor_Walker_Page')) {
    /**
     * CUSTOM PAGE WALKER
     * A custom walker for pages.
     */
    class architect_contractor_Walker_Page extends Walker_Page
    {

        /**
         * Outputs the beginning of the current element in the tree.
         *
         * @param string $architect_contractor_output Used to append additional content. Passed by reference.
         * @param WP_Post $page Page data object.
         * @param int $architect_contractor_depth Optional. Depth of page. Used for padding. Default 0.
         * @param array $architect_contractor_args Optional. Array of arguments. Default empty array.
         * @param int $current_page Optional. Page ID. Default 0.
         * @since 2.1.0
         *
         * @see Walker::start_el()
         */

        public function start_lvl( &$architect_contractor_output, $architect_contractor_depth = 0, $architect_contractor_args = array() ) {
            $architect_contractor_indent  = str_repeat( "\t", $architect_contractor_depth );
            $architect_contractor_output .= "$architect_contractor_indent<ul class='sub-menu'>\n";
        }

        public function start_el(&$architect_contractor_output, $page, $architect_contractor_depth = 0, $architect_contractor_args = array(), $current_page = 0)
        {

            if (isset($architect_contractor_args['item_spacing']) && 'preserve' === $architect_contractor_args['item_spacing']) {
                $t = "\t";
                $n = "\n";
            } else {
                $t = '';
                $n = '';
            }
            if ($architect_contractor_depth) {
                $architect_contractor_indent = str_repeat($t, $architect_contractor_depth);
            } else {
                $architect_contractor_indent = '';
            }

            $architect_contractor_css_class = array('page_item', 'page-item-' . $page->ID);

            if (isset($architect_contractor_args['pages_with_children'][$page->ID])) {
                $architect_contractor_css_class[] = 'page_item_has_children';
            }

            if (!empty($current_page)) {
                $_current_page = get_post($current_page);
                if ($_current_page && in_array($page->ID, $_current_page->ancestors, true)) {
                    $architect_contractor_css_class[] = 'current_page_ancestor';
                }
                if ($page->ID === $current_page) {
                    $architect_contractor_css_class[] = 'current_page_item';
                } elseif ($_current_page && $page->ID === $_current_page->post_parent) {
                    $architect_contractor_css_class[] = 'current_page_parent';
                }
            } elseif (get_option('page_for_posts') === $page->ID) {
                $architect_contractor_css_class[] = 'current_page_parent';
            }

            /** This filter is documented in wp-includes/class-walker-page.php */
            $architect_contractor_css_classes = implode(' ', apply_filters('page_css_class', $architect_contractor_css_class, $page, $architect_contractor_depth, $architect_contractor_args, $current_page));
            $architect_contractor_css_classes = $architect_contractor_css_classes ? ' class="' . esc_attr($architect_contractor_css_classes) . '"' : '';

            if ('' === $page->post_title) {
                /* translators: %d: ID of a post. */
                $page->post_title = sprintf(__('#%d (no title)', 'architect-contractor'), $page->ID);
            }

            $architect_contractor_args['link_before'] = empty($architect_contractor_args['link_before']) ? '' : $architect_contractor_args['link_before'];
            $architect_contractor_args['link_after'] = empty($architect_contractor_args['link_after']) ? '' : $architect_contractor_args['link_after'];

            $architect_contractor_atts = array();
            $architect_contractor_atts['href'] = get_permalink($page->ID);
            $architect_contractor_atts['aria-current'] = ($page->ID === $current_page) ? 'page' : '';

            /** This filter is documented in wp-includes/class-walker-page.php */
            $architect_contractor_atts = apply_filters('page_menu_link_attributes', $architect_contractor_atts, $page, $architect_contractor_depth, $architect_contractor_args, $current_page);

            $architect_contractor_attributes = '';
            foreach ($architect_contractor_atts as $attr => $architect_contractor_value) {
                if (!empty($architect_contractor_value)) {
                    $architect_contractor_value = ('href' === $attr) ? esc_url($architect_contractor_value) : esc_attr($architect_contractor_value);
                    $architect_contractor_attributes .= ' ' . $attr . '="' . $architect_contractor_value . '"';
                }
            }

            $architect_contractor_args['list_item_before'] = '';
            $architect_contractor_args['list_item_after'] = '';
            $architect_contractor_args['icon_rennder'] = '';
            // Wrap the link in a div and append a sub menu toggle.
            if (isset($architect_contractor_args['show_toggles']) && true === $architect_contractor_args['show_toggles']) {
                // Wrap the menu item link contents in a div, used for positioning.
                $architect_contractor_args['list_item_after'] = '';
            }


            // Add icons to menu items with children.
            if (isset($architect_contractor_args['show_sub_menu_icons']) && true === $architect_contractor_args['show_sub_menu_icons']) {
                if (isset($architect_contractor_args['pages_with_children'][$page->ID])) {
                    $architect_contractor_args['icon_rennder'] = '';
                }
            }

            // Add icons to menu items with children.
            if (isset($architect_contractor_args['show_toggles']) && true === $architect_contractor_args['show_toggles']) {
                if (isset($architect_contractor_args['pages_with_children'][$page->ID])) {

                    $toggle_target_string = '.page_item.page-item-' . $page->ID . ' > .sub-menu';

                    $architect_contractor_args['list_item_after'] = '<button type="button" class="theme-aria-button submenu-toggle" data-toggle-target="' . $toggle_target_string . '" data-toggle-type="slidetoggle" data-toggle-duration="250"><span class="btn__content" tabindex="-1"><span class="screen-reader-text">' . __( 'Show sub menu', 'architect-contractor' ) . '</span>' . architect_contractor_get_theme_svg( 'chevron-down' ) . '</span></button>';
                }
            }

            if (isset($architect_contractor_args['show_toggles']) && true === $architect_contractor_args['show_toggles']) {

                $architect_contractor_output .= $architect_contractor_indent . sprintf(
                        '<li%s>%s%s<a%s>%s%s%s</a>%s%s',
                        $architect_contractor_css_classes,
                        '<div class="submenu-wrapper">',
                        $architect_contractor_args['list_item_before'],
                        $architect_contractor_attributes,
                        $architect_contractor_args['link_before'],
                        /** This filter is documented in wp-includes/post-template.php */
                        apply_filters('the_title', $page->post_title, $page->ID),
                        $architect_contractor_args['link_after'],
                        $architect_contractor_args['list_item_after'],
                        '</div>'
                    );

            }else{

                $architect_contractor_output .= $architect_contractor_indent . sprintf(
                        '<li%s>%s<a%s>%s%s%s%s</a>%s',
                        $architect_contractor_css_classes,
                        $architect_contractor_args['list_item_before'],
                        $architect_contractor_attributes,
                        $architect_contractor_args['link_before'],
                        /** This filter is documented in wp-includes/post-template.php */
                        apply_filters('the_title', $page->post_title, $page->ID),
                        $architect_contractor_args['icon_rennder'],
                        $architect_contractor_args['link_after'],
                        $architect_contractor_args['list_item_after']
                    );

            }

            if (!empty($architect_contractor_args['show_date'])) {
                if ('modified' === $architect_contractor_args['show_date']) {
                    $architect_contractor_time = $page->post_modified;
                } else {
                    $architect_contractor_time = $page->post_date;
                }

                $architect_contractor_date_format = empty($architect_contractor_args['date_format']) ? '' : $architect_contractor_args['date_format'];
                $architect_contractor_output .= ' ' . mysql2date($architect_contractor_date_format, $architect_contractor_time);
            }
        }
    }
}